/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.AdjustablePayment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.credit.CdsTrade;
import com.opengamma.strata.product.credit.type.CdsConvention;
import com.opengamma.strata.product.credit.type.CdsTemplate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class DatesCdsTemplate
implements CdsTemplate,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CdsConvention convention;
    private static final long serialVersionUID = 1L;

    public static DatesCdsTemplate of(LocalDate startDate, LocalDate endDate, CdsConvention convention) {
        ArgChecker.inOrderNotEqual((Comparable)startDate, (Object)endDate, (String)"startDate", (String)"endDate");
        return new DatesCdsTemplate(startDate, endDate, convention);
    }

    @Override
    public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        ArgChecker.inOrderNotEqual((Comparable)tradeDate, (Object)this.endDate, (String)"tradeDate", (String)"endDate");
        return this.convention.createTrade(legalEntityId, tradeDate, this.startDate, this.endDate, buySell, notional, fixedRate, refData);
    }

    @Override
    public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, BuySell buySell, double notional, double fixedRate, AdjustablePayment upFrontFee, ReferenceData refData) {
        ArgChecker.inOrderNotEqual((Comparable)tradeDate, (Object)this.endDate, (String)"tradeDate", (String)"endDate");
        return this.convention.createTrade(legalEntityId, tradeDate, this.startDate, this.endDate, buySell, notional, fixedRate, upFrontFee, refData);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private DatesCdsTemplate(LocalDate startDate, LocalDate endDate, CdsConvention convention) {
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)convention, (String)"convention");
        this.startDate = startDate;
        this.endDate = endDate;
        this.convention = convention;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Override
    public CdsConvention getConvention() {
        return this.convention;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DatesCdsTemplate other = (DatesCdsTemplate)obj;
            return JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.convention, (Object)other.convention);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("DatesCdsTemplate{");
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DatesCdsTemplate> {
        private LocalDate startDate;
        private LocalDate endDate;
        private CdsConvention convention;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 2039569265: {
                    this.convention = (CdsConvention)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DatesCdsTemplate build() {
            return new DatesCdsTemplate(this.startDate, this.endDate, this.convention);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("DatesCdsTemplate.Builder{");
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", DatesCdsTemplate.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", DatesCdsTemplate.class, LocalDate.class);
        private final MetaProperty<CdsConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", DatesCdsTemplate.class, CdsConvention.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"startDate", "endDate", "convention"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DatesCdsTemplate> builder() {
            return new Builder();
        }

        public Class<? extends DatesCdsTemplate> beanType() {
            return DatesCdsTemplate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<CdsConvention> convention() {
            return this.convention;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return ((DatesCdsTemplate)bean).getStartDate();
                }
                case -1607727319: {
                    return ((DatesCdsTemplate)bean).getEndDate();
                }
                case 2039569265: {
                    return ((DatesCdsTemplate)bean).getConvention();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

