/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit.type;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.AdjustablePayment;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.credit.Cds;
import com.opengamma.strata.product.credit.CdsTrade;
import com.opengamma.strata.product.credit.PaymentOnDefault;
import com.opengamma.strata.product.credit.ProtectionStartOfDay;
import com.opengamma.strata.product.credit.type.CdsConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableCdsConvention
implements CdsConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final Frequency paymentFrequency;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment startDateBusinessDayAdjustment;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment endDateBusinessDayAdjustment;
    @PropertyDefinition(validate="notNull")
    private final StubConvention stubConvention;
    @PropertyDefinition(validate="notNull")
    private final RollConvention rollConvention;
    @PropertyDefinition(validate="notNull")
    private final PaymentOnDefault paymentOnDefault;
    @PropertyDefinition(validate="notNull")
    private final ProtectionStartOfDay protectionStart;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment stepinDateOffset;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment settlementDateOffset;
    private static final long serialVersionUID = 1L;

    public static ImmutableCdsConvention of(String name, Currency currency, DayCount dayCount, Frequency paymentFrequency, BusinessDayAdjustment businessDayAdjustment, DaysAdjustment settlementDateOffset) {
        return ImmutableCdsConvention.builder().name(name).currency(currency).dayCount(dayCount).paymentFrequency(paymentFrequency).businessDayAdjustment(businessDayAdjustment).settlementDateOffset(settlementDateOffset).build();
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.stubConvention == null) {
            builder.stubConvention = StubConvention.SMART_INITIAL;
        }
        if (builder.paymentOnDefault == null) {
            builder.paymentOnDefault = PaymentOnDefault.ACCRUED_PREMIUM;
        }
        if (builder.rollConvention == null) {
            builder.rollConvention = RollConventions.DAY_20;
        }
        if (builder.protectionStart == null) {
            builder.protectionStart = ProtectionStartOfDay.BEGINNING;
        }
        if (builder.stepinDateOffset == null) {
            builder.stepinDateOffset = DaysAdjustment.ofCalendarDays((int)1);
        }
    }

    public BusinessDayAdjustment getStartDateBusinessDayAdjustment() {
        return this.startDateBusinessDayAdjustment != null ? this.startDateBusinessDayAdjustment : this.businessDayAdjustment;
    }

    public BusinessDayAdjustment getEndDateBusinessDayAdjustment() {
        return this.endDateBusinessDayAdjustment != null ? this.endDateBusinessDayAdjustment : BusinessDayAdjustment.NONE;
    }

    @Override
    public CdsTrade toTrade(StandardId legalEntityId, TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRate) {
        Cds product = Cds.builder().legalEntityId(legalEntityId).paymentSchedule(PeriodicSchedule.builder().startDate(startDate).endDate(endDate).frequency(this.paymentFrequency).businessDayAdjustment(this.businessDayAdjustment).startDateBusinessDayAdjustment(this.getStartDateBusinessDayAdjustment()).endDateBusinessDayAdjustment(this.getEndDateBusinessDayAdjustment()).stubConvention(this.stubConvention).rollConvention(this.rollConvention).build()).buySell(buySell).currency(this.currency).dayCount(this.dayCount).notional(notional).fixedRate(fixedRate).paymentOnDefault(this.paymentOnDefault).protectionStart(this.protectionStart).stepinDateOffset(this.stepinDateOffset).settlementDateOffset(this.settlementDateOffset).build();
        return CdsTrade.builder().info(tradeInfo).product(product).build();
    }

    @Override
    public CdsTrade toTrade(StandardId legalEntityId, TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRate, AdjustablePayment upfrontFee) {
        Cds product = Cds.builder().legalEntityId(legalEntityId).paymentSchedule(PeriodicSchedule.builder().startDate(startDate).endDate(endDate).frequency(this.paymentFrequency).businessDayAdjustment(this.businessDayAdjustment).startDateBusinessDayAdjustment(this.getStartDateBusinessDayAdjustment()).endDateBusinessDayAdjustment(this.getEndDateBusinessDayAdjustment()).stubConvention(this.stubConvention).rollConvention(this.rollConvention).build()).buySell(buySell).currency(this.currency).dayCount(this.dayCount).notional(notional).fixedRate(fixedRate).paymentOnDefault(this.paymentOnDefault).protectionStart(this.protectionStart).stepinDateOffset(this.stepinDateOffset).settlementDateOffset(this.settlementDateOffset).build();
        return CdsTrade.builder().info(tradeInfo).product(product).upfrontFee(upfrontFee).build();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableCdsConvention(String name, Currency currency, DayCount dayCount, Frequency paymentFrequency, BusinessDayAdjustment businessDayAdjustment, BusinessDayAdjustment startDateBusinessDayAdjustment, BusinessDayAdjustment endDateBusinessDayAdjustment, StubConvention stubConvention, RollConvention rollConvention, PaymentOnDefault paymentOnDefault, ProtectionStartOfDay protectionStart, DaysAdjustment stepinDateOffset, DaysAdjustment settlementDateOffset) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)paymentFrequency, (String)"paymentFrequency");
        JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        JodaBeanUtils.notNull((Object)stubConvention, (String)"stubConvention");
        JodaBeanUtils.notNull((Object)rollConvention, (String)"rollConvention");
        JodaBeanUtils.notNull((Object)((Object)paymentOnDefault), (String)"paymentOnDefault");
        JodaBeanUtils.notNull((Object)((Object)protectionStart), (String)"protectionStart");
        JodaBeanUtils.notNull((Object)stepinDateOffset, (String)"stepinDateOffset");
        JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
        this.name = name;
        this.currency = currency;
        this.dayCount = dayCount;
        this.paymentFrequency = paymentFrequency;
        this.businessDayAdjustment = businessDayAdjustment;
        this.startDateBusinessDayAdjustment = startDateBusinessDayAdjustment;
        this.endDateBusinessDayAdjustment = endDateBusinessDayAdjustment;
        this.stubConvention = stubConvention;
        this.rollConvention = rollConvention;
        this.paymentOnDefault = paymentOnDefault;
        this.protectionStart = protectionStart;
        this.stepinDateOffset = stepinDateOffset;
        this.settlementDateOffset = settlementDateOffset;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public Frequency getPaymentFrequency() {
        return this.paymentFrequency;
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment;
    }

    public StubConvention getStubConvention() {
        return this.stubConvention;
    }

    public RollConvention getRollConvention() {
        return this.rollConvention;
    }

    public PaymentOnDefault getPaymentOnDefault() {
        return this.paymentOnDefault;
    }

    public ProtectionStartOfDay getProtectionStart() {
        return this.protectionStart;
    }

    public DaysAdjustment getStepinDateOffset() {
        return this.stepinDateOffset;
    }

    @Override
    public DaysAdjustment getSettlementDateOffset() {
        return this.settlementDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableCdsConvention other = (ImmutableCdsConvention)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.paymentFrequency, (Object)other.paymentFrequency) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)this.startDateBusinessDayAdjustment, (Object)other.startDateBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.endDateBusinessDayAdjustment, (Object)other.endDateBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.stubConvention, (Object)other.stubConvention) && JodaBeanUtils.equal((Object)this.rollConvention, (Object)other.rollConvention) && JodaBeanUtils.equal((Object)((Object)this.paymentOnDefault), (Object)((Object)other.paymentOnDefault)) && JodaBeanUtils.equal((Object)((Object)this.protectionStart), (Object)((Object)other.protectionStart)) && JodaBeanUtils.equal((Object)this.stepinDateOffset, (Object)other.stepinDateOffset) && JodaBeanUtils.equal((Object)this.settlementDateOffset, (Object)other.settlementDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentFrequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDateBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDateBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stubConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rollConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.paymentOnDefault));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.protectionStart));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stepinDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDateOffset);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableCdsConvention> {
        private String name;
        private Currency currency;
        private DayCount dayCount;
        private Frequency paymentFrequency;
        private BusinessDayAdjustment businessDayAdjustment;
        private BusinessDayAdjustment startDateBusinessDayAdjustment;
        private BusinessDayAdjustment endDateBusinessDayAdjustment;
        private StubConvention stubConvention;
        private RollConvention rollConvention;
        private PaymentOnDefault paymentOnDefault;
        private ProtectionStartOfDay protectionStart;
        private DaysAdjustment stepinDateOffset;
        private DaysAdjustment settlementDateOffset;

        private Builder() {
        }

        private Builder(ImmutableCdsConvention beanToCopy) {
            this.name = beanToCopy.getName();
            this.currency = beanToCopy.getCurrency();
            this.dayCount = beanToCopy.getDayCount();
            this.paymentFrequency = beanToCopy.getPaymentFrequency();
            this.businessDayAdjustment = beanToCopy.getBusinessDayAdjustment();
            this.startDateBusinessDayAdjustment = beanToCopy.startDateBusinessDayAdjustment;
            this.endDateBusinessDayAdjustment = beanToCopy.endDateBusinessDayAdjustment;
            this.stubConvention = beanToCopy.getStubConvention();
            this.rollConvention = beanToCopy.getRollConvention();
            this.paymentOnDefault = beanToCopy.getPaymentOnDefault();
            this.protectionStart = beanToCopy.getProtectionStart();
            this.stepinDateOffset = beanToCopy.getStepinDateOffset();
            this.settlementDateOffset = beanToCopy.getSettlementDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 863656438: {
                    return this.paymentFrequency;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 429197561: {
                    return this.startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return this.endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return this.stubConvention;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case -480203780: {
                    return this.paymentOnDefault;
                }
                case 2103482633: {
                    return this.protectionStart;
                }
                case 852621746: {
                    return this.stepinDateOffset;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 863656438: {
                    this.paymentFrequency = (Frequency)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 429197561: {
                    this.startDateBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -734327136: {
                    this.endDateBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -31408449: {
                    this.stubConvention = (StubConvention)newValue;
                    break;
                }
                case -10223666: {
                    this.rollConvention = (RollConvention)newValue;
                    break;
                }
                case -480203780: {
                    this.paymentOnDefault = (PaymentOnDefault)((Object)newValue);
                    break;
                }
                case 2103482633: {
                    this.protectionStart = (ProtectionStartOfDay)((Object)newValue);
                    break;
                }
                case 852621746: {
                    this.stepinDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 135924714: {
                    this.settlementDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableCdsConvention build() {
            ImmutableCdsConvention.preBuild(this);
            return new ImmutableCdsConvention(this.name, this.currency, this.dayCount, this.paymentFrequency, this.businessDayAdjustment, this.startDateBusinessDayAdjustment, this.endDateBusinessDayAdjustment, this.stubConvention, this.rollConvention, this.paymentOnDefault, this.protectionStart, this.stepinDateOffset, this.settlementDateOffset);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder paymentFrequency(Frequency paymentFrequency) {
            JodaBeanUtils.notNull((Object)paymentFrequency, (String)"paymentFrequency");
            this.paymentFrequency = paymentFrequency;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder startDateBusinessDayAdjustment(BusinessDayAdjustment startDateBusinessDayAdjustment) {
            this.startDateBusinessDayAdjustment = startDateBusinessDayAdjustment;
            return this;
        }

        public Builder endDateBusinessDayAdjustment(BusinessDayAdjustment endDateBusinessDayAdjustment) {
            this.endDateBusinessDayAdjustment = endDateBusinessDayAdjustment;
            return this;
        }

        public Builder stubConvention(StubConvention stubConvention) {
            JodaBeanUtils.notNull((Object)stubConvention, (String)"stubConvention");
            this.stubConvention = stubConvention;
            return this;
        }

        public Builder rollConvention(RollConvention rollConvention) {
            JodaBeanUtils.notNull((Object)rollConvention, (String)"rollConvention");
            this.rollConvention = rollConvention;
            return this;
        }

        public Builder paymentOnDefault(PaymentOnDefault paymentOnDefault) {
            JodaBeanUtils.notNull((Object)((Object)paymentOnDefault), (String)"paymentOnDefault");
            this.paymentOnDefault = paymentOnDefault;
            return this;
        }

        public Builder protectionStart(ProtectionStartOfDay protectionStart) {
            JodaBeanUtils.notNull((Object)((Object)protectionStart), (String)"protectionStart");
            this.protectionStart = protectionStart;
            return this;
        }

        public Builder stepinDateOffset(DaysAdjustment stepinDateOffset) {
            JodaBeanUtils.notNull((Object)stepinDateOffset, (String)"stepinDateOffset");
            this.stepinDateOffset = stepinDateOffset;
            return this;
        }

        public Builder settlementDateOffset(DaysAdjustment settlementDateOffset) {
            JodaBeanUtils.notNull((Object)settlementDateOffset, (String)"settlementDateOffset");
            this.settlementDateOffset = settlementDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(448);
            buf.append("ImmutableCdsConvention.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("paymentFrequency").append('=').append(JodaBeanUtils.toString((Object)this.paymentFrequency)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("startDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.startDateBusinessDayAdjustment)).append(',').append(' ');
            buf.append("endDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.endDateBusinessDayAdjustment)).append(',').append(' ');
            buf.append("stubConvention").append('=').append(JodaBeanUtils.toString((Object)this.stubConvention)).append(',').append(' ');
            buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
            buf.append("paymentOnDefault").append('=').append(JodaBeanUtils.toString((Object)((Object)this.paymentOnDefault))).append(',').append(' ');
            buf.append("protectionStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.protectionStart))).append(',').append(' ');
            buf.append("stepinDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.stepinDateOffset)).append(',').append(' ');
            buf.append("settlementDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.settlementDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableCdsConvention.class, String.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ImmutableCdsConvention.class, Currency.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ImmutableCdsConvention.class, DayCount.class);
        private final MetaProperty<Frequency> paymentFrequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentFrequency", ImmutableCdsConvention.class, Frequency.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", ImmutableCdsConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> startDateBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDateBusinessDayAdjustment", ImmutableCdsConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> endDateBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDateBusinessDayAdjustment", ImmutableCdsConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<StubConvention> stubConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stubConvention", ImmutableCdsConvention.class, StubConvention.class);
        private final MetaProperty<RollConvention> rollConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rollConvention", ImmutableCdsConvention.class, RollConvention.class);
        private final MetaProperty<PaymentOnDefault> paymentOnDefault = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentOnDefault", ImmutableCdsConvention.class, PaymentOnDefault.class);
        private final MetaProperty<ProtectionStartOfDay> protectionStart = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"protectionStart", ImmutableCdsConvention.class, ProtectionStartOfDay.class);
        private final MetaProperty<DaysAdjustment> stepinDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stepinDateOffset", ImmutableCdsConvention.class, DaysAdjustment.class);
        private final MetaProperty<DaysAdjustment> settlementDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDateOffset", ImmutableCdsConvention.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currency", "dayCount", "paymentFrequency", "businessDayAdjustment", "startDateBusinessDayAdjustment", "endDateBusinessDayAdjustment", "stubConvention", "rollConvention", "paymentOnDefault", "protectionStart", "stepinDateOffset", "settlementDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 863656438: {
                    return this.paymentFrequency;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 429197561: {
                    return this.startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return this.endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return this.stubConvention;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case -480203780: {
                    return this.paymentOnDefault;
                }
                case 2103482633: {
                    return this.protectionStart;
                }
                case 852621746: {
                    return this.stepinDateOffset;
                }
                case 135924714: {
                    return this.settlementDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableCdsConvention> beanType() {
            return ImmutableCdsConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Frequency> paymentFrequency() {
            return this.paymentFrequency;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<BusinessDayAdjustment> startDateBusinessDayAdjustment() {
            return this.startDateBusinessDayAdjustment;
        }

        public MetaProperty<BusinessDayAdjustment> endDateBusinessDayAdjustment() {
            return this.endDateBusinessDayAdjustment;
        }

        public MetaProperty<StubConvention> stubConvention() {
            return this.stubConvention;
        }

        public MetaProperty<RollConvention> rollConvention() {
            return this.rollConvention;
        }

        public MetaProperty<PaymentOnDefault> paymentOnDefault() {
            return this.paymentOnDefault;
        }

        public MetaProperty<ProtectionStartOfDay> protectionStart() {
            return this.protectionStart;
        }

        public MetaProperty<DaysAdjustment> stepinDateOffset() {
            return this.stepinDateOffset;
        }

        public MetaProperty<DaysAdjustment> settlementDateOffset() {
            return this.settlementDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableCdsConvention)bean).getName();
                }
                case 575402001: {
                    return ((ImmutableCdsConvention)bean).getCurrency();
                }
                case 1905311443: {
                    return ((ImmutableCdsConvention)bean).getDayCount();
                }
                case 863656438: {
                    return ((ImmutableCdsConvention)bean).getPaymentFrequency();
                }
                case -1065319863: {
                    return ((ImmutableCdsConvention)bean).getBusinessDayAdjustment();
                }
                case 429197561: {
                    return ((ImmutableCdsConvention)bean).startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return ((ImmutableCdsConvention)bean).endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return ((ImmutableCdsConvention)bean).getStubConvention();
                }
                case -10223666: {
                    return ((ImmutableCdsConvention)bean).getRollConvention();
                }
                case -480203780: {
                    return ((ImmutableCdsConvention)bean).getPaymentOnDefault();
                }
                case 2103482633: {
                    return ((ImmutableCdsConvention)bean).getProtectionStart();
                }
                case 852621746: {
                    return ((ImmutableCdsConvention)bean).getStepinDateOffset();
                }
                case 135924714: {
                    return ((ImmutableCdsConvention)bean).getSettlementDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

