/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.product.credit.type.ImmutableCdsConvention;

final class StandardCdsConventions {
    private static final HolidayCalendarId GBLO_USNY = HolidayCalendarIds.GBLO.combinedWith(HolidayCalendarIds.USNY);
    private static final HolidayCalendarId GBLO_USNY_JPTO = HolidayCalendarIds.JPTO.combinedWith(GBLO_USNY);
    private static final HolidayCalendarId GBLO_EUTA = HolidayCalendarIds.GBLO.combinedWith(HolidayCalendarIds.EUTA);
    public static final ImmutableCdsConvention USD_STANDARD = ImmutableCdsConvention.of("USD-STANDARD", Currency.USD, DayCounts.ACT_360, Frequency.P3M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.USNY), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)HolidayCalendarIds.USNY));
    public static final ImmutableCdsConvention EUR_STANDARD = ImmutableCdsConvention.of("EUR-STANDARD", Currency.EUR, DayCounts.ACT_360, Frequency.P3M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.EUTA), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)HolidayCalendarIds.EUTA));
    public static final ImmutableCdsConvention EUR_GB_STANDARD = ImmutableCdsConvention.of("EUR-GB-STANDARD", Currency.EUR, DayCounts.ACT_360, Frequency.P3M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)GBLO_EUTA), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)GBLO_EUTA));
    public static final ImmutableCdsConvention GBP_STANDARD = ImmutableCdsConvention.of("GBP-STANDARD", Currency.GBP, DayCounts.ACT_360, Frequency.P3M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.GBLO), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)HolidayCalendarIds.GBLO));
    public static final ImmutableCdsConvention GBP_US_STANDARD = ImmutableCdsConvention.of("GBP-US-STANDARD", Currency.GBP, DayCounts.ACT_360, Frequency.P3M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)GBLO_USNY), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)GBLO_USNY));
    public static final ImmutableCdsConvention JPY_STANDARD = ImmutableCdsConvention.of("JPY-STANDARD", Currency.JPY, DayCounts.ACT_360, Frequency.P3M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.JPTO), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)HolidayCalendarIds.JPTO));
    public static final ImmutableCdsConvention JPY_US_GB_STANDARD = ImmutableCdsConvention.of("JPY-US-GB-STANDARD", Currency.JPY, DayCounts.ACT_360, Frequency.P3M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.FOLLOWING, (HolidayCalendarId)GBLO_USNY_JPTO), DaysAdjustment.ofBusinessDays((int)3, (HolidayCalendarId)GBLO_USNY_JPTO));

    private StandardCdsConventions() {
    }
}

