/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.credit.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.AdjustablePayment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.credit.CdsTrade;
import com.opengamma.strata.product.credit.type.AccrualStart;
import com.opengamma.strata.product.credit.type.CdsConvention;
import com.opengamma.strata.product.credit.type.CdsTemplate;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class TenorCdsTemplate
implements CdsTemplate,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final AccrualStart accrualStart;
    @PropertyDefinition(validate="notNull")
    private final Tenor tenor;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CdsConvention convention;
    private static final long serialVersionUID = 1L;

    public static TenorCdsTemplate of(AccrualStart accrualStart, Tenor tenor, CdsConvention convention) {
        return new TenorCdsTemplate(accrualStart, tenor, convention);
    }

    public static TenorCdsTemplate of(Tenor tenor, CdsConvention convention) {
        return TenorCdsTemplate.of(AccrualStart.IMM_DATE, tenor, convention);
    }

    @Override
    public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        return this.accrualStart.equals((Object)AccrualStart.IMM_DATE) ? this.convention.createTrade(legalEntityId, tradeDate, this.tenor, buySell, notional, fixedRate, refData) : this.convention.createTrade(legalEntityId, tradeDate, tradeDate.plusDays(1L), this.tenor, buySell, notional, fixedRate, refData);
    }

    @Override
    public CdsTrade createTrade(StandardId legalEntityId, LocalDate tradeDate, BuySell buySell, double notional, double fixedRate, AdjustablePayment upFrontFee, ReferenceData refData) {
        return this.accrualStart.equals((Object)AccrualStart.IMM_DATE) ? this.convention.createTrade(legalEntityId, tradeDate, this.tenor, buySell, notional, fixedRate, upFrontFee, refData) : this.convention.createTrade(legalEntityId, tradeDate, tradeDate.plusDays(1L), this.tenor, buySell, notional, fixedRate, upFrontFee, refData);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private TenorCdsTemplate(AccrualStart accrualStart, Tenor tenor, CdsConvention convention) {
        JodaBeanUtils.notNull((Object)((Object)accrualStart), (String)"accrualStart");
        JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
        JodaBeanUtils.notNull((Object)convention, (String)"convention");
        this.accrualStart = accrualStart;
        this.tenor = tenor;
        this.convention = convention;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public AccrualStart getAccrualStart() {
        return this.accrualStart;
    }

    public Tenor getTenor() {
        return this.tenor;
    }

    @Override
    public CdsConvention getConvention() {
        return this.convention;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TenorCdsTemplate other = (TenorCdsTemplate)obj;
            return JodaBeanUtils.equal((Object)((Object)this.accrualStart), (Object)((Object)other.accrualStart)) && JodaBeanUtils.equal((Object)this.tenor, (Object)other.tenor) && JodaBeanUtils.equal((Object)this.convention, (Object)other.convention);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.accrualStart));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("TenorCdsTemplate{");
        buf.append("accrualStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualStart))).append(',').append(' ');
        buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
        buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<TenorCdsTemplate> {
        private AccrualStart accrualStart;
        private Tenor tenor;
        private CdsConvention convention;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1071260659: {
                    return this.accrualStart;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1071260659: {
                    this.accrualStart = (AccrualStart)((Object)newValue);
                    break;
                }
                case 110246592: {
                    this.tenor = (Tenor)newValue;
                    break;
                }
                case 2039569265: {
                    this.convention = (CdsConvention)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public TenorCdsTemplate build() {
            return new TenorCdsTemplate(this.accrualStart, this.tenor, this.convention);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("TenorCdsTemplate.Builder{");
            buf.append("accrualStart").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualStart))).append(',').append(' ');
            buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<AccrualStart> accrualStart = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualStart", TenorCdsTemplate.class, AccrualStart.class);
        private final MetaProperty<Tenor> tenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tenor", TenorCdsTemplate.class, Tenor.class);
        private final MetaProperty<CdsConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", TenorCdsTemplate.class, CdsConvention.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"accrualStart", "tenor", "convention"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1071260659: {
                    return this.accrualStart;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends TenorCdsTemplate> builder() {
            return new Builder();
        }

        public Class<? extends TenorCdsTemplate> beanType() {
            return TenorCdsTemplate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<AccrualStart> accrualStart() {
            return this.accrualStart;
        }

        public MetaProperty<Tenor> tenor() {
            return this.tenor;
        }

        public MetaProperty<CdsConvention> convention() {
            return this.convention;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1071260659: {
                    return ((TenorCdsTemplate)bean).getAccrualStart();
                }
                case 110246592: {
                    return ((TenorCdsTemplate)bean).getTenor();
                }
                case 2039569265: {
                    return ((TenorCdsTemplate)bean).getConvention();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

