/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.deposit.ResolvedIborFixingDeposit;
import com.opengamma.strata.product.rate.IborRateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborFixingDeposit
implements Product,
Resolvable<ResolvedIborFixingDeposit>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final BuySell buySell;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(get="optional")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(validate="notNull")
    private final IborIndex index;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment fixingDateOffset;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition
    private final double fixedRate;
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null) {
            if (builder.dayCount == null) {
                builder.dayCount = builder.index.getDayCount();
            }
            if (builder.fixingDateOffset == null) {
                builder.fixingDateOffset = builder.index.getFixingDateOffset();
            }
            if (builder.currency == null) {
                builder.currency = builder.index.getCurrency();
            }
        }
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        return ImmutableSet.of((Object)this.currency);
    }

    public ResolvedIborFixingDeposit resolve(ReferenceData refData) {
        DateAdjuster bda = this.getBusinessDayAdjustment().orElse(BusinessDayAdjustment.NONE).resolve(refData);
        LocalDate start = bda.adjust(this.startDate);
        LocalDate end = bda.adjust(this.endDate);
        double yearFraction = this.dayCount.yearFraction(start, end);
        LocalDate fixingDate = this.fixingDateOffset.adjust(this.startDate, refData);
        return ResolvedIborFixingDeposit.builder().startDate(start).endDate(end).yearFraction(yearFraction).currency(this.getCurrency()).notional(this.buySell.normalize(this.notional)).floatingRate(IborRateComputation.of(this.index, fixingDate, refData)).fixedRate(this.fixedRate).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IborFixingDeposit(BuySell buySell, Currency currency, double notional, LocalDate startDate, LocalDate endDate, BusinessDayAdjustment businessDayAdjustment, IborIndex index, DaysAdjustment fixingDateOffset, DayCount dayCount, double fixedRate) {
        JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegative((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        this.buySell = buySell;
        this.currency = currency;
        this.notional = notional;
        this.startDate = startDate;
        this.endDate = endDate;
        this.businessDayAdjustment = businessDayAdjustment;
        this.index = index;
        this.fixingDateOffset = fixingDateOffset;
        this.dayCount = dayCount;
        this.fixedRate = fixedRate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public BuySell getBuySell() {
        return this.buySell;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public Optional<BusinessDayAdjustment> getBusinessDayAdjustment() {
        return Optional.ofNullable(this.businessDayAdjustment);
    }

    public IborIndex getIndex() {
        return this.index;
    }

    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborFixingDeposit other = (IborFixingDeposit)obj;
            return JodaBeanUtils.equal((Object)((Object)this.buySell), (Object)((Object)other.buySell)) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.fixingDateOffset, (Object)other.fixingDateOffset) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.buySell));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("IborFixingDeposit{");
        buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborFixingDeposit> {
        private BuySell buySell;
        private Currency currency;
        private double notional;
        private LocalDate startDate;
        private LocalDate endDate;
        private BusinessDayAdjustment businessDayAdjustment;
        private IborIndex index;
        private DaysAdjustment fixingDateOffset;
        private DayCount dayCount;
        private double fixedRate;

        private Builder() {
        }

        private Builder(IborFixingDeposit beanToCopy) {
            this.buySell = beanToCopy.getBuySell();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.businessDayAdjustment = beanToCopy.businessDayAdjustment;
            this.index = beanToCopy.getIndex();
            this.fixingDateOffset = beanToCopy.getFixingDateOffset();
            this.dayCount = beanToCopy.getDayCount();
            this.fixedRate = beanToCopy.getFixedRate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 100346066: {
                    return this.index;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 747425396: {
                    return this.fixedRate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    this.buySell = (BuySell)((Object)newValue);
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborFixingDeposit build() {
            IborFixingDeposit.preBuild(this);
            return new IborFixingDeposit(this.buySell, this.currency, this.notional, this.startDate, this.endDate, this.businessDayAdjustment, this.index, this.fixingDateOffset, this.dayCount, this.fixedRate);
        }

        public Builder buySell(BuySell buySell) {
            JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
            this.buySell = buySell;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegative((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("IborFixingDeposit.Builder{");
            buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BuySell> buySell = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"buySell", IborFixingDeposit.class, BuySell.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IborFixingDeposit.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", IborFixingDeposit.class, Double.TYPE);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", IborFixingDeposit.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", IborFixingDeposit.class, LocalDate.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", IborFixingDeposit.class, BusinessDayAdjustment.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", IborFixingDeposit.class, IborIndex.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", IborFixingDeposit.class, DaysAdjustment.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", IborFixingDeposit.class, DayCount.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", IborFixingDeposit.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"buySell", "currency", "notional", "startDate", "endDate", "businessDayAdjustment", "index", "fixingDateOffset", "dayCount", "fixedRate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 100346066: {
                    return this.index;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 747425396: {
                    return this.fixedRate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborFixingDeposit> beanType() {
            return IborFixingDeposit.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BuySell> buySell() {
            return this.buySell;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return ((IborFixingDeposit)bean).getBuySell();
                }
                case 575402001: {
                    return ((IborFixingDeposit)bean).getCurrency();
                }
                case 1585636160: {
                    return ((IborFixingDeposit)bean).getNotional();
                }
                case -2129778896: {
                    return ((IborFixingDeposit)bean).getStartDate();
                }
                case -1607727319: {
                    return ((IborFixingDeposit)bean).getEndDate();
                }
                case -1065319863: {
                    return ((IborFixingDeposit)bean).businessDayAdjustment;
                }
                case 100346066: {
                    return ((IborFixingDeposit)bean).getIndex();
                }
                case 873743726: {
                    return ((IborFixingDeposit)bean).getFixingDateOffset();
                }
                case 1905311443: {
                    return ((IborFixingDeposit)bean).getDayCount();
                }
                case 747425396: {
                    return ((IborFixingDeposit)bean).getFixedRate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

