/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.rate.IborRateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedIborFixingDeposit
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double yearFraction;
    @PropertyDefinition
    private final double fixedRate;
    @PropertyDefinition(validate="notNull")
    private final IborRateComputation floatingRate;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResolvedIborFixingDeposit(Currency currency, double notional, LocalDate startDate, LocalDate endDate, double yearFraction, double fixedRate, IborRateComputation floatingRate) {
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
        JodaBeanUtils.notNull((Object)floatingRate, (String)"floatingRate");
        this.currency = currency;
        this.notional = notional;
        this.startDate = startDate;
        this.endDate = endDate;
        this.yearFraction = yearFraction;
        this.fixedRate = fixedRate;
        this.floatingRate = floatingRate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public IborRateComputation getFloatingRate() {
        return this.floatingRate;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedIborFixingDeposit other = (ResolvedIborFixingDeposit)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate) && JodaBeanUtils.equal((Object)this.floatingRate, (Object)other.floatingRate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.floatingRate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("ResolvedIborFixingDeposit{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("floatingRate").append('=').append(JodaBeanUtils.toString((Object)this.floatingRate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedIborFixingDeposit> {
        private Currency currency;
        private double notional;
        private LocalDate startDate;
        private LocalDate endDate;
        private double yearFraction;
        private double fixedRate;
        private IborRateComputation floatingRate;

        private Builder() {
        }

        private Builder(ResolvedIborFixingDeposit beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.yearFraction = beanToCopy.getYearFraction();
            this.fixedRate = beanToCopy.getFixedRate();
            this.floatingRate = beanToCopy.getFloatingRate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case -2130225658: {
                    return this.floatingRate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case -2130225658: {
                    this.floatingRate = (IborRateComputation)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedIborFixingDeposit build() {
            return new ResolvedIborFixingDeposit(this.currency, this.notional, this.startDate, this.endDate, this.yearFraction, this.fixedRate, this.floatingRate);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            this.notional = notional;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder yearFraction(double yearFraction) {
            ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
            this.yearFraction = yearFraction;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder floatingRate(IborRateComputation floatingRate) {
            JodaBeanUtils.notNull((Object)floatingRate, (String)"floatingRate");
            this.floatingRate = floatingRate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("ResolvedIborFixingDeposit.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("floatingRate").append('=').append(JodaBeanUtils.toString((Object)this.floatingRate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ResolvedIborFixingDeposit.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", ResolvedIborFixingDeposit.class, Double.TYPE);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", ResolvedIborFixingDeposit.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", ResolvedIborFixingDeposit.class, LocalDate.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", ResolvedIborFixingDeposit.class, Double.TYPE);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", ResolvedIborFixingDeposit.class, Double.TYPE);
        private final MetaProperty<IborRateComputation> floatingRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"floatingRate", ResolvedIborFixingDeposit.class, IborRateComputation.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "notional", "startDate", "endDate", "yearFraction", "fixedRate", "floatingRate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case -2130225658: {
                    return this.floatingRate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedIborFixingDeposit> beanType() {
            return ResolvedIborFixingDeposit.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<IborRateComputation> floatingRate() {
            return this.floatingRate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((ResolvedIborFixingDeposit)bean).getCurrency();
                }
                case 1585636160: {
                    return ((ResolvedIborFixingDeposit)bean).getNotional();
                }
                case -2129778896: {
                    return ((ResolvedIborFixingDeposit)bean).getStartDate();
                }
                case -1607727319: {
                    return ((ResolvedIborFixingDeposit)bean).getEndDate();
                }
                case -1731780257: {
                    return ((ResolvedIborFixingDeposit)bean).getYearFraction();
                }
                case 747425396: {
                    return ((ResolvedIborFixingDeposit)bean).getFixedRate();
                }
                case -2130225658: {
                    return ((ResolvedIborFixingDeposit)bean).getFloatingRate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

