/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.ProductTrade;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.ResolvableTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.common.SummarizerUtils;
import com.opengamma.strata.product.deposit.ResolvedTermDepositTrade;
import com.opengamma.strata.product.deposit.TermDeposit;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class TermDepositTrade
implements ProductTrade,
ResolvableTrade<ResolvedTermDepositTrade>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TradeInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TermDeposit product;
    private static final long serialVersionUID = 1L;

    public static TermDepositTrade of(TradeInfo info, TermDeposit product) {
        return new TermDepositTrade(info, product);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    @Override
    public TermDepositTrade withInfo(PortfolioItemInfo info) {
        return new TermDepositTrade(TradeInfo.from(info), this.product);
    }

    @Override
    public PortfolioItemSummary summarize() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(SummarizerUtils.datePeriod(this.product.getStartDate(), this.product.getEndDate()));
        buf.append(' ');
        buf.append(SummarizerUtils.amount(this.product.getCurrency(), this.product.getNotional()));
        buf.append(' ');
        buf.append(this.product.getBuySell() == BuySell.BUY ? "Deposit " : "Loan ");
        buf.append(SummarizerUtils.percent(this.product.getRate()));
        buf.append(" : ");
        buf.append(SummarizerUtils.dateRange(this.product.getStartDate(), this.product.getEndDate()));
        return SummarizerUtils.summary(this, ProductType.TERM_DEPOSIT, buf.toString(), this.product.getCurrency());
    }

    @Override
    public ResolvedTermDepositTrade resolve(ReferenceData refData) {
        return ResolvedTermDepositTrade.builder().info(this.info).product(this.product.resolve(refData)).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private TermDepositTrade(TradeInfo info, TermDeposit product) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        this.info = info;
        this.product = product;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public TradeInfo getInfo() {
        return this.info;
    }

    @Override
    public TermDeposit getProduct() {
        return this.product;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TermDepositTrade other = (TermDepositTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("TermDepositTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<TermDepositTrade> {
        private TradeInfo info;
        private TermDeposit product;

        private Builder() {
            TermDepositTrade.applyDefaults(this);
        }

        private Builder(TermDepositTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (TradeInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (TermDeposit)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public TermDepositTrade build() {
            return new TermDepositTrade(this.info, this.product);
        }

        public Builder info(TradeInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(TermDeposit product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("TermDepositTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<TradeInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", TermDepositTrade.class, TradeInfo.class);
        private final MetaProperty<TermDeposit> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", TermDepositTrade.class, TermDeposit.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends TermDepositTrade> beanType() {
            return TermDepositTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<TradeInfo> info() {
            return this.info;
        }

        public MetaProperty<TermDeposit> product() {
            return this.product;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((TermDepositTrade)bean).getInfo();
                }
                case -309474065: {
                    return ((TermDepositTrade)bean).getProduct();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

