/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.TradeConvention;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.deposit.IborFixingDepositTrade;
import com.opengamma.strata.product.deposit.type.IborFixingDepositConventions;
import java.time.LocalDate;
import java.time.Period;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface IborFixingDepositConvention
extends TradeConvention,
Named {
    @FromString
    public static IborFixingDepositConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (IborFixingDepositConvention)IborFixingDepositConvention.extendedEnum().lookup(uniqueName);
    }

    public static IborFixingDepositConvention of(IborIndex index) {
        ArgChecker.notNull((Object)index, (String)"index");
        return (IborFixingDepositConvention)IborFixingDepositConvention.extendedEnum().lookup(index.getName());
    }

    public static ExtendedEnum<IborFixingDepositConvention> extendedEnum() {
        return IborFixingDepositConventions.ENUM_LOOKUP;
    }

    public IborIndex getIndex();

    public DaysAdjustment getSpotDateOffset();

    public IborFixingDepositTrade createTrade(LocalDate var1, Period var2, BuySell var3, double var4, double var6, ReferenceData var8);

    default public IborFixingDepositTrade toTrade(LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRate) {
        TradeInfo tradeInfo = TradeInfo.of(tradeDate);
        return this.toTrade(tradeInfo, startDate, endDate, buySell, notional, fixedRate);
    }

    public IborFixingDepositTrade toTrade(TradeInfo var1, LocalDate var2, LocalDate var3, BuySell var4, double var5, double var7);

    default public LocalDate calculateSpotDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.getSpotDateOffset().adjust(tradeDate, refData);
    }

    @ToString
    public String getName();
}

