/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit.type;

import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.named.NamedLookup;
import com.opengamma.strata.product.deposit.type.IborFixingDepositConvention;
import com.opengamma.strata.product.deposit.type.ImmutableIborFixingDepositConvention;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class IborFixingDepositConventionLookup
implements NamedLookup<IborFixingDepositConvention> {
    public static final IborFixingDepositConventionLookup INSTANCE = new IborFixingDepositConventionLookup();
    private static final ConcurrentMap<String, IborFixingDepositConvention> BY_NAME = new ConcurrentHashMap<String, IborFixingDepositConvention>();

    private IborFixingDepositConventionLookup() {
    }

    public IborFixingDepositConvention lookup(String name) {
        IborFixingDepositConvention created;
        IborFixingDepositConvention value = (IborFixingDepositConvention)BY_NAME.get(name);
        if (value == null && (created = IborFixingDepositConventionLookup.createByName(name)) != null) {
            String correctName = created.getName();
            value = BY_NAME.computeIfAbsent(correctName, k -> created);
            BY_NAME.putIfAbsent(correctName.toUpperCase(Locale.ENGLISH), value);
        }
        return value;
    }

    public Map<String, IborFixingDepositConvention> lookupAll() {
        return BY_NAME;
    }

    private static IborFixingDepositConvention createByName(String name) {
        return IborIndex.extendedEnum().find(name).map(index -> ImmutableIborFixingDepositConvention.of(index)).orElse(null);
    }
}

