/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.deposit.IborFixingDeposit;
import com.opengamma.strata.product.deposit.IborFixingDepositTrade;
import com.opengamma.strata.product.deposit.type.IborFixingDepositConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableIborFixingDepositConvention
implements IborFixingDepositConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(get="field")
    private final String name;
    @PropertyDefinition(get="field")
    private final Currency currency;
    @PropertyDefinition(get="field")
    private final DayCount dayCount;
    @PropertyDefinition(get="field")
    private final DaysAdjustment spotDateOffset;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(get="field")
    private final DaysAdjustment fixingDateOffset;
    private static final long serialVersionUID = 1L;

    public static ImmutableIborFixingDepositConvention of(IborIndex index) {
        return ImmutableIborFixingDepositConvention.builder().index(index).build();
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.index.getName();
    }

    public Currency getCurrency() {
        return this.currency != null ? this.currency : this.index.getCurrency();
    }

    public DayCount getDayCount() {
        return this.dayCount != null ? this.dayCount : this.index.getDayCount();
    }

    @Override
    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset != null ? this.spotDateOffset : this.index.getEffectiveDateOffset();
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment != null ? this.businessDayAdjustment : BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)this.index.getFixingCalendar());
    }

    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset != null ? this.fixingDateOffset : this.index.getFixingDateOffset();
    }

    @Override
    public IborFixingDepositTrade createTrade(LocalDate tradeDate, Period depositPeriod, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        LocalDate startDate = this.calculateSpotDateFromTradeDate(tradeDate, refData);
        LocalDate endDate = startDate.plus(depositPeriod);
        return this.toTrade(tradeDate, startDate, endDate, buySell, notional, fixedRate);
    }

    @Override
    public IborFixingDepositTrade toTrade(TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRate) {
        Optional<LocalDate> tradeDate = tradeInfo.getTradeDate();
        if (tradeDate.isPresent()) {
            ArgChecker.inOrderOrEqual((Comparable)tradeDate.get(), (Object)startDate, (String)"tradeDate", (String)"startDate");
        }
        return IborFixingDepositTrade.builder().info(tradeInfo).product(IborFixingDeposit.builder().buySell(buySell).currency(this.getCurrency()).notional(notional).startDate(startDate).endDate(endDate).businessDayAdjustment(this.getBusinessDayAdjustment()).fixedRate(fixedRate).index(this.index).fixingDateOffset(this.getFixingDateOffset()).dayCount(this.getDayCount()).build()).build();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableIborFixingDepositConvention(IborIndex index, String name, Currency currency, DayCount dayCount, DaysAdjustment spotDateOffset, BusinessDayAdjustment businessDayAdjustment, DaysAdjustment fixingDateOffset) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        this.index = index;
        this.name = name;
        this.currency = currency;
        this.dayCount = dayCount;
        this.spotDateOffset = spotDateOffset;
        this.businessDayAdjustment = businessDayAdjustment;
        this.fixingDateOffset = fixingDateOffset;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableIborFixingDepositConvention other = (ImmutableIborFixingDepositConvention)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)this.fixingDateOffset, (Object)other.fixingDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDateOffset);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableIborFixingDepositConvention> {
        private IborIndex index;
        private String name;
        private Currency currency;
        private DayCount dayCount;
        private DaysAdjustment spotDateOffset;
        private BusinessDayAdjustment businessDayAdjustment;
        private DaysAdjustment fixingDateOffset;

        private Builder() {
        }

        private Builder(ImmutableIborFixingDepositConvention beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.name = beanToCopy.name;
            this.currency = beanToCopy.currency;
            this.dayCount = beanToCopy.dayCount;
            this.spotDateOffset = beanToCopy.spotDateOffset;
            this.businessDayAdjustment = beanToCopy.businessDayAdjustment;
            this.fixingDateOffset = beanToCopy.fixingDateOffset;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableIborFixingDepositConvention build() {
            return new ImmutableIborFixingDepositConvention(this.index, this.name, this.currency, this.dayCount, this.spotDateOffset, this.businessDayAdjustment, this.fixingDateOffset);
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            this.dayCount = dayCount;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("ImmutableIborFixingDepositConvention.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", ImmutableIborFixingDepositConvention.class, IborIndex.class);
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableIborFixingDepositConvention.class, String.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ImmutableIborFixingDepositConvention.class, Currency.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ImmutableIborFixingDepositConvention.class, DayCount.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", ImmutableIborFixingDepositConvention.class, DaysAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", ImmutableIborFixingDepositConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", ImmutableIborFixingDepositConvention.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "name", "currency", "dayCount", "spotDateOffset", "businessDayAdjustment", "fixingDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 3373707: {
                    return this.name;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableIborFixingDepositConvention> beanType() {
            return ImmutableIborFixingDepositConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((ImmutableIborFixingDepositConvention)bean).getIndex();
                }
                case 3373707: {
                    return ((ImmutableIborFixingDepositConvention)bean).name;
                }
                case 575402001: {
                    return ((ImmutableIborFixingDepositConvention)bean).currency;
                }
                case 1905311443: {
                    return ((ImmutableIborFixingDepositConvention)bean).dayCount;
                }
                case 746995843: {
                    return ((ImmutableIborFixingDepositConvention)bean).spotDateOffset;
                }
                case -1065319863: {
                    return ((ImmutableIborFixingDepositConvention)bean).businessDayAdjustment;
                }
                case 873743726: {
                    return ((ImmutableIborFixingDepositConvention)bean).fixingDateOffset;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

