/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.deposit.TermDeposit;
import com.opengamma.strata.product.deposit.TermDepositTrade;
import com.opengamma.strata.product.deposit.type.TermDepositConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableTermDepositConvention
implements TermDepositConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment spotDateOffset;
    private static final long serialVersionUID = 1L;

    public static ImmutableTermDepositConvention of(String name, Currency currency, BusinessDayAdjustment businessDayAdjustment, DayCount dayCount, DaysAdjustment spotDateOffset) {
        return ImmutableTermDepositConvention.builder().name(name).currency(currency).businessDayAdjustment(businessDayAdjustment).dayCount(dayCount).spotDateOffset(spotDateOffset).build();
    }

    @Override
    public TermDepositTrade toTrade(TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double rate) {
        Optional<LocalDate> tradeDate = tradeInfo.getTradeDate();
        if (tradeDate.isPresent()) {
            ArgChecker.inOrderOrEqual((Comparable)tradeDate.get(), (Object)startDate, (String)"tradeDate", (String)"startDate");
        }
        return TermDepositTrade.builder().info(tradeInfo).product(TermDeposit.builder().buySell(buySell).currency(this.currency).notional(notional).startDate(startDate).endDate(endDate).businessDayAdjustment(this.businessDayAdjustment).rate(rate).dayCount(this.dayCount).build()).build();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableTermDepositConvention(Currency currency, String name, BusinessDayAdjustment businessDayAdjustment, DayCount dayCount, DaysAdjustment spotDateOffset) {
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
        this.currency = currency;
        this.name = name;
        this.businessDayAdjustment = businessDayAdjustment;
        this.dayCount = dayCount;
        this.spotDateOffset = spotDateOffset;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    @Override
    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableTermDepositConvention other = (ImmutableTermDepositConvention)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableTermDepositConvention> {
        private Currency currency;
        private String name;
        private BusinessDayAdjustment businessDayAdjustment;
        private DayCount dayCount;
        private DaysAdjustment spotDateOffset;

        private Builder() {
        }

        private Builder(ImmutableTermDepositConvention beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.name = beanToCopy.getName();
            this.businessDayAdjustment = beanToCopy.getBusinessDayAdjustment();
            this.dayCount = beanToCopy.getDayCount();
            this.spotDateOffset = beanToCopy.getSpotDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 3373707: {
                    return this.name;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableTermDepositConvention build() {
            return new ImmutableTermDepositConvention(this.currency, this.name, this.businessDayAdjustment, this.dayCount, this.spotDateOffset);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ImmutableTermDepositConvention.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ImmutableTermDepositConvention.class, Currency.class);
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableTermDepositConvention.class, String.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", ImmutableTermDepositConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", ImmutableTermDepositConvention.class, DayCount.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", ImmutableTermDepositConvention.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "name", "businessDayAdjustment", "dayCount", "spotDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 3373707: {
                    return this.name;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableTermDepositConvention> beanType() {
            return ImmutableTermDepositConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((ImmutableTermDepositConvention)bean).getCurrency();
                }
                case 3373707: {
                    return ((ImmutableTermDepositConvention)bean).getName();
                }
                case -1065319863: {
                    return ((ImmutableTermDepositConvention)bean).getBusinessDayAdjustment();
                }
                case 1905311443: {
                    return ((ImmutableTermDepositConvention)bean).getDayCount();
                }
                case 746995843: {
                    return ((ImmutableTermDepositConvention)bean).getSpotDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

