/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.MarketTenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.TradeConvention;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.deposit.TermDepositTrade;
import com.opengamma.strata.product.deposit.type.TermDepositConventions;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface TermDepositConvention
extends TradeConvention,
Named {
    @FromString
    public static TermDepositConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (TermDepositConvention)TermDepositConvention.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<TermDepositConvention> extendedEnum() {
        return TermDepositConventions.ENUM_LOOKUP;
    }

    public Currency getCurrency();

    public DaysAdjustment getSpotDateOffset();

    default public TermDepositTrade createTrade(LocalDate tradeDate, MarketTenor marketTenor, BuySell buySell, double notional, double rate, ReferenceData refData) {
        LocalDate startDate = marketTenor.adjustSpotLag(this.getSpotDateOffset()).adjust(tradeDate, refData);
        LocalDate endDate = startDate.plus((TemporalAmount)marketTenor.getTenor());
        return this.toTrade(tradeDate, startDate, endDate, buySell, notional, rate);
    }

    default public TermDepositTrade createTrade(LocalDate tradeDate, Period depositPeriod, BuySell buySell, double notional, double rate, ReferenceData refData) {
        LocalDate startDate = this.calculateSpotDateFromTradeDate(tradeDate, refData);
        LocalDate endDate = startDate.plus(depositPeriod);
        return this.toTrade(tradeDate, startDate, endDate, buySell, notional, rate);
    }

    default public TermDepositTrade toTrade(LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double rate) {
        TradeInfo tradeInfo = TradeInfo.of(tradeDate);
        return this.toTrade(tradeInfo, startDate, endDate, buySell, notional, rate);
    }

    public TermDepositTrade toTrade(TradeInfo var1, LocalDate var2, LocalDate var3, BuySell var4, double var5, double var7);

    default public LocalDate calculateSpotDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.getSpotDateOffset().adjust(tradeDate, refData);
    }

    @ToString
    public String getName();
}

