/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.deposit.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeTemplate;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.deposit.TermDepositTrade;
import com.opengamma.strata.product.deposit.type.TermDepositConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class TermDepositTemplate
implements TradeTemplate,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Period depositPeriod;
    @PropertyDefinition(validate="notNull")
    private final TermDepositConvention convention;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.isFalse((boolean)this.depositPeriod.isNegative(), (String)"Deposit Period must not be negative");
    }

    public static TermDepositTemplate of(Period depositPeriod, TermDepositConvention convention) {
        ArgChecker.notNull((Object)depositPeriod, (String)"depositPeriod");
        ArgChecker.notNull((Object)convention, (String)"convention");
        return TermDepositTemplate.builder().depositPeriod(depositPeriod).convention(convention).build();
    }

    public TermDepositTrade createTrade(LocalDate tradeDate, BuySell buySell, double notional, double rate, ReferenceData refData) {
        return this.convention.createTrade(tradeDate, this.depositPeriod, buySell, notional, rate, refData);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private TermDepositTemplate(Period depositPeriod, TermDepositConvention convention) {
        JodaBeanUtils.notNull((Object)depositPeriod, (String)"depositPeriod");
        JodaBeanUtils.notNull((Object)convention, (String)"convention");
        this.depositPeriod = depositPeriod;
        this.convention = convention;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Period getDepositPeriod() {
        return this.depositPeriod;
    }

    public TermDepositConvention getConvention() {
        return this.convention;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            TermDepositTemplate other = (TermDepositTemplate)obj;
            return JodaBeanUtils.equal((Object)this.depositPeriod, (Object)other.depositPeriod) && JodaBeanUtils.equal((Object)this.convention, (Object)other.convention);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.depositPeriod);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("TermDepositTemplate{");
        buf.append("depositPeriod").append('=').append(JodaBeanUtils.toString((Object)this.depositPeriod)).append(',').append(' ');
        buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<TermDepositTemplate> {
        private Period depositPeriod;
        private TermDepositConvention convention;

        private Builder() {
        }

        private Builder(TermDepositTemplate beanToCopy) {
            this.depositPeriod = beanToCopy.getDepositPeriod();
            this.convention = beanToCopy.getConvention();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 14649855: {
                    return this.depositPeriod;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 14649855: {
                    this.depositPeriod = (Period)newValue;
                    break;
                }
                case 2039569265: {
                    this.convention = (TermDepositConvention)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public TermDepositTemplate build() {
            return new TermDepositTemplate(this.depositPeriod, this.convention);
        }

        public Builder depositPeriod(Period depositPeriod) {
            JodaBeanUtils.notNull((Object)depositPeriod, (String)"depositPeriod");
            this.depositPeriod = depositPeriod;
            return this;
        }

        public Builder convention(TermDepositConvention convention) {
            JodaBeanUtils.notNull((Object)convention, (String)"convention");
            this.convention = convention;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("TermDepositTemplate.Builder{");
            buf.append("depositPeriod").append('=').append(JodaBeanUtils.toString((Object)this.depositPeriod)).append(',').append(' ');
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Period> depositPeriod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"depositPeriod", TermDepositTemplate.class, Period.class);
        private final MetaProperty<TermDepositConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", TermDepositTemplate.class, TermDepositConvention.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"depositPeriod", "convention"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 14649855: {
                    return this.depositPeriod;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends TermDepositTemplate> beanType() {
            return TermDepositTemplate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Period> depositPeriod() {
            return this.depositPeriod;
        }

        public MetaProperty<TermDepositConvention> convention() {
            return this.convention;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 14649855: {
                    return ((TermDepositTemplate)bean).getDepositPeriod();
                }
                case 2039569265: {
                    return ((TermDepositTemplate)bean).getConvention();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

