/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.dsf;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.SecuritizedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.dsf.ResolvedDsf;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class Dsf
implements SecuritizedProduct,
Resolvable<ResolvedDsf>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityId securityId;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastTradeDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate deliveryDate;
    @PropertyDefinition(validate="notNull")
    private final Swap underlyingSwap;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderOrEqual((Comparable)this.deliveryDate, (Object)this.underlyingSwap.getStartDate().getUnadjusted(), (String)"deliveryDate", (String)"underlyingSwap.startDate.unadjusted");
        ArgChecker.isFalse((boolean)this.underlyingSwap.isCrossCurrency(), (String)"Underlying swap must not be cross currency");
        for (SwapLeg swapLeg : this.underlyingSwap.getLegs()) {
            if (swapLeg.getType().equals((Object)SwapLegType.FIXED)) {
                ArgChecker.isTrue((boolean)swapLeg.getPayReceive().isReceive(), (String)"Underlying swap must receive the fixed leg");
            }
            if (!(swapLeg instanceof RateCalculationSwapLeg)) continue;
            RateCalculationSwapLeg leg = (RateCalculationSwapLeg)swapLeg;
            ArgChecker.isTrue((Math.abs(leg.getNotionalSchedule().getAmount().getInitialValue()) == 1.0 ? 1 : 0) != 0, (String)"Underlying swap must have a notional of 1");
        }
        ArgChecker.inOrderOrEqual((Comparable)this.lastTradeDate, (Object)this.deliveryDate, (String)"lastTradeDate", (String)"deliveryDate");
    }

    @Override
    public Currency getCurrency() {
        return this.underlyingSwap.getReceiveLeg().get().getCurrency();
    }

    public ResolvedDsf resolve(ReferenceData refData) {
        ResolvedSwap resolvedSwap = this.underlyingSwap.resolve(refData);
        return new ResolvedDsf(this.securityId, this.notional, this.deliveryDate, this.lastTradeDate, resolvedSwap);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    Dsf(SecurityId securityId, double notional, LocalDate lastTradeDate, LocalDate deliveryDate, Swap underlyingSwap) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
        JodaBeanUtils.notNull((Object)deliveryDate, (String)"deliveryDate");
        JodaBeanUtils.notNull((Object)underlyingSwap, (String)"underlyingSwap");
        this.securityId = securityId;
        this.notional = notional;
        this.lastTradeDate = lastTradeDate;
        this.deliveryDate = deliveryDate;
        this.underlyingSwap = underlyingSwap;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getLastTradeDate() {
        return this.lastTradeDate;
    }

    public LocalDate getDeliveryDate() {
        return this.deliveryDate;
    }

    public Swap getUnderlyingSwap() {
        return this.underlyingSwap;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Dsf other = (Dsf)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.lastTradeDate, (Object)other.lastTradeDate) && JodaBeanUtils.equal((Object)this.deliveryDate, (Object)other.deliveryDate) && JodaBeanUtils.equal((Object)this.underlyingSwap, (Object)other.underlyingSwap);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.deliveryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingSwap);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("Dsf{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
        buf.append("deliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.deliveryDate)).append(',').append(' ');
        buf.append("underlyingSwap").append('=').append(JodaBeanUtils.toString((Object)this.underlyingSwap));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<Dsf> {
        private SecurityId securityId;
        private double notional;
        private LocalDate lastTradeDate;
        private LocalDate deliveryDate;
        private Swap underlyingSwap;

        private Builder() {
        }

        private Builder(Dsf beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.notional = beanToCopy.getNotional();
            this.lastTradeDate = beanToCopy.getLastTradeDate();
            this.deliveryDate = beanToCopy.getDeliveryDate();
            this.underlyingSwap = beanToCopy.getUnderlyingSwap();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case 681469378: {
                    return this.deliveryDate;
                }
                case 1497421456: {
                    return this.underlyingSwap;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1041950404: {
                    this.lastTradeDate = (LocalDate)newValue;
                    break;
                }
                case 681469378: {
                    this.deliveryDate = (LocalDate)newValue;
                    break;
                }
                case 1497421456: {
                    this.underlyingSwap = (Swap)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public Dsf build() {
            return new Dsf(this.securityId, this.notional, this.lastTradeDate, this.deliveryDate, this.underlyingSwap);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder lastTradeDate(LocalDate lastTradeDate) {
            JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        public Builder deliveryDate(LocalDate deliveryDate) {
            JodaBeanUtils.notNull((Object)deliveryDate, (String)"deliveryDate");
            this.deliveryDate = deliveryDate;
            return this;
        }

        public Builder underlyingSwap(Swap underlyingSwap) {
            JodaBeanUtils.notNull((Object)underlyingSwap, (String)"underlyingSwap");
            this.underlyingSwap = underlyingSwap;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("Dsf.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
            buf.append("deliveryDate").append('=').append(JodaBeanUtils.toString((Object)this.deliveryDate)).append(',').append(' ');
            buf.append("underlyingSwap").append('=').append(JodaBeanUtils.toString((Object)this.underlyingSwap));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", Dsf.class, SecurityId.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", Dsf.class, Double.TYPE);
        private final MetaProperty<LocalDate> lastTradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastTradeDate", Dsf.class, LocalDate.class);
        private final MetaProperty<LocalDate> deliveryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"deliveryDate", Dsf.class, LocalDate.class);
        private final MetaProperty<Swap> underlyingSwap = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingSwap", Dsf.class, Swap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "notional", "lastTradeDate", "deliveryDate", "underlyingSwap"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case 681469378: {
                    return this.deliveryDate;
                }
                case 1497421456: {
                    return this.underlyingSwap;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends Dsf> beanType() {
            return Dsf.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> lastTradeDate() {
            return this.lastTradeDate;
        }

        public MetaProperty<LocalDate> deliveryDate() {
            return this.deliveryDate;
        }

        public MetaProperty<Swap> underlyingSwap() {
            return this.underlyingSwap;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((Dsf)bean).getSecurityId();
                }
                case 1585636160: {
                    return ((Dsf)bean).getNotional();
                }
                case -1041950404: {
                    return ((Dsf)bean).getLastTradeDate();
                }
                case 681469378: {
                    return ((Dsf)bean).getDeliveryDate();
                }
                case 1497421456: {
                    return ((Dsf)bean).getUnderlyingSwap();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

