/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.dsf;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.Security;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.dsf.Dsf;
import com.opengamma.strata.product.dsf.DsfPosition;
import com.opengamma.strata.product.dsf.DsfTrade;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class DsfSecurity
implements Security,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastTradeDate;
    @PropertyDefinition(validate="notNull")
    private final Swap underlyingSwap;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.isFalse((boolean)this.underlyingSwap.isCrossCurrency(), (String)"Underlying swap must not be cross currency");
        for (SwapLeg swapLeg : this.underlyingSwap.getLegs()) {
            if (swapLeg.getType().equals((Object)SwapLegType.FIXED)) {
                ArgChecker.isTrue((boolean)swapLeg.getPayReceive().isReceive(), (String)"Underlying swap must receive the fixed leg");
            }
            if (!(swapLeg instanceof RateCalculationSwapLeg)) continue;
            RateCalculationSwapLeg leg = (RateCalculationSwapLeg)swapLeg;
            ArgChecker.isTrue((Math.abs(leg.getNotionalSchedule().getAmount().getInitialValue()) == 1.0 ? 1 : 0) != 0, (String)"Underlying swap must have a notional of 1");
        }
    }

    @Override
    @DerivedProperty
    public Currency getCurrency() {
        return ((SwapLeg)this.underlyingSwap.getLegs().get(0)).getCurrency();
    }

    @Override
    public ImmutableSet<SecurityId> getUnderlyingIds() {
        return ImmutableSet.of();
    }

    @Override
    public DsfSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public Dsf createProduct(ReferenceData refData) {
        LocalDate deliveryDate = this.underlyingSwap.getStartDate().getUnadjusted();
        return new Dsf(this.getSecurityId(), this.notional, this.lastTradeDate, deliveryDate, this.underlyingSwap);
    }

    @Override
    public DsfTrade createTrade(TradeInfo info, double quantity, double tradePrice, ReferenceData refData) {
        return new DsfTrade(info, this.createProduct(refData), quantity, tradePrice);
    }

    @Override
    public DsfPosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return DsfPosition.ofNet(positionInfo, this.createProduct(refData), quantity);
    }

    @Override
    public DsfPosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return DsfPosition.ofLongShort(positionInfo, this.createProduct(refData), longQuantity, shortQuantity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DsfSecurity(SecurityInfo info, double notional, LocalDate lastTradeDate, Swap underlyingSwap) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
        JodaBeanUtils.notNull((Object)underlyingSwap, (String)"underlyingSwap");
        this.info = info;
        this.notional = notional;
        this.lastTradeDate = lastTradeDate;
        this.underlyingSwap = underlyingSwap;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getLastTradeDate() {
        return this.lastTradeDate;
    }

    public Swap getUnderlyingSwap() {
        return this.underlyingSwap;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DsfSecurity other = (DsfSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.lastTradeDate, (Object)other.lastTradeDate) && JodaBeanUtils.equal((Object)this.underlyingSwap, (Object)other.underlyingSwap);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingSwap);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("DsfSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
        buf.append("underlyingSwap").append('=').append(JodaBeanUtils.toString((Object)this.underlyingSwap)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.getCurrency()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<DsfSecurity> {
        private SecurityInfo info;
        private double notional;
        private LocalDate lastTradeDate;
        private Swap underlyingSwap;

        private Builder() {
        }

        private Builder(DsfSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.notional = beanToCopy.getNotional();
            this.lastTradeDate = beanToCopy.getLastTradeDate();
            this.underlyingSwap = beanToCopy.getUnderlyingSwap();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case 1497421456: {
                    return this.underlyingSwap;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1041950404: {
                    this.lastTradeDate = (LocalDate)newValue;
                    break;
                }
                case 1497421456: {
                    this.underlyingSwap = (Swap)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public DsfSecurity build() {
            return new DsfSecurity(this.info, this.notional, this.lastTradeDate, this.underlyingSwap);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder lastTradeDate(LocalDate lastTradeDate) {
            JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        public Builder underlyingSwap(Swap underlyingSwap) {
            JodaBeanUtils.notNull((Object)underlyingSwap, (String)"underlyingSwap");
            this.underlyingSwap = underlyingSwap;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("DsfSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
            buf.append("underlyingSwap").append('=').append(JodaBeanUtils.toString((Object)this.underlyingSwap)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", DsfSecurity.class, SecurityInfo.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", DsfSecurity.class, Double.TYPE);
        private final MetaProperty<LocalDate> lastTradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastTradeDate", DsfSecurity.class, LocalDate.class);
        private final MetaProperty<Swap> underlyingSwap = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingSwap", DsfSecurity.class, Swap.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofDerived((MetaBean)this, (String)"currency", DsfSecurity.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "notional", "lastTradeDate", "underlyingSwap", "currency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case 1497421456: {
                    return this.underlyingSwap;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends DsfSecurity> beanType() {
            return DsfSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> lastTradeDate() {
            return this.lastTradeDate;
        }

        public MetaProperty<Swap> underlyingSwap() {
            return this.underlyingSwap;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((DsfSecurity)bean).getInfo();
                }
                case 1585636160: {
                    return ((DsfSecurity)bean).getNotional();
                }
                case -1041950404: {
                    return ((DsfSecurity)bean).getLastTradeDate();
                }
                case 1497421456: {
                    return ((DsfSecurity)bean).getUnderlyingSwap();
                }
                case 575402001: {
                    return ((DsfSecurity)bean).getCurrency();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

