/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.dsf;

import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.TradedPrice;
import com.opengamma.strata.product.dsf.ResolvedDsf;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class ResolvedDsfTrade
implements ResolvedTrade,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final PortfolioItemInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ResolvedDsf product;
    @PropertyDefinition
    private final double quantity;
    @PropertyDefinition(get="optional")
    private final TradedPrice tradedPrice;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    ResolvedDsfTrade(PortfolioItemInfo info, ResolvedDsf product, double quantity, TradedPrice tradedPrice) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)product, (String)"product");
        this.info = info;
        this.product = product;
        this.quantity = quantity;
        this.tradedPrice = tradedPrice;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public PortfolioItemInfo getInfo() {
        return this.info;
    }

    @Override
    public ResolvedDsf getProduct() {
        return this.product;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public Optional<TradedPrice> getTradedPrice() {
        return Optional.ofNullable(this.tradedPrice);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedDsfTrade other = (ResolvedDsfTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.product, (Object)other.product) && JodaBeanUtils.equal((double)this.quantity, (double)other.quantity) && JodaBeanUtils.equal((Object)this.tradedPrice, (Object)other.tradedPrice);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.product);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.quantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tradedPrice);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("ResolvedDsfTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
        buf.append("tradedPrice").append('=').append(JodaBeanUtils.toString((Object)this.tradedPrice));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedDsfTrade> {
        private PortfolioItemInfo info;
        private ResolvedDsf product;
        private double quantity;
        private TradedPrice tradedPrice;

        private Builder() {
            ResolvedDsfTrade.applyDefaults(this);
        }

        private Builder(ResolvedDsfTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.product = beanToCopy.getProduct();
            this.quantity = beanToCopy.getQuantity();
            this.tradedPrice = beanToCopy.tradedPrice;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case -1873824343: {
                    return this.tradedPrice;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (PortfolioItemInfo)newValue;
                    break;
                }
                case -309474065: {
                    this.product = (ResolvedDsf)newValue;
                    break;
                }
                case -1285004149: {
                    this.quantity = (Double)newValue;
                    break;
                }
                case -1873824343: {
                    this.tradedPrice = (TradedPrice)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedDsfTrade build() {
            return new ResolvedDsfTrade(this.info, this.product, this.quantity, this.tradedPrice);
        }

        public Builder info(PortfolioItemInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder product(ResolvedDsf product) {
            JodaBeanUtils.notNull((Object)product, (String)"product");
            this.product = product;
            return this;
        }

        public Builder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder tradedPrice(TradedPrice tradedPrice) {
            this.tradedPrice = tradedPrice;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ResolvedDsfTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("product").append('=').append(JodaBeanUtils.toString((Object)this.product)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
            buf.append("tradedPrice").append('=').append(JodaBeanUtils.toString((Object)this.tradedPrice));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PortfolioItemInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", ResolvedDsfTrade.class, PortfolioItemInfo.class);
        private final MetaProperty<ResolvedDsf> product = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"product", ResolvedDsfTrade.class, ResolvedDsf.class);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quantity", ResolvedDsfTrade.class, Double.TYPE);
        private final MetaProperty<TradedPrice> tradedPrice = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tradedPrice", ResolvedDsfTrade.class, TradedPrice.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "product", "quantity", "tradedPrice"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case -309474065: {
                    return this.product;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case -1873824343: {
                    return this.tradedPrice;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedDsfTrade> beanType() {
            return ResolvedDsfTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PortfolioItemInfo> info() {
            return this.info;
        }

        public MetaProperty<ResolvedDsf> product() {
            return this.product;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        public MetaProperty<TradedPrice> tradedPrice() {
            return this.tradedPrice;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((ResolvedDsfTrade)bean).getInfo();
                }
                case -309474065: {
                    return ((ResolvedDsfTrade)bean).getProduct();
                }
                case -1285004149: {
                    return ((ResolvedDsfTrade)bean).getQuantity();
                }
                case -1873824343: {
                    return ((ResolvedDsfTrade)bean).tradedPrice;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

