/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.google.common.base.Splitter;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.common.ExchangeId;
import com.opengamma.strata.product.etd.EtdContractGroupCode;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class EtdContractGroupId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "::";
    private final ExchangeId exchangeId;
    private final EtdContractGroupCode code;

    public static EtdContractGroupId of(String exchangeId, String contractGroupCode) {
        return EtdContractGroupId.of(ExchangeId.of(exchangeId), EtdContractGroupCode.of(contractGroupCode));
    }

    public static EtdContractGroupId of(ExchangeId exchangeId, EtdContractGroupCode contractGroupCode) {
        return new EtdContractGroupId(exchangeId, contractGroupCode);
    }

    @FromString
    public static EtdContractGroupId parse(String str) {
        List split = Splitter.on((String)SEPARATOR).splitToList((CharSequence)str);
        if (split.size() != 2) {
            throw new IllegalArgumentException("Invalid contract group format: " + str);
        }
        return EtdContractGroupId.of((String)split.get(0), (String)split.get(1));
    }

    private EtdContractGroupId(ExchangeId exchangeId, EtdContractGroupCode contractGroupCode) {
        this.exchangeId = (ExchangeId)ArgChecker.notNull((Object)exchangeId, (String)"exchangeId");
        this.code = (EtdContractGroupCode)((Object)ArgChecker.notNull((Object)((Object)contractGroupCode), (String)"contractGroupCode"));
    }

    private Object readResolve() {
        return EtdContractGroupId.of(this.exchangeId, this.code);
    }

    public ExchangeId getExchangeId() {
        return this.exchangeId;
    }

    public EtdContractGroupCode getCode() {
        return this.code;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof EtdContractGroupId) {
            EtdContractGroupId other = (EtdContractGroupId)obj;
            return this.exchangeId.equals(other.exchangeId) && this.code.equals((Object)other.code);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exchangeId, this.code});
    }

    @ToString
    public String toString() {
        return this.exchangeId + SEPARATOR + (Object)((Object)this.code);
    }
}

