/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.named.Described;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.Attributes;
import com.opengamma.strata.product.SecurityPriceInfo;
import com.opengamma.strata.product.common.ExchangeId;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.etd.EtdContractCode;
import com.opengamma.strata.product.etd.EtdContractSpecBuilder;
import com.opengamma.strata.product.etd.EtdContractSpecId;
import com.opengamma.strata.product.etd.EtdFutureSecurity;
import com.opengamma.strata.product.etd.EtdOptionSecurity;
import com.opengamma.strata.product.etd.EtdType;
import com.opengamma.strata.product.etd.EtdVariant;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", constructorScope="package")
public final class EtdContractSpec
implements Attributes,
Described,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final EtdContractSpecId id;
    @PropertyDefinition(validate="notNull")
    private final EtdType type;
    @PropertyDefinition(validate="notNull")
    private final ExchangeId exchangeId;
    @PropertyDefinition(validate="notNull")
    private final EtdContractCode contractCode;
    @PropertyDefinition(validate="notEmpty", overrideGet=true)
    private final String description;
    @PropertyDefinition(validate="notNull")
    private final SecurityPriceInfo priceInfo;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<AttributeType<?>, Object> attributes;
    private static final long serialVersionUID = 1L;

    public static EtdContractSpecBuilder builder() {
        return new EtdContractSpecBuilder();
    }

    @Override
    public ImmutableSet<AttributeType<?>> getAttributeTypes() {
        return this.attributes.keySet();
    }

    @Override
    public <T> Optional<T> findAttribute(AttributeType<T> type) {
        return Optional.ofNullable(type.fromStoredForm(this.attributes.get(type)));
    }

    @Override
    public <T> EtdContractSpec withAttribute(AttributeType<T> type, T value) {
        HashMap updatedAttributes = new HashMap((Map<AttributeType<?>, Object>)this.attributes);
        if (value == null) {
            updatedAttributes.remove(type);
        } else {
            updatedAttributes.put(type, type.toStoredForm(value));
        }
        return new EtdContractSpec(this.id, this.type, this.exchangeId, this.contractCode, this.description, this.priceInfo, updatedAttributes);
    }

    @Override
    public EtdContractSpec withAttributes(Attributes other) {
        return (EtdContractSpec)Attributes.super.withAttributes(other);
    }

    public EtdFutureSecurity createFuture(YearMonth expiryMonth, EtdVariant variant) {
        return EtdFutureSecurity.of(this, expiryMonth, variant);
    }

    public EtdOptionSecurity createOption(YearMonth expiryMonth, EtdVariant variant, int version, PutCall putCall, double strikePrice) {
        return EtdOptionSecurity.of(this, expiryMonth, variant, version, putCall, strikePrice);
    }

    public EtdOptionSecurity createOption(YearMonth expiryMonth, EtdVariant variant, int version, PutCall putCall, double strikePrice, YearMonth underlyingExpiryMonth) {
        return EtdOptionSecurity.of(this, expiryMonth, variant, version, putCall, strikePrice, underlyingExpiryMonth);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    EtdContractSpec(EtdContractSpecId id, EtdType type, ExchangeId exchangeId, EtdContractCode contractCode, String description, SecurityPriceInfo priceInfo, Map<AttributeType<?>, Object> attributes) {
        JodaBeanUtils.notNull((Object)id, (String)"id");
        JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
        JodaBeanUtils.notNull((Object)exchangeId, (String)"exchangeId");
        JodaBeanUtils.notNull((Object)((Object)contractCode), (String)"contractCode");
        JodaBeanUtils.notEmpty((String)description, (String)"description");
        JodaBeanUtils.notNull((Object)priceInfo, (String)"priceInfo");
        JodaBeanUtils.notNull(attributes, (String)"attributes");
        this.id = id;
        this.type = type;
        this.exchangeId = exchangeId;
        this.contractCode = contractCode;
        this.description = description;
        this.priceInfo = priceInfo;
        this.attributes = ImmutableMap.copyOf(attributes);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public EtdContractSpecId getId() {
        return this.id;
    }

    public EtdType getType() {
        return this.type;
    }

    public ExchangeId getExchangeId() {
        return this.exchangeId;
    }

    public EtdContractCode getContractCode() {
        return this.contractCode;
    }

    public String getDescription() {
        return this.description;
    }

    public SecurityPriceInfo getPriceInfo() {
        return this.priceInfo;
    }

    public ImmutableMap<AttributeType<?>, Object> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            EtdContractSpec other = (EtdContractSpec)obj;
            return JodaBeanUtils.equal((Object)this.id, (Object)other.id) && JodaBeanUtils.equal((Object)((Object)this.type), (Object)((Object)other.type)) && JodaBeanUtils.equal((Object)this.exchangeId, (Object)other.exchangeId) && JodaBeanUtils.equal((Object)((Object)this.contractCode), (Object)((Object)other.contractCode)) && JodaBeanUtils.equal((Object)this.description, (Object)other.description) && JodaBeanUtils.equal((Object)this.priceInfo, (Object)other.priceInfo) && JodaBeanUtils.equal(this.attributes, other.attributes);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.id);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.type));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.exchangeId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.contractCode));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.description);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.priceInfo);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.attributes);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("EtdContractSpec{");
        buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
        buf.append("exchangeId").append('=').append(JodaBeanUtils.toString((Object)this.exchangeId)).append(',').append(' ');
        buf.append("contractCode").append('=').append(JodaBeanUtils.toString((Object)((Object)this.contractCode))).append(',').append(' ');
        buf.append("description").append('=').append(JodaBeanUtils.toString((Object)this.description)).append(',').append(' ');
        buf.append("priceInfo").append('=').append(JodaBeanUtils.toString((Object)this.priceInfo)).append(',').append(' ');
        buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<EtdContractSpec> {
        private EtdContractSpecId id;
        private EtdType type;
        private ExchangeId exchangeId;
        private EtdContractCode contractCode;
        private String description;
        private SecurityPriceInfo priceInfo;
        private Map<AttributeType<?>, Object> attributes = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case 3575610: {
                    return this.type;
                }
                case 913218206: {
                    return this.exchangeId;
                }
                case -1402840545: {
                    return this.contractCode;
                }
                case -1724546052: {
                    return this.description;
                }
                case -2126070377: {
                    return this.priceInfo;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    this.id = (EtdContractSpecId)newValue;
                    break;
                }
                case 3575610: {
                    this.type = (EtdType)((Object)newValue);
                    break;
                }
                case 913218206: {
                    this.exchangeId = (ExchangeId)newValue;
                    break;
                }
                case -1402840545: {
                    this.contractCode = (EtdContractCode)((Object)newValue);
                    break;
                }
                case -1724546052: {
                    this.description = (String)newValue;
                    break;
                }
                case -2126070377: {
                    this.priceInfo = (SecurityPriceInfo)newValue;
                    break;
                }
                case 405645655: {
                    this.attributes = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public EtdContractSpec build() {
            return new EtdContractSpec(this.id, this.type, this.exchangeId, this.contractCode, this.description, this.priceInfo, this.attributes);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("EtdContractSpec.Builder{");
            buf.append("id").append('=').append(JodaBeanUtils.toString((Object)this.id)).append(',').append(' ');
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
            buf.append("exchangeId").append('=').append(JodaBeanUtils.toString((Object)this.exchangeId)).append(',').append(' ');
            buf.append("contractCode").append('=').append(JodaBeanUtils.toString((Object)((Object)this.contractCode))).append(',').append(' ');
            buf.append("description").append('=').append(JodaBeanUtils.toString((Object)this.description)).append(',').append(' ');
            buf.append("priceInfo").append('=').append(JodaBeanUtils.toString((Object)this.priceInfo)).append(',').append(' ');
            buf.append("attributes").append('=').append(JodaBeanUtils.toString(this.attributes));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<EtdContractSpecId> id = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"id", EtdContractSpec.class, EtdContractSpecId.class);
        private final MetaProperty<EtdType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", EtdContractSpec.class, EtdType.class);
        private final MetaProperty<ExchangeId> exchangeId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"exchangeId", EtdContractSpec.class, ExchangeId.class);
        private final MetaProperty<EtdContractCode> contractCode = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"contractCode", EtdContractSpec.class, EtdContractCode.class);
        private final MetaProperty<String> description = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"description", EtdContractSpec.class, String.class);
        private final MetaProperty<SecurityPriceInfo> priceInfo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"priceInfo", EtdContractSpec.class, SecurityPriceInfo.class);
        private final MetaProperty<ImmutableMap<AttributeType<?>, Object>> attributes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"attributes", EtdContractSpec.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"id", "type", "exchangeId", "contractCode", "description", "priceInfo", "attributes"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return this.id;
                }
                case 3575610: {
                    return this.type;
                }
                case 913218206: {
                    return this.exchangeId;
                }
                case -1402840545: {
                    return this.contractCode;
                }
                case -1724546052: {
                    return this.description;
                }
                case -2126070377: {
                    return this.priceInfo;
                }
                case 405645655: {
                    return this.attributes;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends EtdContractSpec> builder() {
            return new Builder();
        }

        public Class<? extends EtdContractSpec> beanType() {
            return EtdContractSpec.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<EtdContractSpecId> id() {
            return this.id;
        }

        public MetaProperty<EtdType> type() {
            return this.type;
        }

        public MetaProperty<ExchangeId> exchangeId() {
            return this.exchangeId;
        }

        public MetaProperty<EtdContractCode> contractCode() {
            return this.contractCode;
        }

        public MetaProperty<String> description() {
            return this.description;
        }

        public MetaProperty<SecurityPriceInfo> priceInfo() {
            return this.priceInfo;
        }

        public MetaProperty<ImmutableMap<AttributeType<?>, Object>> attributes() {
            return this.attributes;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3355: {
                    return ((EtdContractSpec)bean).getId();
                }
                case 3575610: {
                    return ((EtdContractSpec)bean).getType();
                }
                case 913218206: {
                    return ((EtdContractSpec)bean).getExchangeId();
                }
                case -1402840545: {
                    return ((EtdContractSpec)bean).getContractCode();
                }
                case -1724546052: {
                    return ((EtdContractSpec)bean).getDescription();
                }
                case -2126070377: {
                    return ((EtdContractSpec)bean).getPriceInfo();
                }
                case 405645655: {
                    return ((EtdContractSpec)bean).getAttributes();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

