/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.SecurityPriceInfo;
import com.opengamma.strata.product.common.ExchangeId;
import com.opengamma.strata.product.etd.EtdContractCode;
import com.opengamma.strata.product.etd.EtdContractSpec;
import com.opengamma.strata.product.etd.EtdContractSpecId;
import com.opengamma.strata.product.etd.EtdIdUtils;
import com.opengamma.strata.product.etd.EtdType;
import java.util.HashMap;
import java.util.Map;
import org.joda.beans.JodaBeanUtils;

public final class EtdContractSpecBuilder {
    private EtdContractSpecId id;
    private EtdContractCode contractCode;
    private EtdType type;
    private ExchangeId exchangeId;
    private String description;
    private SecurityPriceInfo priceInfo;
    private final Map<AttributeType<?>, Object> attributes = new HashMap();

    EtdContractSpecBuilder() {
    }

    public EtdContractSpec build() {
        if (this.id == null) {
            this.id = EtdIdUtils.contractSpecId(this.type, this.exchangeId, this.contractCode);
        }
        return new EtdContractSpec(this.id, this.type, this.exchangeId, this.contractCode, this.description, this.priceInfo, this.attributes);
    }

    public EtdContractSpecBuilder id(EtdContractSpecId id) {
        JodaBeanUtils.notNull((Object)id, (String)"id");
        this.id = id;
        return this;
    }

    public EtdContractSpecBuilder type(EtdType productType) {
        JodaBeanUtils.notNull((Object)((Object)productType), (String)"productType");
        this.type = productType;
        return this;
    }

    public EtdContractSpecBuilder exchangeId(ExchangeId exchangeId) {
        JodaBeanUtils.notNull((Object)exchangeId, (String)"exchangeId");
        this.exchangeId = exchangeId;
        return this;
    }

    public EtdContractSpecBuilder contractCode(EtdContractCode contractCode) {
        JodaBeanUtils.notNull((Object)((Object)contractCode), (String)"contractCode");
        this.contractCode = contractCode;
        return this;
    }

    public EtdContractSpecBuilder description(String description) {
        JodaBeanUtils.notEmpty((String)description, (String)"description");
        this.description = description;
        return this;
    }

    public EtdContractSpecBuilder priceInfo(SecurityPriceInfo priceInfo) {
        JodaBeanUtils.notNull((Object)priceInfo, (String)"priceInfo");
        this.priceInfo = priceInfo;
        return this;
    }

    public <T> EtdContractSpecBuilder addAttribute(AttributeType<T> attributeType, T attributeValue) {
        JodaBeanUtils.notNull(attributeType, (String)"attributeType");
        JodaBeanUtils.notNull(attributeValue, (String)"attributeValue");
        this.attributes.put(attributeType, attributeType.toStoredForm(attributeValue));
        return this;
    }
}

