/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.etd.EtdContractSpec;
import com.opengamma.strata.product.etd.EtdContractSpecId;
import com.opengamma.strata.product.etd.EtdFuturePosition;
import com.opengamma.strata.product.etd.EtdFutureTrade;
import com.opengamma.strata.product.etd.EtdIdUtils;
import com.opengamma.strata.product.etd.EtdSecurity;
import com.opengamma.strata.product.etd.EtdType;
import com.opengamma.strata.product.etd.EtdVariant;
import java.io.Serializable;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class EtdFutureSecurity
implements EtdSecurity,
ImmutableBean,
Serializable {
    private static final DateTimeFormatter YM_FORMAT = DateTimeFormatter.ofPattern("MMMuu", Locale.ENGLISH);
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final EtdContractSpecId contractSpecId;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final YearMonth expiry;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final EtdVariant variant;
    private static final long serialVersionUID = 1L;

    public static EtdFutureSecurity of(EtdContractSpec spec, YearMonth expiry, EtdVariant variant) {
        if (spec.getType() != EtdType.FUTURE) {
            throw new IllegalStateException(Messages.format((String)"Cannot create an EtdFutureSecurity from a contract specification of type '{}'", (Object)((Object)spec.getType())));
        }
        SecurityId securityId = EtdIdUtils.futureId(spec.getExchangeId(), spec.getContractCode(), expiry, variant);
        return EtdFutureSecurity.builder().info(SecurityInfo.of(securityId, spec.getPriceInfo())).contractSpecId(spec.getId()).expiry(expiry).variant(variant).build();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.variant = EtdVariant.MONTHLY;
    }

    @Override
    public EtdType getType() {
        return EtdType.FUTURE;
    }

    @Override
    public EtdFutureSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public EtdFutureSecurity createProduct(ReferenceData refData) {
        return this;
    }

    @Override
    public EtdFutureTrade createTrade(TradeInfo tradeInfo, double quantity, double tradePrice, ReferenceData refData) {
        return EtdFutureTrade.builder().info(tradeInfo).quantity(quantity).price(tradePrice).security(this).build();
    }

    @Override
    public EtdFuturePosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return EtdFuturePosition.ofNet(positionInfo, this, quantity);
    }

    @Override
    public EtdFuturePosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return EtdFuturePosition.ofLongShort(positionInfo, this, longQuantity, shortQuantity);
    }

    public String summaryDescription() {
        return this.variant.getCode() + this.expiry.format(YM_FORMAT);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private EtdFutureSecurity(SecurityInfo info, EtdContractSpecId contractSpecId, YearMonth expiry, EtdVariant variant) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)contractSpecId, (String)"contractSpecId");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)variant, (String)"variant");
        this.info = info;
        this.contractSpecId = contractSpecId;
        this.expiry = expiry;
        this.variant = variant;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    @Override
    public EtdContractSpecId getContractSpecId() {
        return this.contractSpecId;
    }

    @Override
    public YearMonth getExpiry() {
        return this.expiry;
    }

    @Override
    public EtdVariant getVariant() {
        return this.variant;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            EtdFutureSecurity other = (EtdFutureSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.contractSpecId, (Object)other.contractSpecId) && JodaBeanUtils.equal((Object)this.expiry, (Object)other.expiry) && JodaBeanUtils.equal((Object)this.variant, (Object)other.variant);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.contractSpecId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.variant);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("EtdFutureSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("contractSpecId").append('=').append(JodaBeanUtils.toString((Object)this.contractSpecId)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("variant").append('=').append(JodaBeanUtils.toString((Object)this.variant));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<EtdFutureSecurity> {
        private SecurityInfo info;
        private EtdContractSpecId contractSpecId;
        private YearMonth expiry;
        private EtdVariant variant;

        private Builder() {
            EtdFutureSecurity.applyDefaults(this);
        }

        private Builder(EtdFutureSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.contractSpecId = beanToCopy.getContractSpecId();
            this.expiry = beanToCopy.getExpiry();
            this.variant = beanToCopy.getVariant();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 948987368: {
                    return this.contractSpecId;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 236785797: {
                    return this.variant;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 948987368: {
                    this.contractSpecId = (EtdContractSpecId)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (YearMonth)newValue;
                    break;
                }
                case 236785797: {
                    this.variant = (EtdVariant)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public EtdFutureSecurity build() {
            return new EtdFutureSecurity(this.info, this.contractSpecId, this.expiry, this.variant);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder contractSpecId(EtdContractSpecId contractSpecId) {
            JodaBeanUtils.notNull((Object)contractSpecId, (String)"contractSpecId");
            this.contractSpecId = contractSpecId;
            return this;
        }

        public Builder expiry(YearMonth expiry) {
            JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
            this.expiry = expiry;
            return this;
        }

        public Builder variant(EtdVariant variant) {
            JodaBeanUtils.notNull((Object)variant, (String)"variant");
            this.variant = variant;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("EtdFutureSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("contractSpecId").append('=').append(JodaBeanUtils.toString((Object)this.contractSpecId)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("variant").append('=').append(JodaBeanUtils.toString((Object)this.variant));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", EtdFutureSecurity.class, SecurityInfo.class);
        private final MetaProperty<EtdContractSpecId> contractSpecId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"contractSpecId", EtdFutureSecurity.class, EtdContractSpecId.class);
        private final MetaProperty<YearMonth> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", EtdFutureSecurity.class, YearMonth.class);
        private final MetaProperty<EtdVariant> variant = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"variant", EtdFutureSecurity.class, EtdVariant.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "contractSpecId", "expiry", "variant"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 948987368: {
                    return this.contractSpecId;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 236785797: {
                    return this.variant;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends EtdFutureSecurity> beanType() {
            return EtdFutureSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<EtdContractSpecId> contractSpecId() {
            return this.contractSpecId;
        }

        public MetaProperty<YearMonth> expiry() {
            return this.expiry;
        }

        public MetaProperty<EtdVariant> variant() {
            return this.variant;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((EtdFutureSecurity)bean).getInfo();
                }
                case 948987368: {
                    return ((EtdFutureSecurity)bean).getContractSpecId();
                }
                case -1289159373: {
                    return ((EtdFutureSecurity)bean).getExpiry();
                }
                case 236785797: {
                    return ((EtdFutureSecurity)bean).getVariant();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

