/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.google.common.base.Splitter;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.common.ExchangeId;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.etd.EtdContractCode;
import com.opengamma.strata.product.etd.EtdContractSpecId;
import com.opengamma.strata.product.etd.EtdType;
import com.opengamma.strata.product.etd.EtdVariant;
import com.opengamma.strata.product.etd.SplitEtdId;
import com.opengamma.strata.product.etd.SplitEtdOption;
import java.text.NumberFormat;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Locale;

public final class EtdIdUtils {
    public static final String ETD_SCHEME = "OG-ETD";
    private static final String SEPARATOR = "-";
    private static final String FUT_PREFIX = "F-";
    private static final String OPT_PREFIX = "O-";
    private static final DateTimeFormatter YM_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).toFormatter(Locale.ROOT);

    public static EtdContractSpecId contractSpecId(EtdType type, ExchangeId exchangeId, EtdContractCode contractCode) {
        ArgChecker.notNull((Object)((Object)type), (String)"type");
        ArgChecker.notNull((Object)exchangeId, (String)"exchangeId");
        ArgChecker.notNull((Object)((Object)contractCode), (String)"contractCode");
        switch (type) {
            case FUTURE: {
                return EtdContractSpecId.of(ETD_SCHEME, FUT_PREFIX + exchangeId + SEPARATOR + (Object)((Object)contractCode));
            }
            case OPTION: {
                return EtdContractSpecId.of(ETD_SCHEME, OPT_PREFIX + exchangeId + SEPARATOR + (Object)((Object)contractCode));
            }
        }
        throw new IllegalArgumentException("Unknown ETD type: " + (Object)((Object)type));
    }

    public static SecurityId futureId(ExchangeId exchangeId, EtdContractCode contractCode, YearMonth expiryMonth, EtdVariant variant) {
        ArgChecker.notNull((Object)exchangeId, (String)"exchangeId");
        ArgChecker.notNull((Object)((Object)contractCode), (String)"contractCode");
        ArgChecker.notNull((Object)expiryMonth, (String)"expiryMonth");
        ArgChecker.isTrue((expiryMonth.getYear() >= 1000 && expiryMonth.getYear() <= 9999 ? 1 : 0) != 0, (String)"Invalid expiry year: ", (Object[])new Object[]{expiryMonth});
        ArgChecker.notNull((Object)variant, (String)"variant");
        String id = new StringBuilder(40).append(FUT_PREFIX).append(exchangeId).append(SEPARATOR).append((Object)contractCode).append(SEPARATOR).append(expiryMonth.format(YM_FORMAT)).append(variant.getCode()).toString();
        return SecurityId.of(ETD_SCHEME, id);
    }

    public static SecurityId optionId(ExchangeId exchangeId, EtdContractCode contractCode, YearMonth expiryMonth, EtdVariant variant, int version, PutCall putCall, double strikePrice) {
        return EtdIdUtils.optionId(exchangeId, contractCode, expiryMonth, variant, version, putCall, strikePrice, null);
    }

    public static SecurityId optionId(ExchangeId exchangeId, EtdContractCode contractCode, YearMonth expiryMonth, EtdVariant variant, int version, PutCall putCall, double strikePrice, YearMonth underlyingExpiryMonth) {
        ArgChecker.notNull((Object)exchangeId, (String)"exchangeId");
        ArgChecker.notNull((Object)((Object)contractCode), (String)"contractCode");
        ArgChecker.notNull((Object)expiryMonth, (String)"expiryMonth");
        ArgChecker.notNull((Object)variant, (String)"variant");
        ArgChecker.notNull((Object)((Object)putCall), (String)"putCall");
        String putCallStr = putCall == PutCall.PUT ? "P" : "C";
        String versionCode = version > 0 ? "V" + version + SEPARATOR : "";
        NumberFormat f = NumberFormat.getIntegerInstance(Locale.ENGLISH);
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(8);
        String strikeStr = f.format(strikePrice).replace('-', 'M');
        String underlying = "";
        if (underlyingExpiryMonth != null && !underlyingExpiryMonth.equals(expiryMonth)) {
            underlying = "-U" + underlyingExpiryMonth.format(YM_FORMAT);
        }
        String id = new StringBuilder(40).append(OPT_PREFIX).append(exchangeId).append(SEPARATOR).append((Object)contractCode).append(SEPARATOR).append(expiryMonth.format(YM_FORMAT)).append(variant.getCode()).append(SEPARATOR).append(versionCode).append(putCallStr).append(strikeStr).append(underlying).toString();
        return SecurityId.of(ETD_SCHEME, id);
    }

    public static SplitEtdId splitId(SecurityId securityId) {
        ArgChecker.notNull((Object)securityId, (String)"securityId");
        if (!securityId.getStandardId().getScheme().equals(ETD_SCHEME)) {
            throw new IllegalArgumentException("ETD ID cannot be parsed: " + securityId);
        }
        List split = Splitter.on((char)'-').splitToList((CharSequence)securityId.getStandardId().getValue());
        if (split.size() < 4) {
            throw new IllegalArgumentException("ETD ID cannot be parsed: " + securityId);
        }
        ExchangeId exchangeId = ExchangeId.of((String)split.get(1));
        EtdContractCode contractCode = EtdContractCode.of((String)split.get(2));
        String dateStr = (String)split.get(3);
        if (dateStr.length() < 6) {
            throw new IllegalArgumentException("ETD ID cannot be parsed: " + securityId);
        }
        YearMonth month = YearMonth.parse(dateStr.substring(0, 6), YM_FORMAT);
        EtdVariant variant = EtdVariant.parseCode(dateStr.substring(6));
        SplitEtdId.Builder parsed = SplitEtdId.builder().securityId(securityId).exchangeId(exchangeId).contractCode(contractCode).expiry(month).variant(variant);
        if (securityId.getStandardId().getValue().startsWith(FUT_PREFIX) && split.size() == 4) {
            return parsed.build();
        }
        if (securityId.getStandardId().getValue().startsWith(OPT_PREFIX) && split.size() > 4) {
            SplitEtdOption parsedOption = EtdIdUtils.parseEtdOptionId(split, securityId);
            return parsed.option(parsedOption).build();
        }
        throw new IllegalArgumentException("ETD ID cannot be parsed: " + securityId);
    }

    private static SplitEtdOption parseEtdOptionId(List<String> split, SecurityId securityId) {
        PutCall putCall;
        String versionStr = split.get(4);
        String putCallStrikeStr = split.size() > 5 ? split.get(5) : "";
        String underlyingMonthStr = split.size() > 6 ? split.get(6) : "";
        int version = 0;
        if (versionStr.startsWith("V")) {
            version = Integer.parseInt(versionStr.substring(1));
        } else {
            underlyingMonthStr = putCallStrikeStr;
            putCallStrikeStr = versionStr;
        }
        if (putCallStrikeStr.startsWith("P")) {
            putCall = PutCall.PUT;
        } else if (putCallStrikeStr.startsWith("C")) {
            putCall = PutCall.CALL;
        } else {
            throw new IllegalArgumentException("ETD ID cannot be parsed: " + securityId);
        }
        String strikeStr = putCallStrikeStr.substring(1).replace('M', '-');
        double strike = Double.parseDouble(strikeStr);
        YearMonth underlyingMonth = null;
        if (!underlyingMonthStr.isEmpty()) {
            if (!underlyingMonthStr.startsWith("U") || underlyingMonthStr.length() != 7) {
                throw new IllegalArgumentException("ETD ID cannot be parsed: " + securityId);
            }
            underlyingMonth = YearMonth.parse(underlyingMonthStr.substring(1), YM_FORMAT);
        }
        return SplitEtdOption.of(version, putCall, strike, underlyingMonth);
    }

    private EtdIdUtils() {
    }
}

