/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.etd.EtdContractSpec;
import com.opengamma.strata.product.etd.EtdContractSpecId;
import com.opengamma.strata.product.etd.EtdIdUtils;
import com.opengamma.strata.product.etd.EtdOptionPosition;
import com.opengamma.strata.product.etd.EtdOptionTrade;
import com.opengamma.strata.product.etd.EtdSecurity;
import com.opengamma.strata.product.etd.EtdType;
import com.opengamma.strata.product.etd.EtdVariant;
import java.io.Serializable;
import java.text.NumberFormat;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class EtdOptionSecurity
implements EtdSecurity,
ImmutableBean,
Serializable {
    private static final DateTimeFormatter YM_FORMAT = DateTimeFormatter.ofPattern("MMMuu", Locale.ENGLISH);
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final EtdContractSpecId contractSpecId;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final YearMonth expiry;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final EtdVariant variant;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final int version;
    @PropertyDefinition(validate="notNull")
    private final PutCall putCall;
    @PropertyDefinition
    private final double strikePrice;
    @PropertyDefinition(get="optional")
    private final YearMonth underlyingExpiryMonth;
    private static final long serialVersionUID = 1L;

    public static EtdOptionSecurity of(EtdContractSpec spec, YearMonth expiry, EtdVariant variant, int version, PutCall putCall, double strikePrice) {
        return EtdOptionSecurity.of(spec, expiry, variant, version, putCall, strikePrice, null);
    }

    public static EtdOptionSecurity of(EtdContractSpec spec, YearMonth expiry, EtdVariant variant, int version, PutCall putCall, double strikePrice, YearMonth underlyingExpiryMonth) {
        if (spec.getType() != EtdType.OPTION) {
            throw new IllegalStateException(Messages.format((String)"Cannot create an EtdOptionSecurity from a contract specification of type '{}'", (Object)((Object)spec.getType())));
        }
        SecurityId securityId = EtdIdUtils.optionId(spec.getExchangeId(), spec.getContractCode(), expiry, variant, version, putCall, strikePrice, underlyingExpiryMonth);
        return EtdOptionSecurity.builder().info(SecurityInfo.of(securityId, spec.getPriceInfo())).contractSpecId(spec.getId()).expiry(expiry).variant(variant).version(version).putCall(putCall).strikePrice(strikePrice).underlyingExpiryMonth(underlyingExpiryMonth).build();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.variant = EtdVariant.MONTHLY;
    }

    @Override
    public EtdType getType() {
        return EtdType.OPTION;
    }

    @Override
    public EtdOptionSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public EtdOptionSecurity createProduct(ReferenceData refData) {
        return this;
    }

    @Override
    public EtdOptionTrade createTrade(TradeInfo tradeInfo, double quantity, double tradePrice, ReferenceData refData) {
        return EtdOptionTrade.builder().info(tradeInfo).quantity(quantity).price(tradePrice).security(this).build();
    }

    @Override
    public EtdOptionPosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return EtdOptionPosition.ofNet(positionInfo, this, quantity);
    }

    @Override
    public EtdOptionPosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return EtdOptionPosition.ofLongShort(positionInfo, this, longQuantity, shortQuantity);
    }

    public String summaryDescription() {
        String putCallStr = this.putCall == PutCall.PUT ? "P" : "C";
        String versionCode = this.version > 0 ? "V" + this.version + " " : "";
        NumberFormat f = NumberFormat.getIntegerInstance(Locale.ENGLISH);
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(8);
        String strikeStr = f.format(this.strikePrice).replace('-', 'M');
        return this.expiry.format(YM_FORMAT) + this.variant.getCode() + " " + versionCode + putCallStr + strikeStr;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private EtdOptionSecurity(SecurityInfo info, EtdContractSpecId contractSpecId, YearMonth expiry, EtdVariant variant, int version, PutCall putCall, double strikePrice, YearMonth underlyingExpiryMonth) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)contractSpecId, (String)"contractSpecId");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)variant, (String)"variant");
        ArgChecker.notNegative((int)version, (String)"version");
        JodaBeanUtils.notNull((Object)((Object)putCall), (String)"putCall");
        this.info = info;
        this.contractSpecId = contractSpecId;
        this.expiry = expiry;
        this.variant = variant;
        this.version = version;
        this.putCall = putCall;
        this.strikePrice = strikePrice;
        this.underlyingExpiryMonth = underlyingExpiryMonth;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    @Override
    public EtdContractSpecId getContractSpecId() {
        return this.contractSpecId;
    }

    @Override
    public YearMonth getExpiry() {
        return this.expiry;
    }

    @Override
    public EtdVariant getVariant() {
        return this.variant;
    }

    public int getVersion() {
        return this.version;
    }

    public PutCall getPutCall() {
        return this.putCall;
    }

    public double getStrikePrice() {
        return this.strikePrice;
    }

    public Optional<YearMonth> getUnderlyingExpiryMonth() {
        return Optional.ofNullable(this.underlyingExpiryMonth);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            EtdOptionSecurity other = (EtdOptionSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.contractSpecId, (Object)other.contractSpecId) && JodaBeanUtils.equal((Object)this.expiry, (Object)other.expiry) && JodaBeanUtils.equal((Object)this.variant, (Object)other.variant) && this.version == other.version && JodaBeanUtils.equal((Object)((Object)this.putCall), (Object)((Object)other.putCall)) && JodaBeanUtils.equal((double)this.strikePrice, (double)other.strikePrice) && JodaBeanUtils.equal((Object)this.underlyingExpiryMonth, (Object)other.underlyingExpiryMonth);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.contractSpecId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.variant);
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.version);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.putCall));
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strikePrice);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingExpiryMonth);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(288);
        buf.append("EtdOptionSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("contractSpecId").append('=').append(JodaBeanUtils.toString((Object)this.contractSpecId)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("variant").append('=').append(JodaBeanUtils.toString((Object)this.variant)).append(',').append(' ');
        buf.append("version").append('=').append(JodaBeanUtils.toString((Object)this.version)).append(',').append(' ');
        buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
        buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
        buf.append("underlyingExpiryMonth").append('=').append(JodaBeanUtils.toString((Object)this.underlyingExpiryMonth));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<EtdOptionSecurity> {
        private SecurityInfo info;
        private EtdContractSpecId contractSpecId;
        private YearMonth expiry;
        private EtdVariant variant;
        private int version;
        private PutCall putCall;
        private double strikePrice;
        private YearMonth underlyingExpiryMonth;

        private Builder() {
            EtdOptionSecurity.applyDefaults(this);
        }

        private Builder(EtdOptionSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.contractSpecId = beanToCopy.getContractSpecId();
            this.expiry = beanToCopy.getExpiry();
            this.variant = beanToCopy.getVariant();
            this.version = beanToCopy.getVersion();
            this.putCall = beanToCopy.getPutCall();
            this.strikePrice = beanToCopy.getStrikePrice();
            this.underlyingExpiryMonth = beanToCopy.underlyingExpiryMonth;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 948987368: {
                    return this.contractSpecId;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 236785797: {
                    return this.variant;
                }
                case 351608024: {
                    return this.version;
                }
                case -219971059: {
                    return this.putCall;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case 1929351536: {
                    return this.underlyingExpiryMonth;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 948987368: {
                    this.contractSpecId = (EtdContractSpecId)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (YearMonth)newValue;
                    break;
                }
                case 236785797: {
                    this.variant = (EtdVariant)newValue;
                    break;
                }
                case 351608024: {
                    this.version = (Integer)newValue;
                    break;
                }
                case -219971059: {
                    this.putCall = (PutCall)((Object)newValue);
                    break;
                }
                case 50946231: {
                    this.strikePrice = (Double)newValue;
                    break;
                }
                case 1929351536: {
                    this.underlyingExpiryMonth = (YearMonth)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public EtdOptionSecurity build() {
            return new EtdOptionSecurity(this.info, this.contractSpecId, this.expiry, this.variant, this.version, this.putCall, this.strikePrice, this.underlyingExpiryMonth);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder contractSpecId(EtdContractSpecId contractSpecId) {
            JodaBeanUtils.notNull((Object)contractSpecId, (String)"contractSpecId");
            this.contractSpecId = contractSpecId;
            return this;
        }

        public Builder expiry(YearMonth expiry) {
            JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
            this.expiry = expiry;
            return this;
        }

        public Builder variant(EtdVariant variant) {
            JodaBeanUtils.notNull((Object)variant, (String)"variant");
            this.variant = variant;
            return this;
        }

        public Builder version(int version) {
            ArgChecker.notNegative((int)version, (String)"version");
            this.version = version;
            return this;
        }

        public Builder putCall(PutCall putCall) {
            JodaBeanUtils.notNull((Object)((Object)putCall), (String)"putCall");
            this.putCall = putCall;
            return this;
        }

        public Builder strikePrice(double strikePrice) {
            this.strikePrice = strikePrice;
            return this;
        }

        public Builder underlyingExpiryMonth(YearMonth underlyingExpiryMonth) {
            this.underlyingExpiryMonth = underlyingExpiryMonth;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(288);
            buf.append("EtdOptionSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("contractSpecId").append('=').append(JodaBeanUtils.toString((Object)this.contractSpecId)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("variant").append('=').append(JodaBeanUtils.toString((Object)this.variant)).append(',').append(' ');
            buf.append("version").append('=').append(JodaBeanUtils.toString((Object)this.version)).append(',').append(' ');
            buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
            buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
            buf.append("underlyingExpiryMonth").append('=').append(JodaBeanUtils.toString((Object)this.underlyingExpiryMonth));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", EtdOptionSecurity.class, SecurityInfo.class);
        private final MetaProperty<EtdContractSpecId> contractSpecId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"contractSpecId", EtdOptionSecurity.class, EtdContractSpecId.class);
        private final MetaProperty<YearMonth> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", EtdOptionSecurity.class, YearMonth.class);
        private final MetaProperty<EtdVariant> variant = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"variant", EtdOptionSecurity.class, EtdVariant.class);
        private final MetaProperty<Integer> version = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"version", EtdOptionSecurity.class, Integer.TYPE);
        private final MetaProperty<PutCall> putCall = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"putCall", EtdOptionSecurity.class, PutCall.class);
        private final MetaProperty<Double> strikePrice = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikePrice", EtdOptionSecurity.class, Double.TYPE);
        private final MetaProperty<YearMonth> underlyingExpiryMonth = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingExpiryMonth", EtdOptionSecurity.class, YearMonth.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "contractSpecId", "expiry", "variant", "version", "putCall", "strikePrice", "underlyingExpiryMonth"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 948987368: {
                    return this.contractSpecId;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 236785797: {
                    return this.variant;
                }
                case 351608024: {
                    return this.version;
                }
                case -219971059: {
                    return this.putCall;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case 1929351536: {
                    return this.underlyingExpiryMonth;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends EtdOptionSecurity> beanType() {
            return EtdOptionSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<EtdContractSpecId> contractSpecId() {
            return this.contractSpecId;
        }

        public MetaProperty<YearMonth> expiry() {
            return this.expiry;
        }

        public MetaProperty<EtdVariant> variant() {
            return this.variant;
        }

        public MetaProperty<Integer> version() {
            return this.version;
        }

        public MetaProperty<PutCall> putCall() {
            return this.putCall;
        }

        public MetaProperty<Double> strikePrice() {
            return this.strikePrice;
        }

        public MetaProperty<YearMonth> underlyingExpiryMonth() {
            return this.underlyingExpiryMonth;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((EtdOptionSecurity)bean).getInfo();
                }
                case 948987368: {
                    return ((EtdOptionSecurity)bean).getContractSpecId();
                }
                case -1289159373: {
                    return ((EtdOptionSecurity)bean).getExpiry();
                }
                case 236785797: {
                    return ((EtdOptionSecurity)bean).getVariant();
                }
                case 351608024: {
                    return ((EtdOptionSecurity)bean).getVersion();
                }
                case -219971059: {
                    return ((EtdOptionSecurity)bean).getPutCall();
                }
                case 50946231: {
                    return ((EtdOptionSecurity)bean).getStrikePrice();
                }
                case 1929351536: {
                    return ((EtdOptionSecurity)bean).underlyingExpiryMonth;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

