/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.product.PortfolioItemInfo;
import com.opengamma.strata.product.PortfolioItemSummary;
import com.opengamma.strata.product.ProductType;
import com.opengamma.strata.product.ResolvableSecurityTrade;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.SummarizerUtils;
import com.opengamma.strata.product.etd.EtdOptionSecurity;
import com.opengamma.strata.product.etd.EtdTrade;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class EtdOptionTrade
implements EtdTrade,
ResolvableSecurityTrade,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final TradeInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final EtdOptionSecurity security;
    @PropertyDefinition(overrideGet=true)
    private final double quantity;
    @PropertyDefinition(overrideGet=true)
    private final double price;
    private static final long serialVersionUID = 1L;

    public static EtdOptionTrade of(TradeInfo tradeInfo, EtdOptionSecurity security, double quantity, double price) {
        return new EtdOptionTrade(tradeInfo, security, quantity, price);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.info = TradeInfo.empty();
    }

    @Override
    public PortfolioItemSummary summarize() {
        String option = this.security.summaryDescription();
        String description = this.getSecurityId().getStandardId().getValue() + " x " + SummarizerUtils.value(this.getQuantity()) + ", " + option;
        return SummarizerUtils.summary(this, ProductType.ETD_OPTION, description, this.getCurrency());
    }

    @Override
    public EtdOptionTrade withInfo(PortfolioItemInfo info) {
        return new EtdOptionTrade(TradeInfo.from(info), this.security, this.quantity, this.price);
    }

    @Override
    public EtdOptionTrade withQuantity(double quantity) {
        return new EtdOptionTrade(this.info, this.security, quantity, this.price);
    }

    @Override
    public EtdOptionTrade withPrice(double price) {
        return new EtdOptionTrade(this.info, this.security, this.quantity, price);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private EtdOptionTrade(TradeInfo info, EtdOptionSecurity security, double quantity, double price) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)security, (String)"security");
        this.info = info;
        this.security = security;
        this.quantity = quantity;
        this.price = price;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public TradeInfo getInfo() {
        return this.info;
    }

    @Override
    public EtdOptionSecurity getSecurity() {
        return this.security;
    }

    @Override
    public double getQuantity() {
        return this.quantity;
    }

    @Override
    public double getPrice() {
        return this.price;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            EtdOptionTrade other = (EtdOptionTrade)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.security, (Object)other.security) && JodaBeanUtils.equal((double)this.quantity, (double)other.quantity) && JodaBeanUtils.equal((double)this.price, (double)other.price);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.security);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.quantity);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.price);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("EtdOptionTrade{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("security").append('=').append(JodaBeanUtils.toString((Object)this.security)).append(',').append(' ');
        buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
        buf.append("price").append('=').append(JodaBeanUtils.toString((Object)this.price));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<EtdOptionTrade> {
        private TradeInfo info;
        private EtdOptionSecurity security;
        private double quantity;
        private double price;

        private Builder() {
            EtdOptionTrade.applyDefaults(this);
        }

        private Builder(EtdOptionTrade beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.security = beanToCopy.getSecurity();
            this.quantity = beanToCopy.getQuantity();
            this.price = beanToCopy.getPrice();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 949122880: {
                    return this.security;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 106934601: {
                    return this.price;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (TradeInfo)newValue;
                    break;
                }
                case 949122880: {
                    this.security = (EtdOptionSecurity)newValue;
                    break;
                }
                case -1285004149: {
                    this.quantity = (Double)newValue;
                    break;
                }
                case 106934601: {
                    this.price = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public EtdOptionTrade build() {
            return new EtdOptionTrade(this.info, this.security, this.quantity, this.price);
        }

        public Builder info(TradeInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder security(EtdOptionSecurity security) {
            JodaBeanUtils.notNull((Object)security, (String)"security");
            this.security = security;
            return this;
        }

        public Builder quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        public Builder price(double price) {
            this.price = price;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("EtdOptionTrade.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("security").append('=').append(JodaBeanUtils.toString((Object)this.security)).append(',').append(' ');
            buf.append("quantity").append('=').append(JodaBeanUtils.toString((Object)this.quantity)).append(',').append(' ');
            buf.append("price").append('=').append(JodaBeanUtils.toString((Object)this.price));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<TradeInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", EtdOptionTrade.class, TradeInfo.class);
        private final MetaProperty<EtdOptionSecurity> security = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"security", EtdOptionTrade.class, EtdOptionSecurity.class);
        private final MetaProperty<Double> quantity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"quantity", EtdOptionTrade.class, Double.TYPE);
        private final MetaProperty<Double> price = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"price", EtdOptionTrade.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "security", "quantity", "price"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 949122880: {
                    return this.security;
                }
                case -1285004149: {
                    return this.quantity;
                }
                case 106934601: {
                    return this.price;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends EtdOptionTrade> beanType() {
            return EtdOptionTrade.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<TradeInfo> info() {
            return this.info;
        }

        public MetaProperty<EtdOptionSecurity> security() {
            return this.security;
        }

        public MetaProperty<Double> quantity() {
            return this.quantity;
        }

        public MetaProperty<Double> price() {
            return this.price;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((EtdOptionTrade)bean).getInfo();
                }
                case 949122880: {
                    return ((EtdOptionTrade)bean).getSecurity();
                }
                case -1285004149: {
                    return ((EtdOptionTrade)bean).getQuantity();
                }
                case 106934601: {
                    return ((EtdOptionTrade)bean).getPrice();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

