/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum EtdOptionType implements NamedEnum
{
    AMERICAN("A"),
    EUROPEAN("E");

    private static final EnumNames<EtdOptionType> NAMES;
    private final String code;

    private EtdOptionType(String code) {
        this.code = code;
    }

    @FromString
    public static EtdOptionType of(String name) {
        return (EtdOptionType)NAMES.parse(name);
    }

    static EtdOptionType parseCode(String code) {
        switch (code) {
            case "A": {
                return AMERICAN;
            }
            case "E": {
                return EUROPEAN;
            }
        }
        throw new IllegalArgumentException("Unknown EtdOptionType code: " + code);
    }

    public String getCode() {
        return this.code;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(EtdOptionType.class);
    }
}

