/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum EtdSettlementType implements NamedEnum
{
    CASH("C"),
    PHYSICAL("E"),
    DERIVATIVE("D"),
    NOTIONAL("N"),
    PAYMENT_VS_PAYMENT("P"),
    STOCK("S"),
    CASCADE("T"),
    ALTERNATE("A");

    private static final EnumNames<EtdSettlementType> NAMES;
    private final String code;

    private EtdSettlementType(String code) {
        this.code = code;
    }

    @FromString
    public static EtdSettlementType of(String name) {
        return (EtdSettlementType)NAMES.parse(name);
    }

    static EtdSettlementType parseCode(String code) {
        switch (code) {
            case "C": {
                return CASH;
            }
            case "E": {
                return PHYSICAL;
            }
            case "D": {
                return DERIVATIVE;
            }
            case "N": {
                return NOTIONAL;
            }
            case "P": {
                return PAYMENT_VS_PAYMENT;
            }
            case "S": {
                return STOCK;
            }
            case "T": {
                return CASCADE;
            }
            case "A": {
                return ALTERNATE;
            }
        }
        throw new IllegalArgumentException("Unknown EtdSettlementType code: " + code);
    }

    public String getCode() {
        return this.code;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(EtdSettlementType.class);
    }
}

