/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.etd.EtdExpiryType;
import com.opengamma.strata.product.etd.EtdOptionType;
import com.opengamma.strata.product.etd.EtdSettlementType;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private", metaScope="private")
public final class EtdVariant
implements ImmutableBean,
Serializable {
    public static final EtdVariant MONTHLY = new EtdVariant(EtdExpiryType.MONTHLY, null, null, null);
    @PropertyDefinition(validate="notNull")
    private final EtdExpiryType type;
    @PropertyDefinition(get="optional")
    private final Integer dateCode;
    @PropertyDefinition(get="optional")
    private final EtdSettlementType settlementType;
    @PropertyDefinition(get="optional")
    private final EtdOptionType optionType;
    private final String code;
    private static final long serialVersionUID = 1L;

    public static EtdVariant ofMonthly() {
        return MONTHLY;
    }

    public static EtdVariant ofWeekly(int week) {
        return new EtdVariant(EtdExpiryType.WEEKLY, week, null, null);
    }

    public static EtdVariant ofDaily(int dayOfMonth) {
        return new EtdVariant(EtdExpiryType.DAILY, dayOfMonth, null, null);
    }

    public static EtdVariant ofFlexFuture(int dayOfMonth, EtdSettlementType settlementType) {
        return new EtdVariant(EtdExpiryType.DAILY, dayOfMonth, settlementType, null);
    }

    public static EtdVariant ofFlexOption(int dayOfMonth, EtdSettlementType settlementType, EtdOptionType optionType) {
        return new EtdVariant(EtdExpiryType.DAILY, dayOfMonth, settlementType, optionType);
    }

    static EtdVariant parseCode(String code) {
        switch (code.length()) {
            case 0: {
                return MONTHLY;
            }
            case 2: {
                if (code.charAt(0) == 'W') {
                    return EtdVariant.ofWeekly(Integer.parseInt(code.substring(1)));
                }
                return EtdVariant.ofDaily(Integer.parseInt(code));
            }
            case 3: {
                int dom = EtdVariant.parseDay(code);
                EtdSettlementType settlementType = EtdSettlementType.parseCode(code.substring(2));
                return EtdVariant.ofFlexFuture(dom, settlementType);
            }
            case 4: {
                int dom = EtdVariant.parseDay(code);
                EtdSettlementType settlementType = EtdSettlementType.parseCode(code.substring(2, 3));
                EtdOptionType optionType = EtdOptionType.parseCode(code.substring(3, 4));
                return EtdVariant.ofFlexOption(dom, settlementType, optionType);
            }
        }
        throw new IllegalArgumentException("Invalid EtdVariant code: " + code);
    }

    private static int parseDay(String code) {
        return code.charAt(0) == '0' ? Integer.parseInt(code.substring(1, 2)) : Integer.parseInt(code.substring(0, 2));
    }

    @ImmutableConstructor
    private EtdVariant(EtdExpiryType type, Integer dateCode, EtdSettlementType settlementType, EtdOptionType optionType) {
        this.type = (EtdExpiryType)((Object)ArgChecker.notNull((Object)((Object)type), (String)"type"));
        this.dateCode = dateCode;
        this.settlementType = settlementType;
        this.optionType = optionType;
        if (type == EtdExpiryType.MONTHLY) {
            ArgChecker.isTrue((dateCode == null ? 1 : 0) != 0, (String)"Monthly variant must have no dateCode");
            ArgChecker.isTrue((settlementType == null ? 1 : 0) != 0, (String)"Monthly variant must have no settlementType");
            ArgChecker.isTrue((optionType == null ? 1 : 0) != 0, (String)"Monthly variant must have no optionType");
            this.code = "";
        } else if (type == EtdExpiryType.WEEKLY) {
            ArgChecker.notNull((Object)dateCode, (String)"dateCode");
            ArgChecker.isTrue((dateCode >= 1 && dateCode <= 5 ? 1 : 0) != 0, (String)"Week must be from 1 to 5");
            ArgChecker.isTrue((settlementType == null ? 1 : 0) != 0, (String)"Weekly variant must have no settlementType");
            ArgChecker.isTrue((optionType == null ? 1 : 0) != 0, (String)"Weekly variant must have no optionType");
            this.code = "W" + dateCode;
        } else {
            ArgChecker.notNull((Object)dateCode, (String)"dateCode");
            ArgChecker.isTrue((dateCode >= 1 && dateCode <= 31 ? 1 : 0) != 0, (String)"Day-of-week must be from 1 to 31");
            ArgChecker.isFalse((settlementType == null && optionType != null ? 1 : 0) != 0, (String)"Flex Option must have both settlementType and optionType");
            String dateCodeStr = dateCode < 10 ? "0" + dateCode : Integer.toString(dateCode);
            String settlementCode = settlementType != null ? settlementType.getCode() : "";
            String optionCode = optionType != null ? optionType.getCode() : "";
            this.code = dateCodeStr + settlementCode + optionCode;
        }
    }

    private Object readResolve() {
        return new EtdVariant(this.type, this.dateCode, this.settlementType, this.optionType);
    }

    public boolean isFlex() {
        return this.settlementType != null;
    }

    public String getCode() {
        return this.code;
    }

    public static MetaBean meta() {
        return Meta.INSTANCE;
    }

    public MetaBean metaBean() {
        return Meta.INSTANCE;
    }

    public EtdExpiryType getType() {
        return this.type;
    }

    public OptionalInt getDateCode() {
        return this.dateCode != null ? OptionalInt.of(this.dateCode) : OptionalInt.empty();
    }

    public Optional<EtdSettlementType> getSettlementType() {
        return Optional.ofNullable(this.settlementType);
    }

    public Optional<EtdOptionType> getOptionType() {
        return Optional.ofNullable(this.optionType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            EtdVariant other = (EtdVariant)obj;
            return JodaBeanUtils.equal((Object)((Object)this.type), (Object)((Object)other.type)) && JodaBeanUtils.equal((Object)this.dateCode, (Object)other.dateCode) && JodaBeanUtils.equal((Object)((Object)this.settlementType), (Object)((Object)other.settlementType)) && JodaBeanUtils.equal((Object)((Object)this.optionType), (Object)((Object)other.optionType));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.type));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateCode);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.settlementType));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.optionType));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("EtdVariant{");
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
        buf.append("dateCode").append('=').append(JodaBeanUtils.toString((Object)this.dateCode)).append(',').append(' ');
        buf.append("settlementType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.settlementType))).append(',').append(' ');
        buf.append("optionType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.optionType)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<EtdVariant> {
        private EtdExpiryType type;
        private Integer dateCode;
        private EtdSettlementType settlementType;
        private EtdOptionType optionType;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case 1792248507: {
                    return this.dateCode;
                }
                case -295448573: {
                    return this.settlementType;
                }
                case 1373587791: {
                    return this.optionType;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    this.type = (EtdExpiryType)((Object)newValue);
                    break;
                }
                case 1792248507: {
                    this.dateCode = (Integer)newValue;
                    break;
                }
                case -295448573: {
                    this.settlementType = (EtdSettlementType)((Object)newValue);
                    break;
                }
                case 1373587791: {
                    this.optionType = (EtdOptionType)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public EtdVariant build() {
            return new EtdVariant(this.type, this.dateCode, this.settlementType, this.optionType);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("EtdVariant.Builder{");
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
            buf.append("dateCode").append('=').append(JodaBeanUtils.toString((Object)this.dateCode)).append(',').append(' ');
            buf.append("settlementType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.settlementType))).append(',').append(' ');
            buf.append("optionType").append('=').append(JodaBeanUtils.toString((Object)((Object)this.optionType)));
            buf.append('}');
            return buf.toString();
        }
    }

    private static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<EtdExpiryType> type = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"type", EtdVariant.class, EtdExpiryType.class);
        private final MetaProperty<Integer> dateCode = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dateCode", EtdVariant.class, Integer.class);
        private final MetaProperty<EtdSettlementType> settlementType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementType", EtdVariant.class, EtdSettlementType.class);
        private final MetaProperty<EtdOptionType> optionType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"optionType", EtdVariant.class, EtdOptionType.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"type", "dateCode", "settlementType", "optionType"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return this.type;
                }
                case 1792248507: {
                    return this.dateCode;
                }
                case -295448573: {
                    return this.settlementType;
                }
                case 1373587791: {
                    return this.optionType;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends EtdVariant> builder() {
            return new Builder();
        }

        public Class<? extends EtdVariant> beanType() {
            return EtdVariant.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3575610: {
                    return ((EtdVariant)bean).getType();
                }
                case 1792248507: {
                    return ((EtdVariant)bean).dateCode;
                }
                case -295448573: {
                    return ((EtdVariant)bean).settlementType;
                }
                case 1373587791: {
                    return ((EtdVariant)bean).optionType;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

