/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.common.ExchangeId;
import com.opengamma.strata.product.etd.EtdContractCode;
import com.opengamma.strata.product.etd.EtdIdUtils;
import com.opengamma.strata.product.etd.EtdType;
import com.opengamma.strata.product.etd.EtdVariant;
import com.opengamma.strata.product.etd.SplitEtdOption;
import java.time.YearMonth;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;

@BeanDefinition(style="minimal")
public final class SplitEtdId
implements ImmutableBean {
    @PropertyDefinition(validate="notNull")
    private final SecurityId securityId;
    @PropertyDefinition(validate="notNull")
    private final EtdType type;
    @PropertyDefinition(validate="notNull")
    private final ExchangeId exchangeId;
    @PropertyDefinition(validate="notNull")
    private final EtdContractCode contractCode;
    @PropertyDefinition(validate="notNull")
    private final YearMonth expiry;
    @PropertyDefinition(validate="notNull")
    private final EtdVariant variant;
    @PropertyDefinition(get="optional")
    private final SplitEtdOption option;
    private static final TypedMetaBean<SplitEtdId> META_BEAN = MinimalMetaBean.of(SplitEtdId.class, (String[])new String[]{"securityId", "type", "exchangeId", "contractCode", "expiry", "variant", "option"}, () -> new Builder(), (Function[])new Function[]{b -> b.getSecurityId(), b -> b.getType(), b -> b.getExchangeId(), b -> b.getContractCode(), b -> b.getExpiry(), b -> b.getVariant(), b -> b.option});

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        builder.type = builder.option != null ? EtdType.OPTION : EtdType.FUTURE;
    }

    public static SplitEtdId from(SecurityId securityId) {
        return EtdIdUtils.splitId(securityId);
    }

    public static TypedMetaBean<SplitEtdId> meta() {
        return META_BEAN;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SplitEtdId(SecurityId securityId, EtdType type, ExchangeId exchangeId, EtdContractCode contractCode, YearMonth expiry, EtdVariant variant, SplitEtdOption option) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
        JodaBeanUtils.notNull((Object)exchangeId, (String)"exchangeId");
        JodaBeanUtils.notNull((Object)((Object)contractCode), (String)"contractCode");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)variant, (String)"variant");
        this.securityId = securityId;
        this.type = type;
        this.exchangeId = exchangeId;
        this.contractCode = contractCode;
        this.expiry = expiry;
        this.variant = variant;
        this.option = option;
    }

    public TypedMetaBean<SplitEtdId> metaBean() {
        return META_BEAN;
    }

    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public EtdType getType() {
        return this.type;
    }

    public ExchangeId getExchangeId() {
        return this.exchangeId;
    }

    public EtdContractCode getContractCode() {
        return this.contractCode;
    }

    public YearMonth getExpiry() {
        return this.expiry;
    }

    public EtdVariant getVariant() {
        return this.variant;
    }

    public Optional<SplitEtdOption> getOption() {
        return Optional.ofNullable(this.option);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SplitEtdId other = (SplitEtdId)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)((Object)this.type), (Object)((Object)other.type)) && JodaBeanUtils.equal((Object)this.exchangeId, (Object)other.exchangeId) && JodaBeanUtils.equal((Object)((Object)this.contractCode), (Object)((Object)other.contractCode)) && JodaBeanUtils.equal((Object)this.expiry, (Object)other.expiry) && JodaBeanUtils.equal((Object)this.variant, (Object)other.variant) && JodaBeanUtils.equal((Object)this.option, (Object)other.option);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.type));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.exchangeId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.contractCode));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.variant);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.option);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("SplitEtdId{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
        buf.append("exchangeId").append('=').append(JodaBeanUtils.toString((Object)this.exchangeId)).append(',').append(' ');
        buf.append("contractCode").append('=').append(JodaBeanUtils.toString((Object)((Object)this.contractCode))).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("variant").append('=').append(JodaBeanUtils.toString((Object)this.variant)).append(',').append(' ');
        buf.append("option").append('=').append(JodaBeanUtils.toString((Object)this.option));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SplitEtdId> {
        private SecurityId securityId;
        private EtdType type;
        private ExchangeId exchangeId;
        private EtdContractCode contractCode;
        private YearMonth expiry;
        private EtdVariant variant;
        private SplitEtdOption option;

        private Builder() {
        }

        private Builder(SplitEtdId beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.type = beanToCopy.getType();
            this.exchangeId = beanToCopy.getExchangeId();
            this.contractCode = beanToCopy.getContractCode();
            this.expiry = beanToCopy.getExpiry();
            this.variant = beanToCopy.getVariant();
            this.option = beanToCopy.option;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 3575610: {
                    return this.type;
                }
                case 913218206: {
                    return this.exchangeId;
                }
                case -1402840545: {
                    return this.contractCode;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 236785797: {
                    return this.variant;
                }
                case -1010136971: {
                    return this.option;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case 3575610: {
                    this.type = (EtdType)((Object)newValue);
                    break;
                }
                case 913218206: {
                    this.exchangeId = (ExchangeId)newValue;
                    break;
                }
                case -1402840545: {
                    this.contractCode = (EtdContractCode)((Object)newValue);
                    break;
                }
                case -1289159373: {
                    this.expiry = (YearMonth)newValue;
                    break;
                }
                case 236785797: {
                    this.variant = (EtdVariant)newValue;
                    break;
                }
                case -1010136971: {
                    this.option = (SplitEtdOption)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SplitEtdId build() {
            SplitEtdId.preBuild(this);
            return new SplitEtdId(this.securityId, this.type, this.exchangeId, this.contractCode, this.expiry, this.variant, this.option);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder type(EtdType type) {
            JodaBeanUtils.notNull((Object)((Object)type), (String)"type");
            this.type = type;
            return this;
        }

        public Builder exchangeId(ExchangeId exchangeId) {
            JodaBeanUtils.notNull((Object)exchangeId, (String)"exchangeId");
            this.exchangeId = exchangeId;
            return this;
        }

        public Builder contractCode(EtdContractCode contractCode) {
            JodaBeanUtils.notNull((Object)((Object)contractCode), (String)"contractCode");
            this.contractCode = contractCode;
            return this;
        }

        public Builder expiry(YearMonth expiry) {
            JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
            this.expiry = expiry;
            return this;
        }

        public Builder variant(EtdVariant variant) {
            JodaBeanUtils.notNull((Object)variant, (String)"variant");
            this.variant = variant;
            return this;
        }

        public Builder option(SplitEtdOption option) {
            this.option = option;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("SplitEtdId.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("type").append('=').append(JodaBeanUtils.toString((Object)((Object)this.type))).append(',').append(' ');
            buf.append("exchangeId").append('=').append(JodaBeanUtils.toString((Object)this.exchangeId)).append(',').append(' ');
            buf.append("contractCode").append('=').append(JodaBeanUtils.toString((Object)((Object)this.contractCode))).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("variant").append('=').append(JodaBeanUtils.toString((Object)this.variant)).append(',').append(' ');
            buf.append("option").append('=').append(JodaBeanUtils.toString((Object)this.option));
            buf.append('}');
            return buf.toString();
        }
    }
}

