/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.etd;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.common.PutCall;
import java.lang.invoke.MethodHandles;
import java.time.YearMonth;
import java.util.Optional;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
public final class SplitEtdOption
implements ImmutableBean {
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final int version;
    @PropertyDefinition(validate="notNull")
    private final PutCall putCall;
    @PropertyDefinition
    private final double strikePrice;
    @PropertyDefinition(get="optional")
    private final YearMonth underlyingExpiryMonth;
    private static final TypedMetaBean<SplitEtdOption> META_BEAN = LightMetaBean.of(SplitEtdOption.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"version", "putCall", "strikePrice", "underlyingExpiryMonth"}, (Object[])new Object[0]);

    public static SplitEtdOption of(int version, PutCall putCall, double strikePrice) {
        return new SplitEtdOption(version, putCall, strikePrice, null);
    }

    public static SplitEtdOption of(int version, PutCall putCall, double strikePrice, YearMonth underlyingExpiryMonth) {
        return new SplitEtdOption(version, putCall, strikePrice, underlyingExpiryMonth);
    }

    public static TypedMetaBean<SplitEtdOption> meta() {
        return META_BEAN;
    }

    private SplitEtdOption(int version, PutCall putCall, double strikePrice, YearMonth underlyingExpiryMonth) {
        ArgChecker.notNegative((int)version, (String)"version");
        JodaBeanUtils.notNull((Object)((Object)putCall), (String)"putCall");
        this.version = version;
        this.putCall = putCall;
        this.strikePrice = strikePrice;
        this.underlyingExpiryMonth = underlyingExpiryMonth;
    }

    public TypedMetaBean<SplitEtdOption> metaBean() {
        return META_BEAN;
    }

    public int getVersion() {
        return this.version;
    }

    public PutCall getPutCall() {
        return this.putCall;
    }

    public double getStrikePrice() {
        return this.strikePrice;
    }

    public Optional<YearMonth> getUnderlyingExpiryMonth() {
        return Optional.ofNullable(this.underlyingExpiryMonth);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SplitEtdOption other = (SplitEtdOption)obj;
            return this.version == other.version && JodaBeanUtils.equal((Object)((Object)this.putCall), (Object)((Object)other.putCall)) && JodaBeanUtils.equal((double)this.strikePrice, (double)other.strikePrice) && JodaBeanUtils.equal((Object)this.underlyingExpiryMonth, (Object)other.underlyingExpiryMonth);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((int)this.version);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.putCall));
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strikePrice);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingExpiryMonth);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("SplitEtdOption{");
        buf.append("version").append('=').append(JodaBeanUtils.toString((Object)this.version)).append(',').append(' ');
        buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
        buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
        buf.append("underlyingExpiryMonth").append('=').append(JodaBeanUtils.toString((Object)this.underlyingExpiryMonth));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

