/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fra;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.fra.FraDiscountingMethod;
import com.opengamma.strata.product.fra.ResolvedFra;
import com.opengamma.strata.product.rate.IborInterpolatedRateComputation;
import com.opengamma.strata.product.rate.IborRateComputation;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class Fra
implements Product,
Resolvable<ResolvedFra>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final BuySell buySell;
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(get="optional")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(validate="notNull")
    private final AdjustableDate paymentDate;
    @PropertyDefinition
    private final double fixedRate;
    @PropertyDefinition(validate="notNull")
    private final IborIndex index;
    @PropertyDefinition(get="optional")
    private final IborIndex indexInterpolated;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment fixingDateOffset;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final FraDiscountingMethod discounting;
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null) {
            if (builder.dayCount == null) {
                builder.dayCount = builder.index.getDayCount();
            }
            if (builder.fixingDateOffset == null) {
                builder.fixingDateOffset = builder.index.getFixingDateOffset();
            }
            if (builder.currency == null) {
                builder.currency = builder.index.getCurrency();
            }
            if (builder.discounting == null) {
                Currency curr = builder.index.getCurrency();
                builder.discounting = curr.equals((Object)Currency.AUD) || curr.equals((Object)Currency.NZD) ? FraDiscountingMethod.AFMA : FraDiscountingMethod.ISDA;
            }
        }
        if (builder.paymentDate == null && builder.startDate != null) {
            builder.paymentDate = AdjustableDate.of((LocalDate)builder.startDate);
        }
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
        if (this.index.equals(this.indexInterpolated)) {
            throw new IllegalArgumentException("Interpolation requires two different indices");
        }
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        return ImmutableSet.of((Object)this.currency);
    }

    public ResolvedFra resolve(ReferenceData refData) {
        DateAdjuster bda = this.getBusinessDayAdjustment().orElse(BusinessDayAdjustment.NONE).resolve(refData);
        LocalDate start = bda.adjust(this.startDate);
        LocalDate end = bda.adjust(this.endDate);
        LocalDate pay = this.paymentDate.adjusted(refData);
        return ResolvedFra.builder().paymentDate(pay).startDate(start).endDate(end).yearFraction(this.dayCount.yearFraction(start, end)).fixedRate(this.fixedRate).floatingRate(this.createRateComputation(refData)).currency(this.currency).notional(this.buySell.normalize(this.notional)).discounting(this.discounting).build();
    }

    private RateComputation createRateComputation(ReferenceData refData) {
        LocalDate fixingDate = this.fixingDateOffset.adjust(this.startDate, refData);
        if (this.indexInterpolated != null) {
            return IborInterpolatedRateComputation.of(this.index, this.indexInterpolated, fixingDate, refData);
        }
        return IborRateComputation.of(this.index, fixingDate, refData);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Fra(BuySell buySell, Currency currency, double notional, LocalDate startDate, LocalDate endDate, BusinessDayAdjustment businessDayAdjustment, AdjustableDate paymentDate, double fixedRate, IborIndex index, IborIndex indexInterpolated, DaysAdjustment fixingDateOffset, DayCount dayCount, FraDiscountingMethod discounting) {
        JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegative((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)((Object)discounting), (String)"discounting");
        this.buySell = buySell;
        this.currency = currency;
        this.notional = notional;
        this.startDate = startDate;
        this.endDate = endDate;
        this.businessDayAdjustment = businessDayAdjustment;
        this.paymentDate = paymentDate;
        this.fixedRate = fixedRate;
        this.index = index;
        this.indexInterpolated = indexInterpolated;
        this.fixingDateOffset = fixingDateOffset;
        this.dayCount = dayCount;
        this.discounting = discounting;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public BuySell getBuySell() {
        return this.buySell;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public Optional<BusinessDayAdjustment> getBusinessDayAdjustment() {
        return Optional.ofNullable(this.businessDayAdjustment);
    }

    public AdjustableDate getPaymentDate() {
        return this.paymentDate;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public IborIndex getIndex() {
        return this.index;
    }

    public Optional<IborIndex> getIndexInterpolated() {
        return Optional.ofNullable(this.indexInterpolated);
    }

    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public FraDiscountingMethod getDiscounting() {
        return this.discounting;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Fra other = (Fra)obj;
            return JodaBeanUtils.equal((Object)((Object)this.buySell), (Object)((Object)other.buySell)) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.indexInterpolated, (Object)other.indexInterpolated) && JodaBeanUtils.equal((Object)this.fixingDateOffset, (Object)other.fixingDateOffset) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)((Object)this.discounting), (Object)((Object)other.discounting));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.buySell));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.indexInterpolated);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.discounting));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(448);
        buf.append("Fra{");
        buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("indexInterpolated").append('=').append(JodaBeanUtils.toString((Object)this.indexInterpolated)).append(',').append(' ');
        buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("discounting").append('=').append(JodaBeanUtils.toString((Object)((Object)this.discounting)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<Fra> {
        private BuySell buySell;
        private Currency currency;
        private double notional;
        private LocalDate startDate;
        private LocalDate endDate;
        private BusinessDayAdjustment businessDayAdjustment;
        private AdjustableDate paymentDate;
        private double fixedRate;
        private IborIndex index;
        private IborIndex indexInterpolated;
        private DaysAdjustment fixingDateOffset;
        private DayCount dayCount;
        private FraDiscountingMethod discounting;

        private Builder() {
        }

        private Builder(Fra beanToCopy) {
            this.buySell = beanToCopy.getBuySell();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.businessDayAdjustment = beanToCopy.businessDayAdjustment;
            this.paymentDate = beanToCopy.getPaymentDate();
            this.fixedRate = beanToCopy.getFixedRate();
            this.index = beanToCopy.getIndex();
            this.indexInterpolated = beanToCopy.indexInterpolated;
            this.fixingDateOffset = beanToCopy.getFixingDateOffset();
            this.dayCount = beanToCopy.getDayCount();
            this.discounting = beanToCopy.getDiscounting();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 100346066: {
                    return this.index;
                }
                case -1934091915: {
                    return this.indexInterpolated;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -536441087: {
                    return this.discounting;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    this.buySell = (BuySell)((Object)newValue);
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -1540873516: {
                    this.paymentDate = (AdjustableDate)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -1934091915: {
                    this.indexInterpolated = (IborIndex)newValue;
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -536441087: {
                    this.discounting = (FraDiscountingMethod)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public Fra build() {
            Fra.preBuild(this);
            return new Fra(this.buySell, this.currency, this.notional, this.startDate, this.endDate, this.businessDayAdjustment, this.paymentDate, this.fixedRate, this.index, this.indexInterpolated, this.fixingDateOffset, this.dayCount, this.discounting);
        }

        public Builder buySell(BuySell buySell) {
            JodaBeanUtils.notNull((Object)((Object)buySell), (String)"buySell");
            this.buySell = buySell;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegative((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder paymentDate(AdjustableDate paymentDate) {
            JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
            this.paymentDate = paymentDate;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder indexInterpolated(IborIndex indexInterpolated) {
            this.indexInterpolated = indexInterpolated;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            JodaBeanUtils.notNull((Object)fixingDateOffset, (String)"fixingDateOffset");
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder discounting(FraDiscountingMethod discounting) {
            JodaBeanUtils.notNull((Object)((Object)discounting), (String)"discounting");
            this.discounting = discounting;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(448);
            buf.append("Fra.Builder{");
            buf.append("buySell").append('=').append(JodaBeanUtils.toString((Object)((Object)this.buySell))).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("indexInterpolated").append('=').append(JodaBeanUtils.toString((Object)this.indexInterpolated)).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("discounting").append('=').append(JodaBeanUtils.toString((Object)((Object)this.discounting)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BuySell> buySell = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"buySell", Fra.class, BuySell.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", Fra.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", Fra.class, Double.TYPE);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", Fra.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", Fra.class, LocalDate.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", Fra.class, BusinessDayAdjustment.class);
        private final MetaProperty<AdjustableDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", Fra.class, AdjustableDate.class);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", Fra.class, Double.TYPE);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", Fra.class, IborIndex.class);
        private final MetaProperty<IborIndex> indexInterpolated = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"indexInterpolated", Fra.class, IborIndex.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", Fra.class, DaysAdjustment.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", Fra.class, DayCount.class);
        private final MetaProperty<FraDiscountingMethod> discounting = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discounting", Fra.class, FraDiscountingMethod.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"buySell", "currency", "notional", "startDate", "endDate", "businessDayAdjustment", "paymentDate", "fixedRate", "index", "indexInterpolated", "fixingDateOffset", "dayCount", "discounting"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return this.buySell;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case 100346066: {
                    return this.index;
                }
                case -1934091915: {
                    return this.indexInterpolated;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -536441087: {
                    return this.discounting;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends Fra> beanType() {
            return Fra.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BuySell> buySell() {
            return this.buySell;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<AdjustableDate> paymentDate() {
            return this.paymentDate;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<IborIndex> indexInterpolated() {
            return this.indexInterpolated;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<FraDiscountingMethod> discounting() {
            return this.discounting;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 244977400: {
                    return ((Fra)bean).getBuySell();
                }
                case 575402001: {
                    return ((Fra)bean).getCurrency();
                }
                case 1585636160: {
                    return ((Fra)bean).getNotional();
                }
                case -2129778896: {
                    return ((Fra)bean).getStartDate();
                }
                case -1607727319: {
                    return ((Fra)bean).getEndDate();
                }
                case -1065319863: {
                    return ((Fra)bean).businessDayAdjustment;
                }
                case -1540873516: {
                    return ((Fra)bean).getPaymentDate();
                }
                case 747425396: {
                    return ((Fra)bean).getFixedRate();
                }
                case 100346066: {
                    return ((Fra)bean).getIndex();
                }
                case -1934091915: {
                    return ((Fra)bean).indexInterpolated;
                }
                case 873743726: {
                    return ((Fra)bean).getFixingDateOffset();
                }
                case 1905311443: {
                    return ((Fra)bean).getDayCount();
                }
                case -536441087: {
                    return ((Fra)bean).getDiscounting();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

