/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fra;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.fra.FraDiscountingMethod;
import com.opengamma.strata.product.rate.RateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedFra
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate paymentDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double yearFraction;
    @PropertyDefinition
    private final double fixedRate;
    @PropertyDefinition(validate="notNull")
    private final RateComputation floatingRate;
    @PropertyDefinition(validate="notNull")
    private final FraDiscountingMethod discounting;
    private final transient ImmutableSet<IborIndex> indices;
    private static final long serialVersionUID = 1L;

    @ImmutableConstructor
    private ResolvedFra(Currency currency, double notional, LocalDate paymentDate, LocalDate startDate, LocalDate endDate, double yearFraction, double fixedRate, RateComputation floatingRate, FraDiscountingMethod discounting) {
        this.currency = (Currency)ArgChecker.notNull((Object)currency, (String)"currency");
        this.notional = notional;
        this.paymentDate = (LocalDate)ArgChecker.notNull((Object)paymentDate, (String)"paymentDate");
        ArgChecker.inOrderNotEqual((Comparable)startDate, (Object)endDate, (String)"startDate", (String)"endDate");
        this.startDate = startDate;
        this.endDate = endDate;
        this.yearFraction = ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
        this.fixedRate = fixedRate;
        this.floatingRate = (RateComputation)ArgChecker.notNull((Object)floatingRate, (String)"floatingRate");
        this.discounting = (FraDiscountingMethod)((Object)ArgChecker.notNull((Object)((Object)discounting), (String)"discounting"));
        this.indices = ResolvedFra.buildIndices(floatingRate);
    }

    private static ImmutableSet<IborIndex> buildIndices(RateComputation floatingRate) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        floatingRate.collectIndices((ImmutableSet.Builder<Index>)builder);
        return (ImmutableSet)builder.build().stream().map(Guavate.casting(IborIndex.class)).collect(Guavate.toImmutableSet());
    }

    private Object readResolve() {
        return new ResolvedFra(this.currency, this.notional, this.paymentDate, this.startDate, this.endDate, this.yearFraction, this.fixedRate, this.floatingRate, this.discounting);
    }

    public Set<IborIndex> allIndices() {
        return this.indices;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public double getFixedRate() {
        return this.fixedRate;
    }

    public RateComputation getFloatingRate() {
        return this.floatingRate;
    }

    public FraDiscountingMethod getDiscounting() {
        return this.discounting;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedFra other = (ResolvedFra)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((double)this.fixedRate, (double)other.fixedRate) && JodaBeanUtils.equal((Object)this.floatingRate, (Object)other.floatingRate) && JodaBeanUtils.equal((Object)((Object)this.discounting), (Object)((Object)other.discounting));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.fixedRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.floatingRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.discounting));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(320);
        buf.append("ResolvedFra{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
        buf.append("floatingRate").append('=').append(JodaBeanUtils.toString((Object)this.floatingRate)).append(',').append(' ');
        buf.append("discounting").append('=').append(JodaBeanUtils.toString((Object)((Object)this.discounting)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedFra> {
        private Currency currency;
        private double notional;
        private LocalDate paymentDate;
        private LocalDate startDate;
        private LocalDate endDate;
        private double yearFraction;
        private double fixedRate;
        private RateComputation floatingRate;
        private FraDiscountingMethod discounting;

        private Builder() {
        }

        private Builder(ResolvedFra beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.paymentDate = beanToCopy.getPaymentDate();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.yearFraction = beanToCopy.getYearFraction();
            this.fixedRate = beanToCopy.getFixedRate();
            this.floatingRate = beanToCopy.getFloatingRate();
            this.discounting = beanToCopy.getDiscounting();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case -2130225658: {
                    return this.floatingRate;
                }
                case -536441087: {
                    return this.discounting;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1540873516: {
                    this.paymentDate = (LocalDate)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case 747425396: {
                    this.fixedRate = (Double)newValue;
                    break;
                }
                case -2130225658: {
                    this.floatingRate = (RateComputation)newValue;
                    break;
                }
                case -536441087: {
                    this.discounting = (FraDiscountingMethod)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedFra build() {
            return new ResolvedFra(this.currency, this.notional, this.paymentDate, this.startDate, this.endDate, this.yearFraction, this.fixedRate, this.floatingRate, this.discounting);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            this.notional = notional;
            return this;
        }

        public Builder paymentDate(LocalDate paymentDate) {
            JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
            this.paymentDate = paymentDate;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder yearFraction(double yearFraction) {
            ArgChecker.notNegative((double)yearFraction, (String)"yearFraction");
            this.yearFraction = yearFraction;
            return this;
        }

        public Builder fixedRate(double fixedRate) {
            this.fixedRate = fixedRate;
            return this;
        }

        public Builder floatingRate(RateComputation floatingRate) {
            JodaBeanUtils.notNull((Object)floatingRate, (String)"floatingRate");
            this.floatingRate = floatingRate;
            return this;
        }

        public Builder discounting(FraDiscountingMethod discounting) {
            JodaBeanUtils.notNull((Object)((Object)discounting), (String)"discounting");
            this.discounting = discounting;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(320);
            buf.append("ResolvedFra.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("fixedRate").append('=').append(JodaBeanUtils.toString((Object)this.fixedRate)).append(',').append(' ');
            buf.append("floatingRate").append('=').append(JodaBeanUtils.toString((Object)this.floatingRate)).append(',').append(' ');
            buf.append("discounting").append('=').append(JodaBeanUtils.toString((Object)((Object)this.discounting)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", ResolvedFra.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", ResolvedFra.class, Double.TYPE);
        private final MetaProperty<LocalDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", ResolvedFra.class, LocalDate.class);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", ResolvedFra.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", ResolvedFra.class, LocalDate.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", ResolvedFra.class, Double.TYPE);
        private final MetaProperty<Double> fixedRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedRate", ResolvedFra.class, Double.TYPE);
        private final MetaProperty<RateComputation> floatingRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"floatingRate", ResolvedFra.class, RateComputation.class);
        private final MetaProperty<FraDiscountingMethod> discounting = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"discounting", ResolvedFra.class, FraDiscountingMethod.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "notional", "paymentDate", "startDate", "endDate", "yearFraction", "fixedRate", "floatingRate", "discounting"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 747425396: {
                    return this.fixedRate;
                }
                case -2130225658: {
                    return this.floatingRate;
                }
                case -536441087: {
                    return this.discounting;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedFra> beanType() {
            return ResolvedFra.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> paymentDate() {
            return this.paymentDate;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<Double> fixedRate() {
            return this.fixedRate;
        }

        public MetaProperty<RateComputation> floatingRate() {
            return this.floatingRate;
        }

        public MetaProperty<FraDiscountingMethod> discounting() {
            return this.discounting;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((ResolvedFra)bean).getCurrency();
                }
                case 1585636160: {
                    return ((ResolvedFra)bean).getNotional();
                }
                case -1540873516: {
                    return ((ResolvedFra)bean).getPaymentDate();
                }
                case -2129778896: {
                    return ((ResolvedFra)bean).getStartDate();
                }
                case -1607727319: {
                    return ((ResolvedFra)bean).getEndDate();
                }
                case -1731780257: {
                    return ((ResolvedFra)bean).getYearFraction();
                }
                case 747425396: {
                    return ((ResolvedFra)bean).getFixedRate();
                }
                case -2130225658: {
                    return ((ResolvedFra)bean).getFloatingRate();
                }
                case -536441087: {
                    return ((ResolvedFra)bean).getDiscounting();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

