/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fra.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.TradeConvention;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.fra.FraTrade;
import com.opengamma.strata.product.fra.type.FraConventions;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface FraConvention
extends TradeConvention,
Named {
    @FromString
    public static FraConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (FraConvention)FraConvention.extendedEnum().lookup(uniqueName);
    }

    public static FraConvention of(IborIndex index) {
        ArgChecker.notNull((Object)index, (String)"index");
        return (FraConvention)FraConvention.extendedEnum().lookup(index.getName());
    }

    public static ExtendedEnum<FraConvention> extendedEnum() {
        return FraConventions.ENUM_LOOKUP;
    }

    public IborIndex getIndex();

    public DaysAdjustment getSpotDateOffset();

    default public FraTrade createTrade(LocalDate tradeDate, Period periodToStart, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        Period periodToEnd = periodToStart.plus((TemporalAmount)this.getIndex().getTenor());
        return this.createTrade(tradeDate, periodToStart, periodToEnd, buySell, notional, fixedRate, refData);
    }

    public FraTrade createTrade(LocalDate var1, Period var2, Period var3, BuySell var4, double var5, double var7, ReferenceData var9);

    default public FraTrade toTrade(LocalDate tradeDate, LocalDate startDate, LocalDate endDate, LocalDate paymentDate, BuySell buySell, double notional, double fixedRate) {
        TradeInfo tradeInfo = TradeInfo.of(tradeDate);
        return this.toTrade(tradeInfo, startDate, endDate, paymentDate, buySell, notional, fixedRate);
    }

    public FraTrade toTrade(TradeInfo var1, LocalDate var2, LocalDate var3, LocalDate var4, BuySell var5, double var6, double var8);

    default public LocalDate calculateSpotDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.getSpotDateOffset().adjust(tradeDate, refData);
    }

    @ToString
    public String getName();
}

