/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fra.type;

import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.named.NamedLookup;
import com.opengamma.strata.product.fra.type.FraConvention;
import com.opengamma.strata.product.fra.type.ImmutableFraConvention;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

final class FraConventionLookup
implements NamedLookup<FraConvention> {
    public static final FraConventionLookup INSTANCE = new FraConventionLookup();
    private static final ConcurrentMap<String, FraConvention> BY_NAME = new ConcurrentHashMap<String, FraConvention>();

    private FraConventionLookup() {
    }

    public FraConvention lookup(String name) {
        FraConvention created;
        FraConvention value = (FraConvention)BY_NAME.get(name);
        if (value == null && (created = FraConventionLookup.createByName(name)) != null) {
            String correctName = created.getName();
            value = BY_NAME.computeIfAbsent(correctName, k -> created);
            BY_NAME.putIfAbsent(correctName.toUpperCase(Locale.ENGLISH), value);
        }
        return value;
    }

    public Map<String, FraConvention> lookupAll() {
        return BY_NAME;
    }

    private static FraConvention createByName(String name) {
        return IborIndex.extendedEnum().find(name).map(index -> ImmutableFraConvention.of(index)).orElse(null);
    }
}

