/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fra.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeTemplate;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.fra.FraTrade;
import com.opengamma.strata.product.fra.type.FraConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FraTemplate
implements TradeTemplate,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Period periodToStart;
    @PropertyDefinition(validate="notNull")
    private final Period periodToEnd;
    @PropertyDefinition(validate="notNull")
    private final FraConvention convention;
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.periodToEnd == null && builder.convention != null && builder.periodToStart != null) {
            builder.periodToEnd = builder.periodToStart.plus(builder.convention.getIndex().getTenor().getPeriod());
        }
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isFalse((boolean)this.periodToStart.isNegative(), (String)"Period to start must not be negative");
        ArgChecker.isFalse((boolean)this.periodToEnd.isNegative(), (String)"Period to end must not be negative");
    }

    public static FraTemplate of(Period periodToStart, IborIndex index) {
        return FraTemplate.of(periodToStart, periodToStart.plus(index.getTenor().getPeriod()), FraConvention.of(index));
    }

    public static FraTemplate of(Period periodToStart, Period periodToEnd, FraConvention convention) {
        ArgChecker.notNull((Object)periodToStart, (String)"periodToStart");
        ArgChecker.notNull((Object)periodToEnd, (String)"periodToEnd");
        ArgChecker.notNull((Object)convention, (String)"convention");
        return FraTemplate.builder().periodToStart(periodToStart).periodToEnd(periodToEnd).convention(convention).build();
    }

    public FraTrade createTrade(LocalDate tradeDate, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        return this.convention.createTrade(tradeDate, this.periodToStart, this.periodToEnd, buySell, notional, fixedRate, refData);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FraTemplate(Period periodToStart, Period periodToEnd, FraConvention convention) {
        JodaBeanUtils.notNull((Object)periodToStart, (String)"periodToStart");
        JodaBeanUtils.notNull((Object)periodToEnd, (String)"periodToEnd");
        JodaBeanUtils.notNull((Object)convention, (String)"convention");
        this.periodToStart = periodToStart;
        this.periodToEnd = periodToEnd;
        this.convention = convention;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Period getPeriodToStart() {
        return this.periodToStart;
    }

    public Period getPeriodToEnd() {
        return this.periodToEnd;
    }

    public FraConvention getConvention() {
        return this.convention;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FraTemplate other = (FraTemplate)obj;
            return JodaBeanUtils.equal((Object)this.periodToStart, (Object)other.periodToStart) && JodaBeanUtils.equal((Object)this.periodToEnd, (Object)other.periodToEnd) && JodaBeanUtils.equal((Object)this.convention, (Object)other.convention);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.periodToStart);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.periodToEnd);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("FraTemplate{");
        buf.append("periodToStart").append('=').append(JodaBeanUtils.toString((Object)this.periodToStart)).append(',').append(' ');
        buf.append("periodToEnd").append('=').append(JodaBeanUtils.toString((Object)this.periodToEnd)).append(',').append(' ');
        buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FraTemplate> {
        private Period periodToStart;
        private Period periodToEnd;
        private FraConvention convention;

        private Builder() {
        }

        private Builder(FraTemplate beanToCopy) {
            this.periodToStart = beanToCopy.getPeriodToStart();
            this.periodToEnd = beanToCopy.getPeriodToEnd();
            this.convention = beanToCopy.getConvention();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -574688858: {
                    return this.periodToStart;
                }
                case -970442977: {
                    return this.periodToEnd;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -574688858: {
                    this.periodToStart = (Period)newValue;
                    break;
                }
                case -970442977: {
                    this.periodToEnd = (Period)newValue;
                    break;
                }
                case 2039569265: {
                    this.convention = (FraConvention)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FraTemplate build() {
            FraTemplate.preBuild(this);
            return new FraTemplate(this.periodToStart, this.periodToEnd, this.convention);
        }

        public Builder periodToStart(Period periodToStart) {
            JodaBeanUtils.notNull((Object)periodToStart, (String)"periodToStart");
            this.periodToStart = periodToStart;
            return this;
        }

        public Builder periodToEnd(Period periodToEnd) {
            JodaBeanUtils.notNull((Object)periodToEnd, (String)"periodToEnd");
            this.periodToEnd = periodToEnd;
            return this;
        }

        public Builder convention(FraConvention convention) {
            JodaBeanUtils.notNull((Object)convention, (String)"convention");
            this.convention = convention;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("FraTemplate.Builder{");
            buf.append("periodToStart").append('=').append(JodaBeanUtils.toString((Object)this.periodToStart)).append(',').append(' ');
            buf.append("periodToEnd").append('=').append(JodaBeanUtils.toString((Object)this.periodToEnd)).append(',').append(' ');
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Period> periodToStart = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periodToStart", FraTemplate.class, Period.class);
        private final MetaProperty<Period> periodToEnd = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periodToEnd", FraTemplate.class, Period.class);
        private final MetaProperty<FraConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", FraTemplate.class, FraConvention.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"periodToStart", "periodToEnd", "convention"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -574688858: {
                    return this.periodToStart;
                }
                case -970442977: {
                    return this.periodToEnd;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FraTemplate> beanType() {
            return FraTemplate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Period> periodToStart() {
            return this.periodToStart;
        }

        public MetaProperty<Period> periodToEnd() {
            return this.periodToEnd;
        }

        public MetaProperty<FraConvention> convention() {
            return this.convention;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -574688858: {
                    return ((FraTemplate)bean).getPeriodToStart();
                }
                case -970442977: {
                    return ((FraTemplate)bean).getPeriodToEnd();
                }
                case 2039569265: {
                    return ((FraTemplate)bean).getConvention();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

