/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx;

import com.google.common.collect.Ordering;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.fx.FxProduct;
import com.opengamma.strata.product.fx.FxSingleDeserializer;
import com.opengamma.strata.product.fx.ResolvedFxSingle;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjuster;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.joda.beans.ser.SerDeserializer;

@BeanDefinition(builderScope="private")
public final class FxSingle
implements FxProduct,
Resolvable<ResolvedFxSingle>,
ImmutableBean,
Serializable {
    public static final SerDeserializer DESERIALIZER = new FxSingleDeserializer();
    @PropertyDefinition(validate="notNull")
    private final Payment baseCurrencyPayment;
    @PropertyDefinition(validate="notNull")
    private final Payment counterCurrencyPayment;
    @PropertyDefinition(get="optional")
    private final BusinessDayAdjustment paymentDateAdjustment;
    private static final long serialVersionUID = 1L;

    public static FxSingle of(Payment payment1, Payment payment2) {
        return FxSingle.create(payment1, payment2, null);
    }

    public static FxSingle of(Payment payment1, Payment payment2, BusinessDayAdjustment paymentDateAdjustment) {
        ArgChecker.notNull((Object)paymentDateAdjustment, (String)"paymentDateAdjustment");
        return FxSingle.create(payment1, payment2, paymentDateAdjustment);
    }

    public static FxSingle of(CurrencyAmount amount1, CurrencyAmount amount2, LocalDate paymentDate) {
        return FxSingle.create(amount1, amount2, paymentDate, null);
    }

    public static FxSingle of(CurrencyAmount amount1, CurrencyAmount amount2, LocalDate paymentDate, BusinessDayAdjustment paymentDateAdjustment) {
        ArgChecker.notNull((Object)paymentDateAdjustment, (String)"paymentDateAdjustment");
        return FxSingle.create(amount1, amount2, paymentDate, paymentDateAdjustment);
    }

    public static FxSingle of(CurrencyAmount amount, FxRate fxRate, LocalDate paymentDate) {
        return FxSingle.create(amount, fxRate, paymentDate, null);
    }

    public static FxSingle of(CurrencyAmount amount, FxRate fxRate, LocalDate paymentDate, BusinessDayAdjustment paymentDateAdjustment) {
        ArgChecker.notNull((Object)paymentDateAdjustment, (String)"paymentDateAdjustment");
        return FxSingle.create(amount, fxRate, paymentDate, paymentDateAdjustment);
    }

    private static FxSingle create(CurrencyAmount amount, FxRate fxRate, LocalDate paymentDate, BusinessDayAdjustment paymentDateAdjustment) {
        ArgChecker.notNull((Object)amount, (String)"amount");
        ArgChecker.notNull((Object)fxRate, (String)"fxRate");
        ArgChecker.notNull((Object)paymentDate, (String)"paymentDate");
        CurrencyPair pair = fxRate.getPair();
        if (!pair.contains(amount.getCurrency())) {
            throw new IllegalArgumentException(Messages.format((String)"FxRate '{}' and CurrencyAmount '{}' must have a currency in common", (Object[])new Object[]{fxRate, amount}));
        }
        Currency currency2 = pair.getBase().equals((Object)amount.getCurrency()) ? pair.getCounter() : pair.getBase();
        CurrencyAmount amountCurrency2 = amount.convertedTo(currency2, (FxRateProvider)fxRate).negated();
        return FxSingle.create(amount, amountCurrency2, paymentDate, paymentDateAdjustment);
    }

    private static FxSingle create(CurrencyAmount amount1, CurrencyAmount amount2, LocalDate paymentDate, BusinessDayAdjustment paymentDateAdjustment) {
        ArgChecker.notNull((Object)amount1, (String)"amount1");
        ArgChecker.notNull((Object)amount2, (String)"amount2");
        ArgChecker.notNull((Object)paymentDate, (String)"paymentDate");
        return FxSingle.create(Payment.of((CurrencyAmount)amount1, (LocalDate)paymentDate), Payment.of((CurrencyAmount)amount2, (LocalDate)paymentDate), paymentDateAdjustment);
    }

    private static FxSingle create(Payment payment1, Payment payment2, BusinessDayAdjustment paymentDateAdjustment) {
        ArgChecker.notNull((Object)payment1, (String)"payment1");
        ArgChecker.notNull((Object)payment2, (String)"payment2");
        CurrencyPair pair = CurrencyPair.of((Currency)payment1.getCurrency(), (Currency)payment2.getCurrency());
        if (pair.isConventional()) {
            return new FxSingle(payment1, payment2, paymentDateAdjustment);
        }
        return new FxSingle(payment2, payment1, paymentDateAdjustment);
    }

    @ImmutableValidator
    private void validate() {
        if (this.baseCurrencyPayment.getCurrency().equals((Object)this.counterCurrencyPayment.getCurrency())) {
            throw new IllegalArgumentException("Amounts must have different currencies");
        }
        if (this.baseCurrencyPayment.getAmount() != 0.0 || this.counterCurrencyPayment.getAmount() != 0.0) {
            if (Math.signum(this.baseCurrencyPayment.getAmount()) != -Math.signum(this.counterCurrencyPayment.getAmount())) {
                throw new IllegalArgumentException("Amounts must have different signs");
            }
            double fxRateUnscaled = this.counterCurrencyPayment.getAmount() / this.baseCurrencyPayment.getAmount();
            int baseCurrencyMinorDigits = this.baseCurrencyPayment.getCurrency().getMinorUnitDigits();
            BigDecimal fxRate = BigDecimal.valueOf(fxRateUnscaled).setScale(baseCurrencyMinorDigits + 2, RoundingMode.HALF_UP).abs();
            if (fxRate.doubleValue() <= 0.0) {
                throw new IllegalArgumentException("Amounts must result in a positive exchange rate");
            }
        }
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        Payment base = builder.baseCurrencyPayment;
        Payment counter = builder.counterCurrencyPayment;
        CurrencyPair pair = CurrencyPair.of((Currency)counter.getCurrency(), (Currency)base.getCurrency());
        if (pair.isConventional()) {
            builder.baseCurrencyPayment = counter;
            builder.counterCurrencyPayment = base;
        }
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return CurrencyPair.of((Currency)this.baseCurrencyPayment.getCurrency(), (Currency)this.counterCurrencyPayment.getCurrency());
    }

    public CurrencyAmount getBaseCurrencyAmount() {
        return this.baseCurrencyPayment.getValue();
    }

    public CurrencyAmount getCounterCurrencyAmount() {
        return this.counterCurrencyPayment.getValue();
    }

    public CurrencyAmount getPayCurrencyAmount() {
        if (this.baseCurrencyPayment.getAmount() <= 0.0) {
            return this.baseCurrencyPayment.getValue();
        }
        return this.counterCurrencyPayment.getValue();
    }

    public CurrencyAmount getReceiveCurrencyAmount() {
        if (this.baseCurrencyPayment.getAmount() > 0.0) {
            return this.baseCurrencyPayment.getValue();
        }
        return this.counterCurrencyPayment.getValue();
    }

    public LocalDate getPaymentDate() {
        return (LocalDate)Ordering.natural().max((Object)this.baseCurrencyPayment.getDate(), (Object)this.counterCurrencyPayment.getDate());
    }

    public ResolvedFxSingle resolve(ReferenceData refData) {
        if (this.paymentDateAdjustment == null) {
            return ResolvedFxSingle.of(this.baseCurrencyPayment, this.counterCurrencyPayment);
        }
        DateAdjuster adjuster = this.paymentDateAdjustment.resolve(refData);
        return ResolvedFxSingle.of(this.baseCurrencyPayment.adjustDate((TemporalAdjuster)adjuster), this.counterCurrencyPayment.adjustDate((TemporalAdjuster)adjuster));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxSingle(Payment baseCurrencyPayment, Payment counterCurrencyPayment, BusinessDayAdjustment paymentDateAdjustment) {
        JodaBeanUtils.notNull((Object)baseCurrencyPayment, (String)"baseCurrencyPayment");
        JodaBeanUtils.notNull((Object)counterCurrencyPayment, (String)"counterCurrencyPayment");
        this.baseCurrencyPayment = baseCurrencyPayment;
        this.counterCurrencyPayment = counterCurrencyPayment;
        this.paymentDateAdjustment = paymentDateAdjustment;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Payment getBaseCurrencyPayment() {
        return this.baseCurrencyPayment;
    }

    public Payment getCounterCurrencyPayment() {
        return this.counterCurrencyPayment;
    }

    public Optional<BusinessDayAdjustment> getPaymentDateAdjustment() {
        return Optional.ofNullable(this.paymentDateAdjustment);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxSingle other = (FxSingle)obj;
            return JodaBeanUtils.equal((Object)this.baseCurrencyPayment, (Object)other.baseCurrencyPayment) && JodaBeanUtils.equal((Object)this.counterCurrencyPayment, (Object)other.counterCurrencyPayment) && JodaBeanUtils.equal((Object)this.paymentDateAdjustment, (Object)other.paymentDateAdjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.baseCurrencyPayment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.counterCurrencyPayment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDateAdjustment);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("FxSingle{");
        buf.append("baseCurrencyPayment").append('=').append(JodaBeanUtils.toString((Object)this.baseCurrencyPayment)).append(',').append(' ');
        buf.append("counterCurrencyPayment").append('=').append(JodaBeanUtils.toString((Object)this.counterCurrencyPayment)).append(',').append(' ');
        buf.append("paymentDateAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateAdjustment));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxSingle> {
        private Payment baseCurrencyPayment;
        private Payment counterCurrencyPayment;
        private BusinessDayAdjustment paymentDateAdjustment;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 765258148: {
                    return this.baseCurrencyPayment;
                }
                case -863240423: {
                    return this.counterCurrencyPayment;
                }
                case 737375073: {
                    return this.paymentDateAdjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 765258148: {
                    this.baseCurrencyPayment = (Payment)newValue;
                    break;
                }
                case -863240423: {
                    this.counterCurrencyPayment = (Payment)newValue;
                    break;
                }
                case 737375073: {
                    this.paymentDateAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxSingle build() {
            FxSingle.preBuild(this);
            return new FxSingle(this.baseCurrencyPayment, this.counterCurrencyPayment, this.paymentDateAdjustment);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("FxSingle.Builder{");
            buf.append("baseCurrencyPayment").append('=').append(JodaBeanUtils.toString((Object)this.baseCurrencyPayment)).append(',').append(' ');
            buf.append("counterCurrencyPayment").append('=').append(JodaBeanUtils.toString((Object)this.counterCurrencyPayment)).append(',').append(' ');
            buf.append("paymentDateAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateAdjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Payment> baseCurrencyPayment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"baseCurrencyPayment", FxSingle.class, Payment.class);
        private final MetaProperty<Payment> counterCurrencyPayment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"counterCurrencyPayment", FxSingle.class, Payment.class);
        private final MetaProperty<BusinessDayAdjustment> paymentDateAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDateAdjustment", FxSingle.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"baseCurrencyPayment", "counterCurrencyPayment", "paymentDateAdjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 765258148: {
                    return this.baseCurrencyPayment;
                }
                case -863240423: {
                    return this.counterCurrencyPayment;
                }
                case 737375073: {
                    return this.paymentDateAdjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxSingle> builder() {
            return new Builder();
        }

        public Class<? extends FxSingle> beanType() {
            return FxSingle.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Payment> baseCurrencyPayment() {
            return this.baseCurrencyPayment;
        }

        public MetaProperty<Payment> counterCurrencyPayment() {
            return this.counterCurrencyPayment;
        }

        public MetaProperty<BusinessDayAdjustment> paymentDateAdjustment() {
            return this.paymentDateAdjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 765258148: {
                    return ((FxSingle)bean).getBaseCurrencyPayment();
                }
                case -863240423: {
                    return ((FxSingle)bean).getCounterCurrencyPayment();
                }
                case 737375073: {
                    return ((FxSingle)bean).paymentDateAdjustment;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

