/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.fx.FxProduct;
import com.opengamma.strata.product.fx.FxSingle;
import com.opengamma.strata.product.fx.ResolvedFxSwap;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class FxSwap
implements FxProduct,
Resolvable<ResolvedFxSwap>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final FxSingle nearLeg;
    @PropertyDefinition(validate="notNull")
    private final FxSingle farLeg;
    private static final long serialVersionUID = 1L;

    public static FxSwap of(FxSingle nearLeg, FxSingle farLeg) {
        return new FxSwap(nearLeg, farLeg);
    }

    public static FxSwap of(CurrencyAmount amount, FxRate nearRate, LocalDate nearDate, FxRate farRate, LocalDate farDate) {
        Currency currency1 = amount.getCurrency();
        if (!nearRate.getPair().contains(currency1)) {
            throw new IllegalArgumentException(Messages.format((String)"FxRate '{}' and CurrencyAmount '{}' must have a currency in common", (Object[])new Object[]{nearRate, amount}));
        }
        if (!nearRate.getPair().toConventional().equals((Object)farRate.getPair().toConventional())) {
            throw new IllegalArgumentException(Messages.format((String)"FxRate '{}' and FxRate '{}' must contain the same currencies", (Object[])new Object[]{nearRate, farRate}));
        }
        FxSingle nearLeg = FxSingle.of(amount, nearRate, nearDate);
        FxSingle farLeg = FxSingle.of(amount.negated(), farRate, farDate);
        return FxSwap.of(nearLeg, farLeg);
    }

    public static FxSwap of(CurrencyAmount amount, FxRate nearRate, LocalDate nearDate, FxRate farRate, LocalDate farDate, BusinessDayAdjustment paymentDateAdjustment) {
        ArgChecker.notNull((Object)paymentDateAdjustment, (String)"paymentDateAdjustment");
        Currency currency1 = amount.getCurrency();
        if (!nearRate.getPair().contains(currency1)) {
            throw new IllegalArgumentException(Messages.format((String)"FxRate '{}' and CurrencyAmount '{}' must have a currency in common", (Object[])new Object[]{nearRate, amount}));
        }
        if (!nearRate.getPair().toConventional().equals((Object)farRate.getPair().toConventional())) {
            throw new IllegalArgumentException(Messages.format((String)"FxRate '{}' and FxRate '{}' must contain the same currencies", (Object[])new Object[]{nearRate, farRate}));
        }
        FxSingle nearLeg = FxSingle.of(amount, nearRate, nearDate, paymentDateAdjustment);
        FxSingle farLeg = FxSingle.of(amount.negated(), farRate, farDate, paymentDateAdjustment);
        return FxSwap.of(nearLeg, farLeg);
    }

    public static FxSwap ofForwardPoints(CurrencyAmount amount, FxRate nearRate, double decimalForwardPoints, LocalDate nearDate, LocalDate farDate) {
        FxRate farRate = FxRate.of((CurrencyPair)nearRate.getPair(), (double)(nearRate.fxRate(nearRate.getPair()) + decimalForwardPoints));
        return FxSwap.of(amount, nearRate, nearDate, farRate, farDate);
    }

    public static FxSwap ofForwardPoints(CurrencyAmount amount, FxRate nearRate, double decimalForwardPoints, LocalDate nearDate, LocalDate farDate, BusinessDayAdjustment paymentDateAdjustment) {
        FxRate farRate = FxRate.of((CurrencyPair)nearRate.getPair(), (double)(nearRate.fxRate(nearRate.getPair()) + decimalForwardPoints));
        return FxSwap.of(amount, nearRate, nearDate, farRate, farDate, paymentDateAdjustment);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.nearLeg.getPaymentDate(), (Object)this.farLeg.getPaymentDate(), (String)"nearLeg.paymentDate", (String)"farLeg.paymentDate");
        if (!this.nearLeg.getBaseCurrencyAmount().getCurrency().equals((Object)this.farLeg.getBaseCurrencyAmount().getCurrency()) || !this.nearLeg.getCounterCurrencyAmount().getCurrency().equals((Object)this.farLeg.getCounterCurrencyAmount().getCurrency())) {
            throw new IllegalArgumentException("Legs must have the same currency pair");
        }
        if (Math.signum(this.nearLeg.getBaseCurrencyAmount().getAmount()) == Math.signum(this.farLeg.getBaseCurrencyAmount().getAmount())) {
            throw new IllegalArgumentException("Legs must have payments flowing in opposite directions");
        }
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.getNearLeg().getCurrencyPair().toConventional();
    }

    public ResolvedFxSwap resolve(ReferenceData refData) {
        return ResolvedFxSwap.of(this.nearLeg.resolve(refData), this.farLeg.resolve(refData));
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private FxSwap(FxSingle nearLeg, FxSingle farLeg) {
        JodaBeanUtils.notNull((Object)nearLeg, (String)"nearLeg");
        JodaBeanUtils.notNull((Object)farLeg, (String)"farLeg");
        this.nearLeg = nearLeg;
        this.farLeg = farLeg;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public FxSingle getNearLeg() {
        return this.nearLeg;
    }

    public FxSingle getFarLeg() {
        return this.farLeg;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxSwap other = (FxSwap)obj;
            return JodaBeanUtils.equal((Object)this.nearLeg, (Object)other.nearLeg) && JodaBeanUtils.equal((Object)this.farLeg, (Object)other.farLeg);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.nearLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.farLeg);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("FxSwap{");
        buf.append("nearLeg").append('=').append(JodaBeanUtils.toString((Object)this.nearLeg)).append(',').append(' ');
        buf.append("farLeg").append('=').append(JodaBeanUtils.toString((Object)this.farLeg));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<FxSwap> {
        private FxSingle nearLeg;
        private FxSingle farLeg;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1825755334: {
                    return this.nearLeg;
                }
                case -1281739913: {
                    return this.farLeg;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1825755334: {
                    this.nearLeg = (FxSingle)newValue;
                    break;
                }
                case -1281739913: {
                    this.farLeg = (FxSingle)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public FxSwap build() {
            return new FxSwap(this.nearLeg, this.farLeg);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("FxSwap.Builder{");
            buf.append("nearLeg").append('=').append(JodaBeanUtils.toString((Object)this.nearLeg)).append(',').append(' ');
            buf.append("farLeg").append('=').append(JodaBeanUtils.toString((Object)this.farLeg));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxSingle> nearLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nearLeg", FxSwap.class, FxSingle.class);
        private final MetaProperty<FxSingle> farLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"farLeg", FxSwap.class, FxSingle.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"nearLeg", "farLeg"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1825755334: {
                    return this.nearLeg;
                }
                case -1281739913: {
                    return this.farLeg;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends FxSwap> builder() {
            return new Builder();
        }

        public Class<? extends FxSwap> beanType() {
            return FxSwap.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxSingle> nearLeg() {
            return this.nearLeg;
        }

        public MetaProperty<FxSingle> farLeg() {
            return this.farLeg;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1825755334: {
                    return ((FxSwap)bean).getNearLeg();
                }
                case -1281739913: {
                    return ((FxSwap)bean).getFarLeg();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

