/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.index.FxIndex;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.product.ResolvedProduct;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedFxNdf
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final CurrencyAmount settlementCurrencyNotional;
    @PropertyDefinition(validate="notNull")
    private final FxRate agreedFxRate;
    @PropertyDefinition(validate="notNull")
    private final FxIndexObservation observation;
    @PropertyDefinition(validate="notNull")
    private final LocalDate paymentDate;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        CurrencyPair pair = this.observation.getIndex().getCurrencyPair();
        if (!pair.contains(this.settlementCurrencyNotional.getCurrency())) {
            throw new IllegalArgumentException("FxIndex and settlement notional currency are incompatible");
        }
        if (!pair.equals((Object)this.agreedFxRate.getPair()) && !pair.isInverse(this.agreedFxRate.getPair())) {
            throw new IllegalArgumentException("FxIndex and agreed FX rate are incompatible");
        }
    }

    public FxIndex getIndex() {
        return this.observation.getIndex();
    }

    public Currency getSettlementCurrency() {
        return this.settlementCurrencyNotional.getCurrency();
    }

    public double getSettlementNotional() {
        return this.settlementCurrencyNotional.getAmount();
    }

    public Currency getNonDeliverableCurrency() {
        FxIndex index = this.getIndex();
        return index.getCurrencyPair().getBase().equals((Object)this.getSettlementCurrency()) ? index.getCurrencyPair().getCounter() : index.getCurrencyPair().getBase();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResolvedFxNdf(CurrencyAmount settlementCurrencyNotional, FxRate agreedFxRate, FxIndexObservation observation, LocalDate paymentDate) {
        JodaBeanUtils.notNull((Object)settlementCurrencyNotional, (String)"settlementCurrencyNotional");
        JodaBeanUtils.notNull((Object)agreedFxRate, (String)"agreedFxRate");
        JodaBeanUtils.notNull((Object)observation, (String)"observation");
        JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
        this.settlementCurrencyNotional = settlementCurrencyNotional;
        this.agreedFxRate = agreedFxRate;
        this.observation = observation;
        this.paymentDate = paymentDate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public CurrencyAmount getSettlementCurrencyNotional() {
        return this.settlementCurrencyNotional;
    }

    public FxRate getAgreedFxRate() {
        return this.agreedFxRate;
    }

    public FxIndexObservation getObservation() {
        return this.observation;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedFxNdf other = (ResolvedFxNdf)obj;
            return JodaBeanUtils.equal((Object)this.settlementCurrencyNotional, (Object)other.settlementCurrencyNotional) && JodaBeanUtils.equal((Object)this.agreedFxRate, (Object)other.agreedFxRate) && JodaBeanUtils.equal((Object)this.observation, (Object)other.observation) && JodaBeanUtils.equal((Object)this.paymentDate, (Object)other.paymentDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementCurrencyNotional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.agreedFxRate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.observation);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(160);
        buf.append("ResolvedFxNdf{");
        buf.append("settlementCurrencyNotional").append('=').append(JodaBeanUtils.toString((Object)this.settlementCurrencyNotional)).append(',').append(' ');
        buf.append("agreedFxRate").append('=').append(JodaBeanUtils.toString((Object)this.agreedFxRate)).append(',').append(' ');
        buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
        buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedFxNdf> {
        private CurrencyAmount settlementCurrencyNotional;
        private FxRate agreedFxRate;
        private FxIndexObservation observation;
        private LocalDate paymentDate;

        private Builder() {
        }

        private Builder(ResolvedFxNdf beanToCopy) {
            this.settlementCurrencyNotional = beanToCopy.getSettlementCurrencyNotional();
            this.agreedFxRate = beanToCopy.getAgreedFxRate();
            this.observation = beanToCopy.getObservation();
            this.paymentDate = beanToCopy.getPaymentDate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 594670010: {
                    return this.settlementCurrencyNotional;
                }
                case 1040357930: {
                    return this.agreedFxRate;
                }
                case 122345516: {
                    return this.observation;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 594670010: {
                    this.settlementCurrencyNotional = (CurrencyAmount)newValue;
                    break;
                }
                case 1040357930: {
                    this.agreedFxRate = (FxRate)newValue;
                    break;
                }
                case 122345516: {
                    this.observation = (FxIndexObservation)newValue;
                    break;
                }
                case -1540873516: {
                    this.paymentDate = (LocalDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedFxNdf build() {
            return new ResolvedFxNdf(this.settlementCurrencyNotional, this.agreedFxRate, this.observation, this.paymentDate);
        }

        public Builder settlementCurrencyNotional(CurrencyAmount settlementCurrencyNotional) {
            JodaBeanUtils.notNull((Object)settlementCurrencyNotional, (String)"settlementCurrencyNotional");
            this.settlementCurrencyNotional = settlementCurrencyNotional;
            return this;
        }

        public Builder agreedFxRate(FxRate agreedFxRate) {
            JodaBeanUtils.notNull((Object)agreedFxRate, (String)"agreedFxRate");
            this.agreedFxRate = agreedFxRate;
            return this;
        }

        public Builder observation(FxIndexObservation observation) {
            JodaBeanUtils.notNull((Object)observation, (String)"observation");
            this.observation = observation;
            return this;
        }

        public Builder paymentDate(LocalDate paymentDate) {
            JodaBeanUtils.notNull((Object)paymentDate, (String)"paymentDate");
            this.paymentDate = paymentDate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ResolvedFxNdf.Builder{");
            buf.append("settlementCurrencyNotional").append('=').append(JodaBeanUtils.toString((Object)this.settlementCurrencyNotional)).append(',').append(' ');
            buf.append("agreedFxRate").append('=').append(JodaBeanUtils.toString((Object)this.agreedFxRate)).append(',').append(' ');
            buf.append("observation").append('=').append(JodaBeanUtils.toString((Object)this.observation)).append(',').append(' ');
            buf.append("paymentDate").append('=').append(JodaBeanUtils.toString((Object)this.paymentDate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyAmount> settlementCurrencyNotional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementCurrencyNotional", ResolvedFxNdf.class, CurrencyAmount.class);
        private final MetaProperty<FxRate> agreedFxRate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"agreedFxRate", ResolvedFxNdf.class, FxRate.class);
        private final MetaProperty<FxIndexObservation> observation = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"observation", ResolvedFxNdf.class, FxIndexObservation.class);
        private final MetaProperty<LocalDate> paymentDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDate", ResolvedFxNdf.class, LocalDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"settlementCurrencyNotional", "agreedFxRate", "observation", "paymentDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 594670010: {
                    return this.settlementCurrencyNotional;
                }
                case 1040357930: {
                    return this.agreedFxRate;
                }
                case 122345516: {
                    return this.observation;
                }
                case -1540873516: {
                    return this.paymentDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedFxNdf> beanType() {
            return ResolvedFxNdf.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyAmount> settlementCurrencyNotional() {
            return this.settlementCurrencyNotional;
        }

        public MetaProperty<FxRate> agreedFxRate() {
            return this.agreedFxRate;
        }

        public MetaProperty<FxIndexObservation> observation() {
            return this.observation;
        }

        public MetaProperty<LocalDate> paymentDate() {
            return this.paymentDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 594670010: {
                    return ((ResolvedFxNdf)bean).getSettlementCurrencyNotional();
                }
                case 1040357930: {
                    return ((ResolvedFxNdf)bean).getAgreedFxRate();
                }
                case 122345516: {
                    return ((ResolvedFxNdf)bean).getObservation();
                }
                case -1540873516: {
                    return ((ResolvedFxNdf)bean).getPaymentDate();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

