/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ResolvedFxSingle
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Payment baseCurrencyPayment;
    @PropertyDefinition(validate="notNull")
    private final Payment counterCurrencyPayment;
    private static final long serialVersionUID = 1L;

    public static ResolvedFxSingle of(Payment payment1, Payment payment2) {
        CurrencyPair pair = CurrencyPair.of((Currency)payment2.getCurrency(), (Currency)payment1.getCurrency());
        if (pair.isConventional()) {
            return new ResolvedFxSingle(payment2, payment1);
        }
        return new ResolvedFxSingle(payment1, payment2);
    }

    public static ResolvedFxSingle of(CurrencyAmount amount1, CurrencyAmount amount2, LocalDate valueDate) {
        return ResolvedFxSingle.of(Payment.of((CurrencyAmount)amount1, (LocalDate)valueDate), Payment.of((CurrencyAmount)amount2, (LocalDate)valueDate));
    }

    public static ResolvedFxSingle of(CurrencyAmount amountCurrency1, FxRate fxRate, LocalDate paymentDate) {
        CurrencyPair pair = fxRate.getPair();
        ArgChecker.isTrue((boolean)pair.contains(amountCurrency1.getCurrency()));
        Currency currency2 = pair.getBase().equals((Object)amountCurrency1.getCurrency()) ? pair.getCounter() : pair.getBase();
        CurrencyAmount amountCurrency2 = amountCurrency1.convertedTo(currency2, (FxRateProvider)fxRate).negated();
        return ResolvedFxSingle.of(Payment.of((CurrencyAmount)amountCurrency1, (LocalDate)paymentDate), Payment.of((CurrencyAmount)amountCurrency2, (LocalDate)paymentDate));
    }

    @ImmutableValidator
    private void validate() {
        if (this.baseCurrencyPayment.getCurrency().equals((Object)this.counterCurrencyPayment.getCurrency())) {
            throw new IllegalArgumentException("Payments must have different currencies");
        }
        if ((this.baseCurrencyPayment.getAmount() != 0.0 || this.counterCurrencyPayment.getAmount() != 0.0) && Math.signum(this.baseCurrencyPayment.getAmount()) != -Math.signum(this.counterCurrencyPayment.getAmount())) {
            throw new IllegalArgumentException("Payments must have different signs");
        }
        ArgChecker.inOrderOrEqual((Comparable)this.baseCurrencyPayment.getDate(), (Object)this.counterCurrencyPayment.getDate(), (String)"baseCurrencyPayment.date", (String)"counterCurrencyPayment.date");
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        Payment base = builder.baseCurrencyPayment;
        Payment counter = builder.counterCurrencyPayment;
        CurrencyPair pair = CurrencyPair.of((Currency)counter.getCurrency(), (Currency)base.getCurrency());
        if (pair.isConventional()) {
            builder.baseCurrencyPayment = counter;
            builder.counterCurrencyPayment = base;
        }
    }

    public CurrencyPair getCurrencyPair() {
        return CurrencyPair.of((Currency)this.baseCurrencyPayment.getCurrency(), (Currency)this.counterCurrencyPayment.getCurrency());
    }

    public CurrencyAmount getReceiveCurrencyAmount() {
        if (this.baseCurrencyPayment.getAmount() > 0.0) {
            return CurrencyAmount.of((Currency)this.baseCurrencyPayment.getCurrency(), (double)this.baseCurrencyPayment.getAmount());
        }
        return CurrencyAmount.of((Currency)this.counterCurrencyPayment.getCurrency(), (double)this.counterCurrencyPayment.getAmount());
    }

    public LocalDate getPaymentDate() {
        return this.baseCurrencyPayment.getDate();
    }

    public ResolvedFxSingle inverse() {
        return new ResolvedFxSingle(this.baseCurrencyPayment.negated(), this.counterCurrencyPayment.negated());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ResolvedFxSingle(Payment baseCurrencyPayment, Payment counterCurrencyPayment) {
        JodaBeanUtils.notNull((Object)baseCurrencyPayment, (String)"baseCurrencyPayment");
        JodaBeanUtils.notNull((Object)counterCurrencyPayment, (String)"counterCurrencyPayment");
        this.baseCurrencyPayment = baseCurrencyPayment;
        this.counterCurrencyPayment = counterCurrencyPayment;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Payment getBaseCurrencyPayment() {
        return this.baseCurrencyPayment;
    }

    public Payment getCounterCurrencyPayment() {
        return this.counterCurrencyPayment;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedFxSingle other = (ResolvedFxSingle)obj;
            return JodaBeanUtils.equal((Object)this.baseCurrencyPayment, (Object)other.baseCurrencyPayment) && JodaBeanUtils.equal((Object)this.counterCurrencyPayment, (Object)other.counterCurrencyPayment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.baseCurrencyPayment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.counterCurrencyPayment);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ResolvedFxSingle{");
        buf.append("baseCurrencyPayment").append('=').append(JodaBeanUtils.toString((Object)this.baseCurrencyPayment)).append(',').append(' ');
        buf.append("counterCurrencyPayment").append('=').append(JodaBeanUtils.toString((Object)this.counterCurrencyPayment));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ResolvedFxSingle> {
        private Payment baseCurrencyPayment;
        private Payment counterCurrencyPayment;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 765258148: {
                    return this.baseCurrencyPayment;
                }
                case -863240423: {
                    return this.counterCurrencyPayment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 765258148: {
                    this.baseCurrencyPayment = (Payment)newValue;
                    break;
                }
                case -863240423: {
                    this.counterCurrencyPayment = (Payment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ResolvedFxSingle build() {
            ResolvedFxSingle.preBuild(this);
            return new ResolvedFxSingle(this.baseCurrencyPayment, this.counterCurrencyPayment);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ResolvedFxSingle.Builder{");
            buf.append("baseCurrencyPayment").append('=').append(JodaBeanUtils.toString((Object)this.baseCurrencyPayment)).append(',').append(' ');
            buf.append("counterCurrencyPayment").append('=').append(JodaBeanUtils.toString((Object)this.counterCurrencyPayment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Payment> baseCurrencyPayment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"baseCurrencyPayment", ResolvedFxSingle.class, Payment.class);
        private final MetaProperty<Payment> counterCurrencyPayment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"counterCurrencyPayment", ResolvedFxSingle.class, Payment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"baseCurrencyPayment", "counterCurrencyPayment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 765258148: {
                    return this.baseCurrencyPayment;
                }
                case -863240423: {
                    return this.counterCurrencyPayment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ResolvedFxSingle> builder() {
            return new Builder();
        }

        public Class<? extends ResolvedFxSingle> beanType() {
            return ResolvedFxSingle.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Payment> baseCurrencyPayment() {
            return this.baseCurrencyPayment;
        }

        public MetaProperty<Payment> counterCurrencyPayment() {
            return this.counterCurrencyPayment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 765258148: {
                    return ((ResolvedFxSingle)bean).getBaseCurrencyPayment();
                }
                case -863240423: {
                    return ((ResolvedFxSingle)bean).getCounterCurrencyPayment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

