/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.fx.ResolvedFxSingle;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ResolvedFxSwap
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ResolvedFxSingle nearLeg;
    @PropertyDefinition(validate="notNull")
    private final ResolvedFxSingle farLeg;
    private static final long serialVersionUID = 1L;

    public static ResolvedFxSwap of(ResolvedFxSingle nearLeg, ResolvedFxSingle farLeg) {
        return new ResolvedFxSwap(nearLeg, farLeg);
    }

    public static ResolvedFxSwap ofForwardPoints(CurrencyAmount amountCurrency1, Currency currency2, double nearFxRate, double forwardPoints, LocalDate nearDate, LocalDate farDate) {
        Currency currency1 = amountCurrency1.getCurrency();
        ArgChecker.isFalse((boolean)currency1.equals((Object)currency2), (String)"Currencies must not be equal");
        ArgChecker.notNegativeOrZero((double)nearFxRate, (String)"fxRate");
        double farFxRate = nearFxRate + forwardPoints;
        ResolvedFxSingle nearLeg = ResolvedFxSingle.of(amountCurrency1, FxRate.of((Currency)currency1, (Currency)currency2, (double)nearFxRate), nearDate);
        ResolvedFxSingle farLeg = ResolvedFxSingle.of(amountCurrency1.negated(), FxRate.of((Currency)currency1, (Currency)currency2, (double)farFxRate), farDate);
        return ResolvedFxSwap.of(nearLeg, farLeg);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.nearLeg.getPaymentDate(), (Object)this.farLeg.getPaymentDate(), (String)"nearLeg.paymentDate", (String)"farLeg.paymentDate");
        if (!this.nearLeg.getBaseCurrencyPayment().getCurrency().equals((Object)this.farLeg.getBaseCurrencyPayment().getCurrency()) || !this.nearLeg.getCounterCurrencyPayment().getCurrency().equals((Object)this.farLeg.getCounterCurrencyPayment().getCurrency())) {
            throw new IllegalArgumentException("Legs must have the same currency pair");
        }
        if (Math.signum(this.nearLeg.getBaseCurrencyPayment().getAmount()) == Math.signum(this.farLeg.getBaseCurrencyPayment().getAmount())) {
            throw new IllegalArgumentException("Legs must have payments flowing in opposite directions");
        }
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ResolvedFxSwap(ResolvedFxSingle nearLeg, ResolvedFxSingle farLeg) {
        JodaBeanUtils.notNull((Object)nearLeg, (String)"nearLeg");
        JodaBeanUtils.notNull((Object)farLeg, (String)"farLeg");
        this.nearLeg = nearLeg;
        this.farLeg = farLeg;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ResolvedFxSingle getNearLeg() {
        return this.nearLeg;
    }

    public ResolvedFxSingle getFarLeg() {
        return this.farLeg;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedFxSwap other = (ResolvedFxSwap)obj;
            return JodaBeanUtils.equal((Object)this.nearLeg, (Object)other.nearLeg) && JodaBeanUtils.equal((Object)this.farLeg, (Object)other.farLeg);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.nearLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.farLeg);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("ResolvedFxSwap{");
        buf.append("nearLeg").append('=').append(JodaBeanUtils.toString((Object)this.nearLeg)).append(',').append(' ');
        buf.append("farLeg").append('=').append(JodaBeanUtils.toString((Object)this.farLeg));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ResolvedFxSwap> {
        private ResolvedFxSingle nearLeg;
        private ResolvedFxSingle farLeg;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1825755334: {
                    return this.nearLeg;
                }
                case -1281739913: {
                    return this.farLeg;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1825755334: {
                    this.nearLeg = (ResolvedFxSingle)newValue;
                    break;
                }
                case -1281739913: {
                    this.farLeg = (ResolvedFxSingle)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ResolvedFxSwap build() {
            return new ResolvedFxSwap(this.nearLeg, this.farLeg);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("ResolvedFxSwap.Builder{");
            buf.append("nearLeg").append('=').append(JodaBeanUtils.toString((Object)this.nearLeg)).append(',').append(' ');
            buf.append("farLeg").append('=').append(JodaBeanUtils.toString((Object)this.farLeg));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ResolvedFxSingle> nearLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nearLeg", ResolvedFxSwap.class, ResolvedFxSingle.class);
        private final MetaProperty<ResolvedFxSingle> farLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"farLeg", ResolvedFxSwap.class, ResolvedFxSingle.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"nearLeg", "farLeg"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1825755334: {
                    return this.nearLeg;
                }
                case -1281739913: {
                    return this.farLeg;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ResolvedFxSwap> builder() {
            return new Builder();
        }

        public Class<? extends ResolvedFxSwap> beanType() {
            return ResolvedFxSwap.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ResolvedFxSingle> nearLeg() {
            return this.nearLeg;
        }

        public MetaProperty<ResolvedFxSingle> farLeg() {
            return this.farLeg;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1825755334: {
                    return ((ResolvedFxSwap)bean).getNearLeg();
                }
                case -1281739913: {
                    return ((ResolvedFxSwap)bean).getFarLeg();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

