/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.MarketTenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.TradeConvention;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.fx.FxSwapTrade;
import com.opengamma.strata.product.fx.type.FxSwapConventions;
import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface FxSwapConvention
extends TradeConvention,
Named {
    @FromString
    public static FxSwapConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (FxSwapConvention)FxSwapConvention.extendedEnum().lookup(uniqueName);
    }

    @FromString
    public static FxSwapConvention of(CurrencyPair currencyPair) {
        ArgChecker.notNull((Object)currencyPair, (String)"currencyPair");
        return FxSwapConvention.of(currencyPair.toConventional().toString());
    }

    public static ExtendedEnum<FxSwapConvention> extendedEnum() {
        return FxSwapConventions.ENUM_LOOKUP;
    }

    public CurrencyPair getCurrencyPair();

    public DaysAdjustment getSpotDateOffset();

    default public FxSwapTrade createTrade(LocalDate tradeDate, MarketTenor marketTenor, BuySell buySell, double notional, double nearFxRate, double farLegForwardPoints, ReferenceData refData) {
        Currency buySellCurrency = this.getCurrencyPair().getBase();
        return this.createTrade(tradeDate, marketTenor, buySell, buySellCurrency, notional, nearFxRate, farLegForwardPoints, refData);
    }

    default public FxSwapTrade createTrade(LocalDate tradeDate, MarketTenor marketTenor, BuySell buySell, Currency buySellCurrency, double buySellNotional, double nearFxRate, double farLegForwardPoints, ReferenceData refData) {
        LocalDate startDate = marketTenor.adjustSpotLag(this.getSpotDateOffset()).adjust(tradeDate, refData);
        LocalDate endDate = startDate.plus((TemporalAmount)marketTenor.getTenor());
        return this.toTrade(tradeDate, startDate, endDate, buySell, buySellCurrency, buySellNotional, nearFxRate, farLegForwardPoints);
    }

    default public FxSwapTrade createTrade(LocalDate tradeDate, Period periodToNear, Period periodToFar, BuySell buySell, double notional, double nearFxRate, double farLegForwardPoints, ReferenceData refData) {
        Currency buySellCurrency = this.getCurrencyPair().getBase();
        return this.createTrade(tradeDate, periodToNear, periodToFar, buySell, buySellCurrency, notional, nearFxRate, farLegForwardPoints, refData);
    }

    default public FxSwapTrade createTrade(LocalDate tradeDate, Period periodToNear, Period periodToFar, BuySell buySell, Currency buySellCurrency, double buySellNotional, double nearFxRate, double farLegForwardPoints, ReferenceData refData) {
        LocalDate spotDate = this.calculateSpotDateFromTradeDate(tradeDate, refData);
        LocalDate startDate = spotDate.plus(periodToNear);
        LocalDate endDate = spotDate.plus(periodToFar);
        return this.toTrade(tradeDate, startDate, endDate, buySell, buySellCurrency, buySellNotional, nearFxRate, farLegForwardPoints);
    }

    default public FxSwapTrade toTrade(LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double nearFxRate, double farLegForwardPoints) {
        Currency buySellCurrency = this.getCurrencyPair().getBase();
        return this.toTrade(tradeDate, startDate, endDate, buySell, buySellCurrency, notional, nearFxRate, farLegForwardPoints);
    }

    default public FxSwapTrade toTrade(LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, Currency buySellCurrency, double buySellNotional, double nearFxRate, double farLegForwardPoints) {
        TradeInfo tradeInfo = TradeInfo.of(tradeDate);
        return this.toTrade(tradeInfo, startDate, endDate, buySell, buySellCurrency, buySellNotional, nearFxRate, farLegForwardPoints);
    }

    default public FxSwapTrade toTrade(TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double nearFxRate, double farLegForwardPoints) {
        Currency buySellCurrency = this.getCurrencyPair().getBase();
        return this.toTrade(tradeInfo, startDate, endDate, buySell, buySellCurrency, notional, nearFxRate, farLegForwardPoints);
    }

    public FxSwapTrade toTrade(TradeInfo var1, LocalDate var2, LocalDate var3, BuySell var4, Currency var5, double var6, double var8, double var10);

    default public LocalDate calculateSpotDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.getSpotDateOffset().adjust(tradeDate, refData);
    }

    @ToString
    public String getName();
}

