/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeTemplate;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.fx.FxSwapTrade;
import com.opengamma.strata.product.fx.type.FxSwapConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FxSwapTemplate
implements TradeTemplate,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Period periodToNear;
    @PropertyDefinition(validate="notNull")
    private final Period periodToFar;
    @PropertyDefinition(validate="notNull")
    private final FxSwapConvention convention;
    private static final long serialVersionUID = 1L;

    public static FxSwapTemplate of(Period periodToFar, FxSwapConvention convention) {
        return FxSwapTemplate.builder().periodToNear(Period.ZERO).periodToFar(periodToFar).convention(convention).build();
    }

    public static FxSwapTemplate of(Period periodToNear, Period periodToFar, FxSwapConvention convention) {
        return FxSwapTemplate.builder().periodToNear(periodToNear).periodToFar(periodToFar).convention(convention).build();
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isFalse((boolean)this.periodToNear.isNegative(), (String)"Period to start must not be negative");
        ArgChecker.isFalse((boolean)this.periodToFar.isNegative(), (String)"Period to end must not be negative");
    }

    public CurrencyPair getCurrencyPair() {
        return this.convention.getCurrencyPair();
    }

    public FxSwapTrade createTrade(LocalDate tradeDate, BuySell buySell, double notional, double nearFxRate, double forwardPoints, ReferenceData refData) {
        return this.convention.createTrade(tradeDate, this.periodToNear, this.periodToFar, buySell, notional, nearFxRate, forwardPoints, refData);
    }

    public FxSwapTrade createTrade(LocalDate tradeDate, BuySell buySell, Currency buySellCurrency, double buySellNotional, double nearFxRate, double forwardPoints, ReferenceData refData) {
        return this.convention.createTrade(tradeDate, this.periodToNear, this.periodToFar, buySell, buySellCurrency, buySellNotional, nearFxRate, forwardPoints, refData);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FxSwapTemplate(Period periodToNear, Period periodToFar, FxSwapConvention convention) {
        JodaBeanUtils.notNull((Object)periodToNear, (String)"periodToNear");
        JodaBeanUtils.notNull((Object)periodToFar, (String)"periodToFar");
        JodaBeanUtils.notNull((Object)convention, (String)"convention");
        this.periodToNear = periodToNear;
        this.periodToFar = periodToFar;
        this.convention = convention;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Period getPeriodToNear() {
        return this.periodToNear;
    }

    public Period getPeriodToFar() {
        return this.periodToFar;
    }

    public FxSwapConvention getConvention() {
        return this.convention;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxSwapTemplate other = (FxSwapTemplate)obj;
            return JodaBeanUtils.equal((Object)this.periodToNear, (Object)other.periodToNear) && JodaBeanUtils.equal((Object)this.periodToFar, (Object)other.periodToFar) && JodaBeanUtils.equal((Object)this.convention, (Object)other.convention);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.periodToNear);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.periodToFar);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("FxSwapTemplate{");
        buf.append("periodToNear").append('=').append(JodaBeanUtils.toString((Object)this.periodToNear)).append(',').append(' ');
        buf.append("periodToFar").append('=').append(JodaBeanUtils.toString((Object)this.periodToFar)).append(',').append(' ');
        buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FxSwapTemplate> {
        private Period periodToNear;
        private Period periodToFar;
        private FxSwapConvention convention;

        private Builder() {
        }

        private Builder(FxSwapTemplate beanToCopy) {
            this.periodToNear = beanToCopy.getPeriodToNear();
            this.periodToFar = beanToCopy.getPeriodToFar();
            this.convention = beanToCopy.getConvention();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -18701724: {
                    return this.periodToNear;
                }
                case -970442405: {
                    return this.periodToFar;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -18701724: {
                    this.periodToNear = (Period)newValue;
                    break;
                }
                case -970442405: {
                    this.periodToFar = (Period)newValue;
                    break;
                }
                case 2039569265: {
                    this.convention = (FxSwapConvention)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FxSwapTemplate build() {
            return new FxSwapTemplate(this.periodToNear, this.periodToFar, this.convention);
        }

        public Builder periodToNear(Period periodToNear) {
            JodaBeanUtils.notNull((Object)periodToNear, (String)"periodToNear");
            this.periodToNear = periodToNear;
            return this;
        }

        public Builder periodToFar(Period periodToFar) {
            JodaBeanUtils.notNull((Object)periodToFar, (String)"periodToFar");
            this.periodToFar = periodToFar;
            return this;
        }

        public Builder convention(FxSwapConvention convention) {
            JodaBeanUtils.notNull((Object)convention, (String)"convention");
            this.convention = convention;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("FxSwapTemplate.Builder{");
            buf.append("periodToNear").append('=').append(JodaBeanUtils.toString((Object)this.periodToNear)).append(',').append(' ');
            buf.append("periodToFar").append('=').append(JodaBeanUtils.toString((Object)this.periodToFar)).append(',').append(' ');
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Period> periodToNear = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periodToNear", FxSwapTemplate.class, Period.class);
        private final MetaProperty<Period> periodToFar = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periodToFar", FxSwapTemplate.class, Period.class);
        private final MetaProperty<FxSwapConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", FxSwapTemplate.class, FxSwapConvention.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"periodToNear", "periodToFar", "convention"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -18701724: {
                    return this.periodToNear;
                }
                case -970442405: {
                    return this.periodToFar;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FxSwapTemplate> beanType() {
            return FxSwapTemplate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Period> periodToNear() {
            return this.periodToNear;
        }

        public MetaProperty<Period> periodToFar() {
            return this.periodToFar;
        }

        public MetaProperty<FxSwapConvention> convention() {
            return this.convention;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -18701724: {
                    return ((FxSwapTemplate)bean).getPeriodToNear();
                }
                case -970442405: {
                    return ((FxSwapTemplate)bean).getPeriodToFar();
                }
                case 2039569265: {
                    return ((FxSwapTemplate)bean).getConvention();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

