/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.currency.FxRate;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.result.IllegalArgFailureException;
import com.opengamma.strata.product.AttributeType;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.fx.FxSwap;
import com.opengamma.strata.product.fx.FxSwapTrade;
import com.opengamma.strata.product.fx.type.FxSwapConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableFxSwapConvention
implements FxSwapConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyPair currencyPair;
    @PropertyDefinition(get="field")
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment spotDateOffset;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment businessDayAdjustment;
    private static final long serialVersionUID = 1L;

    public static ImmutableFxSwapConvention of(CurrencyPair currencyPair, DaysAdjustment spotDateOffset) {
        return ImmutableFxSwapConvention.builder().currencyPair(currencyPair).spotDateOffset(spotDateOffset).build();
    }

    public static ImmutableFxSwapConvention of(CurrencyPair currencyPair, DaysAdjustment spotDateOffset, BusinessDayAdjustment businessDayAdjustment) {
        ArgChecker.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        return ImmutableFxSwapConvention.builder().currencyPair(currencyPair).spotDateOffset(spotDateOffset).businessDayAdjustment(businessDayAdjustment).build();
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.currencyPair.toString();
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment != null ? this.businessDayAdjustment : BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)this.spotDateOffset.getCalendar());
    }

    @Override
    public FxSwapTrade toTrade(TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, Currency buySellCurrency, double notional, double nearFxRate, double farLegForwardPoints) {
        if (!this.currencyPair.contains(buySellCurrency)) {
            throw new IllegalArgFailureException("Buy/Sell currency {value} does not match convention {options}", new Object[]{buySellCurrency, this.currencyPair});
        }
        Optional<LocalDate> tradeDate = tradeInfo.getTradeDate();
        if (tradeDate.isPresent()) {
            ArgChecker.inOrderOrEqual((Comparable)tradeDate.get(), (Object)startDate, (String)"tradeDate", (String)"startDate");
        }
        double amount1 = buySell.normalize(notional);
        return FxSwapTrade.builder().info((TradeInfo)tradeInfo.withAttribute((AttributeType)AttributeType.BUY_SELL, (Object)buySell)).product(FxSwap.ofForwardPoints(CurrencyAmount.of((Currency)buySellCurrency, (double)amount1), FxRate.of((CurrencyPair)this.currencyPair, (double)nearFxRate), farLegForwardPoints, startDate, endDate, this.getBusinessDayAdjustment())).build();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableFxSwapConvention(CurrencyPair currencyPair, String name, DaysAdjustment spotDateOffset, BusinessDayAdjustment businessDayAdjustment) {
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
        this.currencyPair = currencyPair;
        this.name = name;
        this.spotDateOffset = spotDateOffset;
        this.businessDayAdjustment = businessDayAdjustment;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    @Override
    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableFxSwapConvention other = (ImmutableFxSwapConvention)obj;
            return JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableFxSwapConvention> {
        private CurrencyPair currencyPair;
        private String name;
        private DaysAdjustment spotDateOffset;
        private BusinessDayAdjustment businessDayAdjustment;

        private Builder() {
        }

        private Builder(ImmutableFxSwapConvention beanToCopy) {
            this.currencyPair = beanToCopy.getCurrencyPair();
            this.name = beanToCopy.name;
            this.spotDateOffset = beanToCopy.getSpotDateOffset();
            this.businessDayAdjustment = beanToCopy.businessDayAdjustment;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case 3373707: {
                    return this.name;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableFxSwapConvention build() {
            return new ImmutableFxSwapConvention(this.currencyPair, this.name, this.spotDateOffset, this.businessDayAdjustment);
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableFxSwapConvention.Builder{");
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", ImmutableFxSwapConvention.class, CurrencyPair.class);
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableFxSwapConvention.class, String.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", ImmutableFxSwapConvention.class, DaysAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", ImmutableFxSwapConvention.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currencyPair", "name", "spotDateOffset", "businessDayAdjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return this.currencyPair;
                }
                case 3373707: {
                    return this.name;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableFxSwapConvention> beanType() {
            return ImmutableFxSwapConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1005147787: {
                    return ((ImmutableFxSwapConvention)bean).getCurrencyPair();
                }
                case 3373707: {
                    return ((ImmutableFxSwapConvention)bean).name;
                }
                case 746995843: {
                    return ((ImmutableFxSwapConvention)bean).getSpotDateOffset();
                }
                case -1065319863: {
                    return ((ImmutableFxSwapConvention)bean).businessDayAdjustment;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

