/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fx.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.product.fx.type.FxSwapConvention;
import com.opengamma.strata.product.fx.type.ImmutableFxSwapConvention;

public final class StandardFxSwapConventions {
    private static final HolidayCalendarId EUTA_JPTO = HolidayCalendarIds.EUTA.combinedWith(HolidayCalendarIds.JPTO);
    private static final HolidayCalendarId EUTA_USNY = HolidayCalendarIds.EUTA.combinedWith(HolidayCalendarIds.USNY);
    private static final HolidayCalendarId EUTA_GBLO = HolidayCalendarIds.EUTA.combinedWith(HolidayCalendarIds.GBLO);
    private static final HolidayCalendarId GBLO_USNY = HolidayCalendarIds.GBLO.combinedWith(HolidayCalendarIds.USNY);
    private static final HolidayCalendarId GBLO_JPTO = HolidayCalendarIds.GBLO.combinedWith(HolidayCalendarIds.JPTO);
    private static final HolidayCalendarId JPTO_USNY = HolidayCalendarIds.JPTO.combinedWith(HolidayCalendarIds.USNY);
    public static final FxSwapConvention EUR_USD = ImmutableFxSwapConvention.of(CurrencyPair.of((Currency)Currency.EUR, (Currency)Currency.USD), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)EUTA_USNY), BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)EUTA_USNY));
    public static final FxSwapConvention EUR_GBP = ImmutableFxSwapConvention.of(CurrencyPair.of((Currency)Currency.EUR, (Currency)Currency.GBP), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)EUTA_GBLO), BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)EUTA_GBLO));
    public static final FxSwapConvention EUR_JPY = ImmutableFxSwapConvention.of(CurrencyPair.of((Currency)Currency.EUR, (Currency)Currency.JPY), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)EUTA_JPTO), BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)EUTA_JPTO));
    public static final FxSwapConvention GBP_USD = ImmutableFxSwapConvention.of(CurrencyPair.of((Currency)Currency.GBP, (Currency)Currency.USD), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)GBLO_USNY), BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)GBLO_USNY));
    public static final FxSwapConvention GBP_JPY = ImmutableFxSwapConvention.of(CurrencyPair.of((Currency)Currency.GBP, (Currency)Currency.JPY), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)GBLO_JPTO), BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)GBLO_JPTO));
    public static final FxSwapConvention USD_JPY = ImmutableFxSwapConvention.of(CurrencyPair.of((Currency)Currency.USD, (Currency)Currency.JPY), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)JPTO_USNY), BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)JPTO_USNY));

    private StandardFxSwapConventions() {
    }
}

