/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fxopt;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.common.LongShort;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.fx.FxOptionProduct;
import com.opengamma.strata.product.fx.FxSingle;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOption;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FxVanillaOption
implements FxOptionProduct,
Resolvable<ResolvedFxVanillaOption>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LongShort longShort;
    @PropertyDefinition(validate="notNull")
    private final LocalDate expiryDate;
    @PropertyDefinition(validate="notNull")
    private final LocalTime expiryTime;
    @PropertyDefinition(validate="notNull")
    private final ZoneId expiryZone;
    @PropertyDefinition(validate="notNull")
    private final FxSingle underlying;
    private static final long serialVersionUID = 1L;

    public static FxVanillaOption of(LongShort longShort, ZonedDateTime expiry, CurrencyPair currencyPair, PutCall putCall, double strike, double baseNotional, LocalDate paymentDate) {
        ArgChecker.isTrue((baseNotional > 0.0 ? 1 : 0) != 0, (String)"Base notional must be positive");
        ArgChecker.isTrue((strike > 0.0 ? 1 : 0) != 0, (String)"FX strike must be positive");
        double baseAmount = putCall.isCall() ? baseNotional : -baseNotional;
        double counterNotional = strike * baseNotional;
        double counterAmount = putCall.isCall() ? -counterNotional : counterNotional;
        FxSingle equivalentUnderlying = FxSingle.of(CurrencyAmount.of((Currency)currencyPair.getBase(), (double)baseAmount), CurrencyAmount.of((Currency)currencyPair.getCounter(), (double)counterAmount), paymentDate);
        return FxVanillaOption.builder().longShort(longShort).expiryDate(expiry.toLocalDate()).expiryTime(expiry.toLocalTime()).expiryZone(expiry.getZone()).underlying(equivalentUnderlying).build();
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderOrEqual((Comparable)this.expiryDate, (Object)this.underlying.getPaymentDate(), (String)"expiryDate", (String)"underlying.paymentDate");
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.underlying.getCurrencyPair();
    }

    @Override
    public ZonedDateTime getExpiry() {
        return this.expiryDate.atTime(this.expiryTime).atZone(this.expiryZone);
    }

    public ResolvedFxVanillaOption resolve(ReferenceData refData) {
        return ResolvedFxVanillaOption.builder().longShort(this.longShort).expiry(this.getExpiry()).underlying(this.underlying.resolve(refData)).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FxVanillaOption(LongShort longShort, LocalDate expiryDate, LocalTime expiryTime, ZoneId expiryZone, FxSingle underlying) {
        JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
        JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
        JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
        JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        this.longShort = longShort;
        this.expiryDate = expiryDate;
        this.expiryTime = expiryTime;
        this.expiryZone = expiryZone;
        this.underlying = underlying;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LongShort getLongShort() {
        return this.longShort;
    }

    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    public LocalTime getExpiryTime() {
        return this.expiryTime;
    }

    public ZoneId getExpiryZone() {
        return this.expiryZone;
    }

    public FxSingle getUnderlying() {
        return this.underlying;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FxVanillaOption other = (FxVanillaOption)obj;
            return JodaBeanUtils.equal((Object)((Object)this.longShort), (Object)((Object)other.longShort)) && JodaBeanUtils.equal((Object)this.expiryDate, (Object)other.expiryDate) && JodaBeanUtils.equal((Object)this.expiryTime, (Object)other.expiryTime) && JodaBeanUtils.equal((Object)this.expiryZone, (Object)other.expiryZone) && JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.longShort));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryZone);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("FxVanillaOption{");
        buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
        buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
        buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
        buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FxVanillaOption> {
        private LongShort longShort;
        private LocalDate expiryDate;
        private LocalTime expiryTime;
        private ZoneId expiryZone;
        private FxSingle underlying;

        private Builder() {
        }

        private Builder(FxVanillaOption beanToCopy) {
            this.longShort = beanToCopy.getLongShort();
            this.expiryDate = beanToCopy.getExpiryDate();
            this.expiryTime = beanToCopy.getExpiryTime();
            this.expiryZone = beanToCopy.getExpiryZone();
            this.underlying = beanToCopy.getUnderlying();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    this.longShort = (LongShort)((Object)newValue);
                    break;
                }
                case -816738431: {
                    this.expiryDate = (LocalDate)newValue;
                    break;
                }
                case -816254304: {
                    this.expiryTime = (LocalTime)newValue;
                    break;
                }
                case -816069761: {
                    this.expiryZone = (ZoneId)newValue;
                    break;
                }
                case -1770633379: {
                    this.underlying = (FxSingle)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FxVanillaOption build() {
            return new FxVanillaOption(this.longShort, this.expiryDate, this.expiryTime, this.expiryZone, this.underlying);
        }

        public Builder longShort(LongShort longShort) {
            JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
            this.longShort = longShort;
            return this;
        }

        public Builder expiryDate(LocalDate expiryDate) {
            JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
            this.expiryDate = expiryDate;
            return this;
        }

        public Builder expiryTime(LocalTime expiryTime) {
            JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
            this.expiryTime = expiryTime;
            return this;
        }

        public Builder expiryZone(ZoneId expiryZone) {
            JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
            this.expiryZone = expiryZone;
            return this;
        }

        public Builder underlying(FxSingle underlying) {
            JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
            this.underlying = underlying;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("FxVanillaOption.Builder{");
            buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
            buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
            buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
            buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LongShort> longShort = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longShort", FxVanillaOption.class, LongShort.class);
        private final MetaProperty<LocalDate> expiryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryDate", FxVanillaOption.class, LocalDate.class);
        private final MetaProperty<LocalTime> expiryTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryTime", FxVanillaOption.class, LocalTime.class);
        private final MetaProperty<ZoneId> expiryZone = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryZone", FxVanillaOption.class, ZoneId.class);
        private final MetaProperty<FxSingle> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", FxVanillaOption.class, FxSingle.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"longShort", "expiryDate", "expiryTime", "expiryZone", "underlying"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FxVanillaOption> beanType() {
            return FxVanillaOption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LongShort> longShort() {
            return this.longShort;
        }

        public MetaProperty<LocalDate> expiryDate() {
            return this.expiryDate;
        }

        public MetaProperty<LocalTime> expiryTime() {
            return this.expiryTime;
        }

        public MetaProperty<ZoneId> expiryZone() {
            return this.expiryZone;
        }

        public MetaProperty<FxSingle> underlying() {
            return this.underlying;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return ((FxVanillaOption)bean).getLongShort();
                }
                case -816738431: {
                    return ((FxVanillaOption)bean).getExpiryDate();
                }
                case -816254304: {
                    return ((FxVanillaOption)bean).getExpiryTime();
                }
                case -816069761: {
                    return ((FxVanillaOption)bean).getExpiryZone();
                }
                case -1770633379: {
                    return ((FxVanillaOption)bean).getUnderlying();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

