/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fxopt;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.fxopt.ResolvedFxVanillaOption;
import com.opengamma.strata.product.option.Barrier;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class ResolvedFxSingleBarrierOption
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ResolvedFxVanillaOption underlyingOption;
    @PropertyDefinition(validate="notNull")
    private final Barrier barrier;
    @PropertyDefinition(get="optional")
    private final CurrencyAmount rebate;
    private static final long serialVersionUID = 1L;

    public static ResolvedFxSingleBarrierOption of(ResolvedFxVanillaOption underlyingOption, Barrier barrier, CurrencyAmount rebate) {
        return new ResolvedFxSingleBarrierOption(underlyingOption, barrier, rebate);
    }

    public static ResolvedFxSingleBarrierOption of(ResolvedFxVanillaOption underlyingOption, Barrier barrier) {
        return new ResolvedFxSingleBarrierOption(underlyingOption, barrier, null);
    }

    @ImmutableValidator
    private void validate() {
        if (this.rebate != null) {
            ArgChecker.isTrue((this.rebate.getAmount() > 0.0 ? 1 : 0) != 0, (String)"rebate must be positive");
            ArgChecker.isTrue((boolean)this.underlyingOption.getUnderlying().getCurrencyPair().contains(this.rebate.getCurrency()), (String)"The rebate currency must be one of underlying currency pair");
        }
    }

    public CurrencyPair getCurrencyPair() {
        return this.underlyingOption.getCurrencyPair();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private ResolvedFxSingleBarrierOption(ResolvedFxVanillaOption underlyingOption, Barrier barrier, CurrencyAmount rebate) {
        JodaBeanUtils.notNull((Object)underlyingOption, (String)"underlyingOption");
        JodaBeanUtils.notNull((Object)barrier, (String)"barrier");
        this.underlyingOption = underlyingOption;
        this.barrier = barrier;
        this.rebate = rebate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ResolvedFxVanillaOption getUnderlyingOption() {
        return this.underlyingOption;
    }

    public Barrier getBarrier() {
        return this.barrier;
    }

    public Optional<CurrencyAmount> getRebate() {
        return Optional.ofNullable(this.rebate);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedFxSingleBarrierOption other = (ResolvedFxSingleBarrierOption)obj;
            return JodaBeanUtils.equal((Object)this.underlyingOption, (Object)other.underlyingOption) && JodaBeanUtils.equal((Object)this.barrier, (Object)other.barrier) && JodaBeanUtils.equal((Object)this.rebate, (Object)other.rebate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingOption);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.barrier);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rebate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ResolvedFxSingleBarrierOption{");
        buf.append("underlyingOption").append('=').append(JodaBeanUtils.toString((Object)this.underlyingOption)).append(',').append(' ');
        buf.append("barrier").append('=').append(JodaBeanUtils.toString((Object)this.barrier)).append(',').append(' ');
        buf.append("rebate").append('=').append(JodaBeanUtils.toString((Object)this.rebate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<ResolvedFxSingleBarrierOption> {
        private ResolvedFxVanillaOption underlyingOption;
        private Barrier barrier;
        private CurrencyAmount rebate;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 87556658: {
                    return this.underlyingOption;
                }
                case -333143113: {
                    return this.barrier;
                }
                case -934952029: {
                    return this.rebate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 87556658: {
                    this.underlyingOption = (ResolvedFxVanillaOption)newValue;
                    break;
                }
                case -333143113: {
                    this.barrier = (Barrier)newValue;
                    break;
                }
                case -934952029: {
                    this.rebate = (CurrencyAmount)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public ResolvedFxSingleBarrierOption build() {
            return new ResolvedFxSingleBarrierOption(this.underlyingOption, this.barrier, this.rebate);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ResolvedFxSingleBarrierOption.Builder{");
            buf.append("underlyingOption").append('=').append(JodaBeanUtils.toString((Object)this.underlyingOption)).append(',').append(' ');
            buf.append("barrier").append('=').append(JodaBeanUtils.toString((Object)this.barrier)).append(',').append(' ');
            buf.append("rebate").append('=').append(JodaBeanUtils.toString((Object)this.rebate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ResolvedFxVanillaOption> underlyingOption = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingOption", ResolvedFxSingleBarrierOption.class, ResolvedFxVanillaOption.class);
        private final MetaProperty<Barrier> barrier = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"barrier", ResolvedFxSingleBarrierOption.class, Barrier.class);
        private final MetaProperty<CurrencyAmount> rebate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rebate", ResolvedFxSingleBarrierOption.class, CurrencyAmount.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"underlyingOption", "barrier", "rebate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 87556658: {
                    return this.underlyingOption;
                }
                case -333143113: {
                    return this.barrier;
                }
                case -934952029: {
                    return this.rebate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends ResolvedFxSingleBarrierOption> builder() {
            return new Builder();
        }

        public Class<? extends ResolvedFxSingleBarrierOption> beanType() {
            return ResolvedFxSingleBarrierOption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ResolvedFxVanillaOption> underlyingOption() {
            return this.underlyingOption;
        }

        public MetaProperty<Barrier> barrier() {
            return this.barrier;
        }

        public MetaProperty<CurrencyAmount> rebate() {
            return this.rebate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 87556658: {
                    return ((ResolvedFxSingleBarrierOption)bean).getUnderlyingOption();
                }
                case -333143113: {
                    return ((ResolvedFxSingleBarrierOption)bean).getBarrier();
                }
                case -934952029: {
                    return ((ResolvedFxSingleBarrierOption)bean).rebate;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

