/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.fxopt;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.common.LongShort;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.fx.ResolvedFxSingle;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedFxVanillaOption
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LongShort longShort;
    @PropertyDefinition(validate="notNull")
    private final ZonedDateTime expiry;
    @PropertyDefinition(validate="notNull")
    private final ResolvedFxSingle underlying;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderOrEqual((Comparable)this.expiry.toLocalDate(), (Object)this.underlying.getPaymentDate(), (String)"expiry.date", (String)"underlying.paymentDate");
    }

    public CurrencyPair getCurrencyPair() {
        return this.underlying.getCurrencyPair();
    }

    public LocalDate getExpiryDate() {
        return this.expiry.toLocalDate();
    }

    public double getStrike() {
        return Math.abs(this.underlying.getCounterCurrencyPayment().getAmount() / this.underlying.getBaseCurrencyPayment().getAmount());
    }

    public PutCall getPutCall() {
        return this.underlying.getCounterCurrencyPayment().getAmount() > 0.0 ? PutCall.PUT : PutCall.CALL;
    }

    public Currency getCounterCurrency() {
        return this.underlying.getCounterCurrencyPayment().getCurrency();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResolvedFxVanillaOption(LongShort longShort, ZonedDateTime expiry, ResolvedFxSingle underlying) {
        JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        this.longShort = longShort;
        this.expiry = expiry;
        this.underlying = underlying;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LongShort getLongShort() {
        return this.longShort;
    }

    public ZonedDateTime getExpiry() {
        return this.expiry;
    }

    public ResolvedFxSingle getUnderlying() {
        return this.underlying;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedFxVanillaOption other = (ResolvedFxVanillaOption)obj;
            return JodaBeanUtils.equal((Object)((Object)this.longShort), (Object)((Object)other.longShort)) && JodaBeanUtils.equal((Object)this.expiry, (Object)other.expiry) && JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.longShort));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("ResolvedFxVanillaOption{");
        buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedFxVanillaOption> {
        private LongShort longShort;
        private ZonedDateTime expiry;
        private ResolvedFxSingle underlying;

        private Builder() {
        }

        private Builder(ResolvedFxVanillaOption beanToCopy) {
            this.longShort = beanToCopy.getLongShort();
            this.expiry = beanToCopy.getExpiry();
            this.underlying = beanToCopy.getUnderlying();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    this.longShort = (LongShort)((Object)newValue);
                    break;
                }
                case -1289159373: {
                    this.expiry = (ZonedDateTime)newValue;
                    break;
                }
                case -1770633379: {
                    this.underlying = (ResolvedFxSingle)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedFxVanillaOption build() {
            return new ResolvedFxVanillaOption(this.longShort, this.expiry, this.underlying);
        }

        public Builder longShort(LongShort longShort) {
            JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
            this.longShort = longShort;
            return this;
        }

        public Builder expiry(ZonedDateTime expiry) {
            JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
            this.expiry = expiry;
            return this;
        }

        public Builder underlying(ResolvedFxSingle underlying) {
            JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
            this.underlying = underlying;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("ResolvedFxVanillaOption.Builder{");
            buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LongShort> longShort = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longShort", ResolvedFxVanillaOption.class, LongShort.class);
        private final MetaProperty<ZonedDateTime> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", ResolvedFxVanillaOption.class, ZonedDateTime.class);
        private final MetaProperty<ResolvedFxSingle> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", ResolvedFxVanillaOption.class, ResolvedFxSingle.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"longShort", "expiry", "underlying"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedFxVanillaOption> beanType() {
            return ResolvedFxVanillaOption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LongShort> longShort() {
            return this.longShort;
        }

        public MetaProperty<ZonedDateTime> expiry() {
            return this.expiry;
        }

        public MetaProperty<ResolvedFxSingle> underlying() {
            return this.underlying;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return ((ResolvedFxVanillaOption)bean).getLongShort();
                }
                case -1289159373: {
                    return ((ResolvedFxVanillaOption)bean).getExpiry();
                }
                case -1770633379: {
                    return ((ResolvedFxVanillaOption)bean).getUnderlying();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

