/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.SecuritizedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.index.ResolvedIborFuture;
import com.opengamma.strata.product.rate.IborRateComputation;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class IborFuture
implements SecuritizedProduct,
Resolvable<ResolvedIborFuture>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityId securityId;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double accrualFactor;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastTradeDate;
    @PropertyDefinition(validate="notNull")
    private final IborIndex index;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.rounding(Rounding.none());
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.index != null) {
            if (builder.accrualFactor == 0.0 && builder.index.getTenor().isMonthBased()) {
                builder.accrualFactor((double)builder.index.getTenor().getPeriod().toTotalMonths() / 12.0);
            }
            if (builder.currency == null) {
                builder.currency = builder.index.getCurrency();
            }
        }
    }

    public LocalDate getFixingDate() {
        return this.lastTradeDate;
    }

    public ResolvedIborFuture resolve(ReferenceData refData) {
        IborRateComputation iborRate = IborRateComputation.of(this.index, this.lastTradeDate, refData);
        return new ResolvedIborFuture(this.securityId, this.currency, this.notional, this.accrualFactor, iborRate, this.rounding);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    IborFuture(SecurityId securityId, Currency currency, double notional, double accrualFactor, LocalDate lastTradeDate, IborIndex index, Rounding rounding) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        ArgChecker.notNegativeOrZero((double)accrualFactor, (String)"accrualFactor");
        JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        this.securityId = securityId;
        this.currency = currency;
        this.notional = notional;
        this.accrualFactor = accrualFactor;
        this.lastTradeDate = lastTradeDate;
        this.index = index;
        this.rounding = rounding;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public double getNotional() {
        return this.notional;
    }

    public double getAccrualFactor() {
        return this.accrualFactor;
    }

    public LocalDate getLastTradeDate() {
        return this.lastTradeDate;
    }

    public IborIndex getIndex() {
        return this.index;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborFuture other = (IborFuture)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((double)this.accrualFactor, (double)other.accrualFactor) && JodaBeanUtils.equal((Object)this.lastTradeDate, (Object)other.lastTradeDate) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.accrualFactor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("IborFuture{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor)).append(',').append(' ');
        buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborFuture> {
        private SecurityId securityId;
        private Currency currency;
        private double notional;
        private double accrualFactor;
        private LocalDate lastTradeDate;
        private IborIndex index;
        private Rounding rounding;

        private Builder() {
            IborFuture.applyDefaults(this);
        }

        private Builder(IborFuture beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.currency = beanToCopy.getCurrency();
            this.notional = beanToCopy.getNotional();
            this.accrualFactor = beanToCopy.getAccrualFactor();
            this.lastTradeDate = beanToCopy.getLastTradeDate();
            this.index = beanToCopy.getIndex();
            this.rounding = beanToCopy.getRounding();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case 100346066: {
                    return this.index;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1540322338: {
                    this.accrualFactor = (Double)newValue;
                    break;
                }
                case -1041950404: {
                    this.lastTradeDate = (LocalDate)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborFuture build() {
            IborFuture.preBuild(this);
            return new IborFuture(this.securityId, this.currency, this.notional, this.accrualFactor, this.lastTradeDate, this.index, this.rounding);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder accrualFactor(double accrualFactor) {
            ArgChecker.notNegativeOrZero((double)accrualFactor, (String)"accrualFactor");
            this.accrualFactor = accrualFactor;
            return this;
        }

        public Builder lastTradeDate(LocalDate lastTradeDate) {
            JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("IborFuture.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor)).append(',').append(' ');
            buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", IborFuture.class, SecurityId.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IborFuture.class, Currency.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", IborFuture.class, Double.TYPE);
        private final MetaProperty<Double> accrualFactor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualFactor", IborFuture.class, Double.TYPE);
        private final MetaProperty<LocalDate> lastTradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastTradeDate", IborFuture.class, LocalDate.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", IborFuture.class, IborIndex.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", IborFuture.class, Rounding.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "currency", "notional", "accrualFactor", "lastTradeDate", "index", "rounding"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case 100346066: {
                    return this.index;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborFuture> beanType() {
            return IborFuture.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<Double> accrualFactor() {
            return this.accrualFactor;
        }

        public MetaProperty<LocalDate> lastTradeDate() {
            return this.lastTradeDate;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((IborFuture)bean).getSecurityId();
                }
                case 575402001: {
                    return ((IborFuture)bean).getCurrency();
                }
                case 1585636160: {
                    return ((IborFuture)bean).getNotional();
                }
                case -1540322338: {
                    return ((IborFuture)bean).getAccrualFactor();
                }
                case -1041950404: {
                    return ((IborFuture)bean).getLastTradeDate();
                }
                case 100346066: {
                    return ((IborFuture)bean).getIndex();
                }
                case -142444: {
                    return ((IborFuture)bean).getRounding();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

