/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.SecuritizedProduct;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.index.IborFuture;
import com.opengamma.strata.product.index.ResolvedIborFuture;
import com.opengamma.strata.product.index.ResolvedIborFutureOption;
import com.opengamma.strata.product.option.FutureOptionPremiumStyle;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(constructorScope="package")
public final class IborFutureOption
implements SecuritizedProduct,
Resolvable<ResolvedIborFutureOption>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityId securityId;
    @PropertyDefinition
    private final PutCall putCall;
    @PropertyDefinition
    private final double strikePrice;
    @PropertyDefinition(validate="notNull")
    private final LocalDate expiryDate;
    @PropertyDefinition(validate="notNull")
    private final LocalTime expiryTime;
    @PropertyDefinition(validate="notNull")
    private final ZoneId expiryZone;
    @PropertyDefinition(validate="notNull")
    private final FutureOptionPremiumStyle premiumStyle;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    @PropertyDefinition(validate="notNull")
    private final IborFuture underlyingFuture;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.rounding(Rounding.none());
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.inOrderOrEqual((Comparable)this.expiryDate, (Object)this.underlyingFuture.getLastTradeDate(), (String)"expiryDate", (String)"lastTradeDate");
        ArgChecker.isTrue((this.strikePrice < 2.0 ? 1 : 0) != 0, (String)"Strike price must be in decimal form, such as 0.993 for a 0.7% rate, but was: {}", (double)this.strikePrice);
    }

    @Override
    public Currency getCurrency() {
        return this.underlyingFuture.getCurrency();
    }

    public ZonedDateTime getExpiry() {
        return this.expiryDate.atTime(this.expiryTime).atZone(this.expiryZone);
    }

    public IborIndex getIndex() {
        return this.underlyingFuture.getIndex();
    }

    public ResolvedIborFutureOption resolve(ReferenceData refData) {
        ResolvedIborFuture resolved = this.underlyingFuture.resolve(refData);
        return new ResolvedIborFutureOption(this.securityId, this.putCall, this.strikePrice, this.getExpiry(), this.premiumStyle, this.rounding, resolved);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    IborFutureOption(SecurityId securityId, PutCall putCall, double strikePrice, LocalDate expiryDate, LocalTime expiryTime, ZoneId expiryZone, FutureOptionPremiumStyle premiumStyle, Rounding rounding, IborFuture underlyingFuture) {
        JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
        JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
        JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
        JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
        JodaBeanUtils.notNull((Object)((Object)premiumStyle), (String)"premiumStyle");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        JodaBeanUtils.notNull((Object)underlyingFuture, (String)"underlyingFuture");
        this.securityId = securityId;
        this.putCall = putCall;
        this.strikePrice = strikePrice;
        this.expiryDate = expiryDate;
        this.expiryTime = expiryTime;
        this.expiryZone = expiryZone;
        this.premiumStyle = premiumStyle;
        this.rounding = rounding;
        this.underlyingFuture = underlyingFuture;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityId getSecurityId() {
        return this.securityId;
    }

    public PutCall getPutCall() {
        return this.putCall;
    }

    public double getStrikePrice() {
        return this.strikePrice;
    }

    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    public LocalTime getExpiryTime() {
        return this.expiryTime;
    }

    public ZoneId getExpiryZone() {
        return this.expiryZone;
    }

    public FutureOptionPremiumStyle getPremiumStyle() {
        return this.premiumStyle;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public IborFuture getUnderlyingFuture() {
        return this.underlyingFuture;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborFutureOption other = (IborFutureOption)obj;
            return JodaBeanUtils.equal((Object)this.securityId, (Object)other.securityId) && JodaBeanUtils.equal((Object)((Object)this.putCall), (Object)((Object)other.putCall)) && JodaBeanUtils.equal((double)this.strikePrice, (double)other.strikePrice) && JodaBeanUtils.equal((Object)this.expiryDate, (Object)other.expiryDate) && JodaBeanUtils.equal((Object)this.expiryTime, (Object)other.expiryTime) && JodaBeanUtils.equal((Object)this.expiryZone, (Object)other.expiryZone) && JodaBeanUtils.equal((Object)((Object)this.premiumStyle), (Object)((Object)other.premiumStyle)) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding) && JodaBeanUtils.equal((Object)this.underlyingFuture, (Object)other.underlyingFuture);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.securityId);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.putCall));
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strikePrice);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryZone);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.premiumStyle));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingFuture);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(320);
        buf.append("IborFutureOption{");
        buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
        buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
        buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
        buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
        buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
        buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
        buf.append("premiumStyle").append('=').append(JodaBeanUtils.toString((Object)((Object)this.premiumStyle))).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
        buf.append("underlyingFuture").append('=').append(JodaBeanUtils.toString((Object)this.underlyingFuture));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborFutureOption> {
        private SecurityId securityId;
        private PutCall putCall;
        private double strikePrice;
        private LocalDate expiryDate;
        private LocalTime expiryTime;
        private ZoneId expiryZone;
        private FutureOptionPremiumStyle premiumStyle;
        private Rounding rounding;
        private IborFuture underlyingFuture;

        private Builder() {
            IborFutureOption.applyDefaults(this);
        }

        private Builder(IborFutureOption beanToCopy) {
            this.securityId = beanToCopy.getSecurityId();
            this.putCall = beanToCopy.getPutCall();
            this.strikePrice = beanToCopy.getStrikePrice();
            this.expiryDate = beanToCopy.getExpiryDate();
            this.expiryTime = beanToCopy.getExpiryTime();
            this.expiryZone = beanToCopy.getExpiryZone();
            this.premiumStyle = beanToCopy.getPremiumStyle();
            this.rounding = beanToCopy.getRounding();
            this.underlyingFuture = beanToCopy.getUnderlyingFuture();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case -219971059: {
                    return this.putCall;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1257652838: {
                    return this.premiumStyle;
                }
                case -142444: {
                    return this.rounding;
                }
                case -165476480: {
                    return this.underlyingFuture;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    this.securityId = (SecurityId)newValue;
                    break;
                }
                case -219971059: {
                    this.putCall = (PutCall)((Object)newValue);
                    break;
                }
                case 50946231: {
                    this.strikePrice = (Double)newValue;
                    break;
                }
                case -816738431: {
                    this.expiryDate = (LocalDate)newValue;
                    break;
                }
                case -816254304: {
                    this.expiryTime = (LocalTime)newValue;
                    break;
                }
                case -816069761: {
                    this.expiryZone = (ZoneId)newValue;
                    break;
                }
                case -1257652838: {
                    this.premiumStyle = (FutureOptionPremiumStyle)((Object)newValue);
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                case -165476480: {
                    this.underlyingFuture = (IborFuture)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborFutureOption build() {
            return new IborFutureOption(this.securityId, this.putCall, this.strikePrice, this.expiryDate, this.expiryTime, this.expiryZone, this.premiumStyle, this.rounding, this.underlyingFuture);
        }

        public Builder securityId(SecurityId securityId) {
            JodaBeanUtils.notNull((Object)securityId, (String)"securityId");
            this.securityId = securityId;
            return this;
        }

        public Builder putCall(PutCall putCall) {
            this.putCall = putCall;
            return this;
        }

        public Builder strikePrice(double strikePrice) {
            this.strikePrice = strikePrice;
            return this;
        }

        public Builder expiryDate(LocalDate expiryDate) {
            JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
            this.expiryDate = expiryDate;
            return this;
        }

        public Builder expiryTime(LocalTime expiryTime) {
            JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
            this.expiryTime = expiryTime;
            return this;
        }

        public Builder expiryZone(ZoneId expiryZone) {
            JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
            this.expiryZone = expiryZone;
            return this;
        }

        public Builder premiumStyle(FutureOptionPremiumStyle premiumStyle) {
            JodaBeanUtils.notNull((Object)((Object)premiumStyle), (String)"premiumStyle");
            this.premiumStyle = premiumStyle;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public Builder underlyingFuture(IborFuture underlyingFuture) {
            JodaBeanUtils.notNull((Object)underlyingFuture, (String)"underlyingFuture");
            this.underlyingFuture = underlyingFuture;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(320);
            buf.append("IborFutureOption.Builder{");
            buf.append("securityId").append('=').append(JodaBeanUtils.toString((Object)this.securityId)).append(',').append(' ');
            buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
            buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
            buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
            buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
            buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
            buf.append("premiumStyle").append('=').append(JodaBeanUtils.toString((Object)((Object)this.premiumStyle))).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
            buf.append("underlyingFuture").append('=').append(JodaBeanUtils.toString((Object)this.underlyingFuture));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityId> securityId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"securityId", IborFutureOption.class, SecurityId.class);
        private final MetaProperty<PutCall> putCall = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"putCall", IborFutureOption.class, PutCall.class);
        private final MetaProperty<Double> strikePrice = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikePrice", IborFutureOption.class, Double.TYPE);
        private final MetaProperty<LocalDate> expiryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryDate", IborFutureOption.class, LocalDate.class);
        private final MetaProperty<LocalTime> expiryTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryTime", IborFutureOption.class, LocalTime.class);
        private final MetaProperty<ZoneId> expiryZone = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryZone", IborFutureOption.class, ZoneId.class);
        private final MetaProperty<FutureOptionPremiumStyle> premiumStyle = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"premiumStyle", IborFutureOption.class, FutureOptionPremiumStyle.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", IborFutureOption.class, Rounding.class);
        private final MetaProperty<IborFuture> underlyingFuture = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingFuture", IborFutureOption.class, IborFuture.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"securityId", "putCall", "strikePrice", "expiryDate", "expiryTime", "expiryZone", "premiumStyle", "rounding", "underlyingFuture"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return this.securityId;
                }
                case -219971059: {
                    return this.putCall;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1257652838: {
                    return this.premiumStyle;
                }
                case -142444: {
                    return this.rounding;
                }
                case -165476480: {
                    return this.underlyingFuture;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborFutureOption> beanType() {
            return IborFutureOption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityId> securityId() {
            return this.securityId;
        }

        public MetaProperty<PutCall> putCall() {
            return this.putCall;
        }

        public MetaProperty<Double> strikePrice() {
            return this.strikePrice;
        }

        public MetaProperty<LocalDate> expiryDate() {
            return this.expiryDate;
        }

        public MetaProperty<LocalTime> expiryTime() {
            return this.expiryTime;
        }

        public MetaProperty<ZoneId> expiryZone() {
            return this.expiryZone;
        }

        public MetaProperty<FutureOptionPremiumStyle> premiumStyle() {
            return this.premiumStyle;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        public MetaProperty<IborFuture> underlyingFuture() {
            return this.underlyingFuture;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1574023291: {
                    return ((IborFutureOption)bean).getSecurityId();
                }
                case -219971059: {
                    return ((IborFutureOption)bean).getPutCall();
                }
                case 50946231: {
                    return ((IborFutureOption)bean).getStrikePrice();
                }
                case -816738431: {
                    return ((IborFutureOption)bean).getExpiryDate();
                }
                case -816254304: {
                    return ((IborFutureOption)bean).getExpiryTime();
                }
                case -816069761: {
                    return ((IborFutureOption)bean).getExpiryZone();
                }
                case -1257652838: {
                    return ((IborFutureOption)bean).getPremiumStyle();
                }
                case -142444: {
                    return ((IborFutureOption)bean).getRounding();
                }
                case -165476480: {
                    return ((IborFutureOption)bean).getUnderlyingFuture();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

