/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.ReferenceDataId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.Security;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.PutCall;
import com.opengamma.strata.product.index.IborFuture;
import com.opengamma.strata.product.index.IborFutureOption;
import com.opengamma.strata.product.index.IborFutureOptionPosition;
import com.opengamma.strata.product.index.IborFutureOptionTrade;
import com.opengamma.strata.product.index.IborFutureSecurity;
import com.opengamma.strata.product.option.FutureOptionPremiumStyle;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborFutureOptionSecurity
implements Security,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition
    private final PutCall putCall;
    @PropertyDefinition
    private final double strikePrice;
    @PropertyDefinition(validate="notNull")
    private final LocalDate expiryDate;
    @PropertyDefinition(validate="notNull")
    private final LocalTime expiryTime;
    @PropertyDefinition(validate="notNull")
    private final ZoneId expiryZone;
    @PropertyDefinition(validate="notNull")
    private final FutureOptionPremiumStyle premiumStyle;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    @PropertyDefinition(validate="notNull")
    private final SecurityId underlyingFutureId;
    private static final long serialVersionUID = 1L;

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.rounding(Rounding.none());
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((this.strikePrice < 2.0 ? 1 : 0) != 0, (String)"Strike price must be in decimal form, such as 0.993 for a 0.7% rate, but was: {}", (double)this.strikePrice);
    }

    @Override
    public ImmutableSet<SecurityId> getUnderlyingIds() {
        return ImmutableSet.of((Object)this.underlyingFutureId);
    }

    @Override
    public IborFutureOptionSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public IborFutureOption createProduct(ReferenceData refData) {
        Security security = (Security)refData.getValue((ReferenceDataId)this.underlyingFutureId);
        if (!(security instanceof IborFutureSecurity)) {
            throw new ClassCastException(Messages.format((String)"{} underlying future '{}' resolved to '{}' when '{}' was expected", (Object[])new Object[]{IborFutureOptionSecurity.class.getSimpleName(), this.underlyingFutureId, security.getClass().getSimpleName(), IborFutureSecurity.class.getSimpleName()}));
        }
        IborFutureSecurity futureSec = (IborFutureSecurity)security;
        IborFuture underlying = futureSec.createProduct(refData);
        return new IborFutureOption(this.getSecurityId(), this.putCall, this.strikePrice, this.expiryDate, this.expiryTime, this.expiryZone, this.premiumStyle, this.rounding, underlying);
    }

    @Override
    public IborFutureOptionTrade createTrade(TradeInfo info, double quantity, double tradePrice, ReferenceData refData) {
        return new IborFutureOptionTrade(info, this.createProduct(refData), quantity, tradePrice);
    }

    @Override
    public IborFutureOptionPosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return IborFutureOptionPosition.ofNet(positionInfo, this.createProduct(refData), quantity);
    }

    @Override
    public IborFutureOptionPosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return IborFutureOptionPosition.ofLongShort(positionInfo, this.createProduct(refData), longQuantity, shortQuantity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IborFutureOptionSecurity(SecurityInfo info, Currency currency, PutCall putCall, double strikePrice, LocalDate expiryDate, LocalTime expiryTime, ZoneId expiryZone, FutureOptionPremiumStyle premiumStyle, Rounding rounding, SecurityId underlyingFutureId) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
        JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
        JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
        JodaBeanUtils.notNull((Object)((Object)premiumStyle), (String)"premiumStyle");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        JodaBeanUtils.notNull((Object)underlyingFutureId, (String)"underlyingFutureId");
        this.info = info;
        this.currency = currency;
        this.putCall = putCall;
        this.strikePrice = strikePrice;
        this.expiryDate = expiryDate;
        this.expiryTime = expiryTime;
        this.expiryZone = expiryZone;
        this.premiumStyle = premiumStyle;
        this.rounding = rounding;
        this.underlyingFutureId = underlyingFutureId;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public PutCall getPutCall() {
        return this.putCall;
    }

    public double getStrikePrice() {
        return this.strikePrice;
    }

    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    public LocalTime getExpiryTime() {
        return this.expiryTime;
    }

    public ZoneId getExpiryZone() {
        return this.expiryZone;
    }

    public FutureOptionPremiumStyle getPremiumStyle() {
        return this.premiumStyle;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public SecurityId getUnderlyingFutureId() {
        return this.underlyingFutureId;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborFutureOptionSecurity other = (IborFutureOptionSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)((Object)this.putCall), (Object)((Object)other.putCall)) && JodaBeanUtils.equal((double)this.strikePrice, (double)other.strikePrice) && JodaBeanUtils.equal((Object)this.expiryDate, (Object)other.expiryDate) && JodaBeanUtils.equal((Object)this.expiryTime, (Object)other.expiryTime) && JodaBeanUtils.equal((Object)this.expiryZone, (Object)other.expiryZone) && JodaBeanUtils.equal((Object)((Object)this.premiumStyle), (Object)((Object)other.premiumStyle)) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding) && JodaBeanUtils.equal((Object)this.underlyingFutureId, (Object)other.underlyingFutureId);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.putCall));
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strikePrice);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryZone);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.premiumStyle));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlyingFutureId);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("IborFutureOptionSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
        buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
        buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
        buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
        buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
        buf.append("premiumStyle").append('=').append(JodaBeanUtils.toString((Object)((Object)this.premiumStyle))).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
        buf.append("underlyingFutureId").append('=').append(JodaBeanUtils.toString((Object)this.underlyingFutureId));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborFutureOptionSecurity> {
        private SecurityInfo info;
        private Currency currency;
        private PutCall putCall;
        private double strikePrice;
        private LocalDate expiryDate;
        private LocalTime expiryTime;
        private ZoneId expiryZone;
        private FutureOptionPremiumStyle premiumStyle;
        private Rounding rounding;
        private SecurityId underlyingFutureId;

        private Builder() {
            IborFutureOptionSecurity.applyDefaults(this);
        }

        private Builder(IborFutureOptionSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.currency = beanToCopy.getCurrency();
            this.putCall = beanToCopy.getPutCall();
            this.strikePrice = beanToCopy.getStrikePrice();
            this.expiryDate = beanToCopy.getExpiryDate();
            this.expiryTime = beanToCopy.getExpiryTime();
            this.expiryZone = beanToCopy.getExpiryZone();
            this.premiumStyle = beanToCopy.getPremiumStyle();
            this.rounding = beanToCopy.getRounding();
            this.underlyingFutureId = beanToCopy.getUnderlyingFutureId();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 575402001: {
                    return this.currency;
                }
                case -219971059: {
                    return this.putCall;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1257652838: {
                    return this.premiumStyle;
                }
                case -142444: {
                    return this.rounding;
                }
                case -109104965: {
                    return this.underlyingFutureId;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -219971059: {
                    this.putCall = (PutCall)((Object)newValue);
                    break;
                }
                case 50946231: {
                    this.strikePrice = (Double)newValue;
                    break;
                }
                case -816738431: {
                    this.expiryDate = (LocalDate)newValue;
                    break;
                }
                case -816254304: {
                    this.expiryTime = (LocalTime)newValue;
                    break;
                }
                case -816069761: {
                    this.expiryZone = (ZoneId)newValue;
                    break;
                }
                case -1257652838: {
                    this.premiumStyle = (FutureOptionPremiumStyle)((Object)newValue);
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                case -109104965: {
                    this.underlyingFutureId = (SecurityId)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborFutureOptionSecurity build() {
            return new IborFutureOptionSecurity(this.info, this.currency, this.putCall, this.strikePrice, this.expiryDate, this.expiryTime, this.expiryZone, this.premiumStyle, this.rounding, this.underlyingFutureId);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder putCall(PutCall putCall) {
            this.putCall = putCall;
            return this;
        }

        public Builder strikePrice(double strikePrice) {
            this.strikePrice = strikePrice;
            return this;
        }

        public Builder expiryDate(LocalDate expiryDate) {
            JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
            this.expiryDate = expiryDate;
            return this;
        }

        public Builder expiryTime(LocalTime expiryTime) {
            JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
            this.expiryTime = expiryTime;
            return this;
        }

        public Builder expiryZone(ZoneId expiryZone) {
            JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
            this.expiryZone = expiryZone;
            return this;
        }

        public Builder premiumStyle(FutureOptionPremiumStyle premiumStyle) {
            JodaBeanUtils.notNull((Object)((Object)premiumStyle), (String)"premiumStyle");
            this.premiumStyle = premiumStyle;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public Builder underlyingFutureId(SecurityId underlyingFutureId) {
            JodaBeanUtils.notNull((Object)underlyingFutureId, (String)"underlyingFutureId");
            this.underlyingFutureId = underlyingFutureId;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("IborFutureOptionSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("putCall").append('=').append(JodaBeanUtils.toString((Object)((Object)this.putCall))).append(',').append(' ');
            buf.append("strikePrice").append('=').append(JodaBeanUtils.toString((Object)this.strikePrice)).append(',').append(' ');
            buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
            buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
            buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
            buf.append("premiumStyle").append('=').append(JodaBeanUtils.toString((Object)((Object)this.premiumStyle))).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
            buf.append("underlyingFutureId").append('=').append(JodaBeanUtils.toString((Object)this.underlyingFutureId));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", IborFutureOptionSecurity.class, SecurityInfo.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IborFutureOptionSecurity.class, Currency.class);
        private final MetaProperty<PutCall> putCall = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"putCall", IborFutureOptionSecurity.class, PutCall.class);
        private final MetaProperty<Double> strikePrice = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikePrice", IborFutureOptionSecurity.class, Double.TYPE);
        private final MetaProperty<LocalDate> expiryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryDate", IborFutureOptionSecurity.class, LocalDate.class);
        private final MetaProperty<LocalTime> expiryTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryTime", IborFutureOptionSecurity.class, LocalTime.class);
        private final MetaProperty<ZoneId> expiryZone = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryZone", IborFutureOptionSecurity.class, ZoneId.class);
        private final MetaProperty<FutureOptionPremiumStyle> premiumStyle = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"premiumStyle", IborFutureOptionSecurity.class, FutureOptionPremiumStyle.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", IborFutureOptionSecurity.class, Rounding.class);
        private final MetaProperty<SecurityId> underlyingFutureId = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlyingFutureId", IborFutureOptionSecurity.class, SecurityId.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "currency", "putCall", "strikePrice", "expiryDate", "expiryTime", "expiryZone", "premiumStyle", "rounding", "underlyingFutureId"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 575402001: {
                    return this.currency;
                }
                case -219971059: {
                    return this.putCall;
                }
                case 50946231: {
                    return this.strikePrice;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1257652838: {
                    return this.premiumStyle;
                }
                case -142444: {
                    return this.rounding;
                }
                case -109104965: {
                    return this.underlyingFutureId;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborFutureOptionSecurity> beanType() {
            return IborFutureOptionSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<PutCall> putCall() {
            return this.putCall;
        }

        public MetaProperty<Double> strikePrice() {
            return this.strikePrice;
        }

        public MetaProperty<LocalDate> expiryDate() {
            return this.expiryDate;
        }

        public MetaProperty<LocalTime> expiryTime() {
            return this.expiryTime;
        }

        public MetaProperty<ZoneId> expiryZone() {
            return this.expiryZone;
        }

        public MetaProperty<FutureOptionPremiumStyle> premiumStyle() {
            return this.premiumStyle;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        public MetaProperty<SecurityId> underlyingFutureId() {
            return this.underlyingFutureId;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((IborFutureOptionSecurity)bean).getInfo();
                }
                case 575402001: {
                    return ((IborFutureOptionSecurity)bean).getCurrency();
                }
                case -219971059: {
                    return ((IborFutureOptionSecurity)bean).getPutCall();
                }
                case 50946231: {
                    return ((IborFutureOptionSecurity)bean).getStrikePrice();
                }
                case -816738431: {
                    return ((IborFutureOptionSecurity)bean).getExpiryDate();
                }
                case -816254304: {
                    return ((IborFutureOptionSecurity)bean).getExpiryTime();
                }
                case -816069761: {
                    return ((IborFutureOptionSecurity)bean).getExpiryZone();
                }
                case -1257652838: {
                    return ((IborFutureOptionSecurity)bean).getPremiumStyle();
                }
                case -142444: {
                    return ((IborFutureOptionSecurity)bean).getRounding();
                }
                case -109104965: {
                    return ((IborFutureOptionSecurity)bean).getUnderlyingFutureId();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

