/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.index.IborFuture;
import com.opengamma.strata.product.index.IborFuturePosition;
import com.opengamma.strata.product.index.IborFutureTrade;
import com.opengamma.strata.product.index.RateIndexSecurity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborFutureSecurity
implements RateIndexSecurity,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastTradeDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    private static final long serialVersionUID = 1L;

    @Override
    @DerivedProperty
    public Currency getCurrency() {
        return this.index.getCurrency();
    }

    @Override
    public ImmutableSet<SecurityId> getUnderlyingIds() {
        return ImmutableSet.of();
    }

    @Override
    public IborFutureSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public IborFuture createProduct(ReferenceData refData) {
        return IborFuture.builder().securityId(this.getSecurityId()).notional(this.notional).index(this.index).lastTradeDate(this.lastTradeDate).rounding(this.rounding).build();
    }

    @Override
    public IborFutureTrade createTrade(TradeInfo info, double quantity, double tradePrice, ReferenceData refData) {
        return new IborFutureTrade(info, this.createProduct(refData), quantity, tradePrice);
    }

    @Override
    public IborFuturePosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return IborFuturePosition.ofNet(positionInfo, this.createProduct(refData), quantity);
    }

    @Override
    public IborFuturePosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return IborFuturePosition.ofLongShort(positionInfo, this.createProduct(refData), longQuantity, shortQuantity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IborFutureSecurity(SecurityInfo info, double notional, LocalDate lastTradeDate, IborIndex index, Rounding rounding) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        this.info = info;
        this.notional = notional;
        this.lastTradeDate = lastTradeDate;
        this.index = index;
        this.rounding = rounding;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    public double getNotional() {
        return this.notional;
    }

    public LocalDate getLastTradeDate() {
        return this.lastTradeDate;
    }

    public IborIndex getIndex() {
        return this.index;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborFutureSecurity other = (IborFutureSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((Object)this.lastTradeDate, (Object)other.lastTradeDate) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("IborFutureSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.getCurrency()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborFutureSecurity> {
        private SecurityInfo info;
        private double notional;
        private LocalDate lastTradeDate;
        private IborIndex index;
        private Rounding rounding;

        private Builder() {
        }

        private Builder(IborFutureSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.notional = beanToCopy.getNotional();
            this.lastTradeDate = beanToCopy.getLastTradeDate();
            this.index = beanToCopy.getIndex();
            this.rounding = beanToCopy.getRounding();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case 100346066: {
                    return this.index;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1041950404: {
                    this.lastTradeDate = (LocalDate)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborFutureSecurity build() {
            return new IborFutureSecurity(this.info, this.notional, this.lastTradeDate, this.index, this.rounding);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder lastTradeDate(LocalDate lastTradeDate) {
            JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("IborFutureSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", IborFutureSecurity.class, SecurityInfo.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", IborFutureSecurity.class, Double.TYPE);
        private final MetaProperty<LocalDate> lastTradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastTradeDate", IborFutureSecurity.class, LocalDate.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", IborFutureSecurity.class, IborIndex.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", IborFutureSecurity.class, Rounding.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofDerived((MetaBean)this, (String)"currency", IborFutureSecurity.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "notional", "lastTradeDate", "index", "rounding", "currency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case 100346066: {
                    return this.index;
                }
                case -142444: {
                    return this.rounding;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborFutureSecurity> beanType() {
            return IborFutureSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<LocalDate> lastTradeDate() {
            return this.lastTradeDate;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((IborFutureSecurity)bean).getInfo();
                }
                case 1585636160: {
                    return ((IborFutureSecurity)bean).getNotional();
                }
                case -1041950404: {
                    return ((IborFutureSecurity)bean).getLastTradeDate();
                }
                case 100346066: {
                    return ((IborFutureSecurity)bean).getIndex();
                }
                case -142444: {
                    return ((IborFutureSecurity)bean).getRounding();
                }
                case 575402001: {
                    return ((IborFutureSecurity)bean).getCurrency();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

