/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.index;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.value.Rounding;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.PositionInfo;
import com.opengamma.strata.product.SecurityId;
import com.opengamma.strata.product.SecurityInfo;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.index.OvernightFuture;
import com.opengamma.strata.product.index.OvernightFuturePosition;
import com.opengamma.strata.product.index.OvernightFutureTrade;
import com.opengamma.strata.product.index.RateIndexSecurity;
import com.opengamma.strata.product.swap.OvernightAccrualMethod;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.DerivedProperty;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class OvernightFutureSecurity
implements RateIndexSecurity,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final SecurityInfo info;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double notional;
    @PropertyDefinition(validate="ArgChecker.notNegativeOrZero")
    private final double accrualFactor;
    @PropertyDefinition(validate="notNull")
    private final LocalDate lastTradeDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final OvernightIndex index;
    @PropertyDefinition(validate="notNull")
    private final OvernightAccrualMethod accrualMethod;
    @PropertyDefinition(validate="notNull")
    private final Rounding rounding;
    private static final long serialVersionUID = 1L;

    @Override
    @DerivedProperty
    public Currency getCurrency() {
        return this.index.getCurrency();
    }

    @Override
    public ImmutableSet<SecurityId> getUnderlyingIds() {
        return ImmutableSet.of();
    }

    @Override
    public OvernightFutureSecurity withInfo(SecurityInfo info) {
        return this.toBuilder().info(info).build();
    }

    @Override
    public OvernightFuture createProduct(ReferenceData refData) {
        return OvernightFuture.builder().securityId(this.getSecurityId()).notional(this.notional).accrualFactor(this.accrualFactor).index(this.index).accrualMethod(this.accrualMethod).lastTradeDate(this.lastTradeDate).startDate(this.startDate).endDate(this.endDate).rounding(this.rounding).build();
    }

    @Override
    public OvernightFutureTrade createTrade(TradeInfo info, double quantity, double tradePrice, ReferenceData refData) {
        return new OvernightFutureTrade(info, this.createProduct(refData), quantity, tradePrice);
    }

    @Override
    public OvernightFuturePosition createPosition(PositionInfo positionInfo, double quantity, ReferenceData refData) {
        return OvernightFuturePosition.ofNet(positionInfo, this.createProduct(refData), quantity);
    }

    @Override
    public OvernightFuturePosition createPosition(PositionInfo positionInfo, double longQuantity, double shortQuantity, ReferenceData refData) {
        return OvernightFuturePosition.ofLongShort(positionInfo, this.createProduct(refData), longQuantity, shortQuantity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private OvernightFutureSecurity(SecurityInfo info, double notional, double accrualFactor, LocalDate lastTradeDate, LocalDate startDate, LocalDate endDate, OvernightIndex index, OvernightAccrualMethod accrualMethod, Rounding rounding) {
        JodaBeanUtils.notNull((Object)info, (String)"info");
        ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
        ArgChecker.notNegativeOrZero((double)accrualFactor, (String)"accrualFactor");
        JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)((Object)accrualMethod), (String)"accrualMethod");
        JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
        this.info = info;
        this.notional = notional;
        this.accrualFactor = accrualFactor;
        this.lastTradeDate = lastTradeDate;
        this.startDate = startDate;
        this.endDate = endDate;
        this.index = index;
        this.accrualMethod = accrualMethod;
        this.rounding = rounding;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public SecurityInfo getInfo() {
        return this.info;
    }

    public double getNotional() {
        return this.notional;
    }

    public double getAccrualFactor() {
        return this.accrualFactor;
    }

    public LocalDate getLastTradeDate() {
        return this.lastTradeDate;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public OvernightIndex getIndex() {
        return this.index;
    }

    public OvernightAccrualMethod getAccrualMethod() {
        return this.accrualMethod;
    }

    public Rounding getRounding() {
        return this.rounding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            OvernightFutureSecurity other = (OvernightFutureSecurity)obj;
            return JodaBeanUtils.equal((Object)this.info, (Object)other.info) && JodaBeanUtils.equal((double)this.notional, (double)other.notional) && JodaBeanUtils.equal((double)this.accrualFactor, (double)other.accrualFactor) && JodaBeanUtils.equal((Object)this.lastTradeDate, (Object)other.lastTradeDate) && JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)((Object)this.accrualMethod), (Object)((Object)other.accrualMethod)) && JodaBeanUtils.equal((Object)this.rounding, (Object)other.rounding);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.info);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.notional);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.accrualFactor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastTradeDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.accrualMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rounding);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("OvernightFutureSecurity{");
        buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
        buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
        buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor)).append(',').append(' ');
        buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
        buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
        buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("accrualMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualMethod))).append(',').append(' ');
        buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.getCurrency()));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<OvernightFutureSecurity> {
        private SecurityInfo info;
        private double notional;
        private double accrualFactor;
        private LocalDate lastTradeDate;
        private LocalDate startDate;
        private LocalDate endDate;
        private OvernightIndex index;
        private OvernightAccrualMethod accrualMethod;
        private Rounding rounding;

        private Builder() {
        }

        private Builder(OvernightFutureSecurity beanToCopy) {
            this.info = beanToCopy.getInfo();
            this.notional = beanToCopy.getNotional();
            this.accrualFactor = beanToCopy.getAccrualFactor();
            this.lastTradeDate = beanToCopy.getLastTradeDate();
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.index = beanToCopy.getIndex();
            this.accrualMethod = beanToCopy.getAccrualMethod();
            this.rounding = beanToCopy.getRounding();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 100346066: {
                    return this.index;
                }
                case -1335729296: {
                    return this.accrualMethod;
                }
                case -142444: {
                    return this.rounding;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    this.info = (SecurityInfo)newValue;
                    break;
                }
                case 1585636160: {
                    this.notional = (Double)newValue;
                    break;
                }
                case -1540322338: {
                    this.accrualFactor = (Double)newValue;
                    break;
                }
                case -1041950404: {
                    this.lastTradeDate = (LocalDate)newValue;
                    break;
                }
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (OvernightIndex)newValue;
                    break;
                }
                case -1335729296: {
                    this.accrualMethod = (OvernightAccrualMethod)((Object)newValue);
                    break;
                }
                case -142444: {
                    this.rounding = (Rounding)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public OvernightFutureSecurity build() {
            return new OvernightFutureSecurity(this.info, this.notional, this.accrualFactor, this.lastTradeDate, this.startDate, this.endDate, this.index, this.accrualMethod, this.rounding);
        }

        public Builder info(SecurityInfo info) {
            JodaBeanUtils.notNull((Object)info, (String)"info");
            this.info = info;
            return this;
        }

        public Builder notional(double notional) {
            ArgChecker.notNegativeOrZero((double)notional, (String)"notional");
            this.notional = notional;
            return this;
        }

        public Builder accrualFactor(double accrualFactor) {
            ArgChecker.notNegativeOrZero((double)accrualFactor, (String)"accrualFactor");
            this.accrualFactor = accrualFactor;
            return this;
        }

        public Builder lastTradeDate(LocalDate lastTradeDate) {
            JodaBeanUtils.notNull((Object)lastTradeDate, (String)"lastTradeDate");
            this.lastTradeDate = lastTradeDate;
            return this;
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder index(OvernightIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder accrualMethod(OvernightAccrualMethod accrualMethod) {
            JodaBeanUtils.notNull((Object)((Object)accrualMethod), (String)"accrualMethod");
            this.accrualMethod = accrualMethod;
            return this;
        }

        public Builder rounding(Rounding rounding) {
            JodaBeanUtils.notNull((Object)rounding, (String)"rounding");
            this.rounding = rounding;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("OvernightFutureSecurity.Builder{");
            buf.append("info").append('=').append(JodaBeanUtils.toString((Object)this.info)).append(',').append(' ');
            buf.append("notional").append('=').append(JodaBeanUtils.toString((Object)this.notional)).append(',').append(' ');
            buf.append("accrualFactor").append('=').append(JodaBeanUtils.toString((Object)this.accrualFactor)).append(',').append(' ');
            buf.append("lastTradeDate").append('=').append(JodaBeanUtils.toString((Object)this.lastTradeDate)).append(',').append(' ');
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("accrualMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualMethod))).append(',').append(' ');
            buf.append("rounding").append('=').append(JodaBeanUtils.toString((Object)this.rounding)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString(null));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<SecurityInfo> info = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"info", OvernightFutureSecurity.class, SecurityInfo.class);
        private final MetaProperty<Double> notional = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notional", OvernightFutureSecurity.class, Double.TYPE);
        private final MetaProperty<Double> accrualFactor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualFactor", OvernightFutureSecurity.class, Double.TYPE);
        private final MetaProperty<LocalDate> lastTradeDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastTradeDate", OvernightFutureSecurity.class, LocalDate.class);
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", OvernightFutureSecurity.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", OvernightFutureSecurity.class, LocalDate.class);
        private final MetaProperty<OvernightIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", OvernightFutureSecurity.class, OvernightIndex.class);
        private final MetaProperty<OvernightAccrualMethod> accrualMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualMethod", OvernightFutureSecurity.class, OvernightAccrualMethod.class);
        private final MetaProperty<Rounding> rounding = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rounding", OvernightFutureSecurity.class, Rounding.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofDerived((MetaBean)this, (String)"currency", OvernightFutureSecurity.class, Currency.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"info", "notional", "accrualFactor", "lastTradeDate", "startDate", "endDate", "index", "accrualMethod", "rounding", "currency"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return this.info;
                }
                case 1585636160: {
                    return this.notional;
                }
                case -1540322338: {
                    return this.accrualFactor;
                }
                case -1041950404: {
                    return this.lastTradeDate;
                }
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case 100346066: {
                    return this.index;
                }
                case -1335729296: {
                    return this.accrualMethod;
                }
                case -142444: {
                    return this.rounding;
                }
                case 575402001: {
                    return this.currency;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends OvernightFutureSecurity> beanType() {
            return OvernightFutureSecurity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<SecurityInfo> info() {
            return this.info;
        }

        public MetaProperty<Double> notional() {
            return this.notional;
        }

        public MetaProperty<Double> accrualFactor() {
            return this.accrualFactor;
        }

        public MetaProperty<LocalDate> lastTradeDate() {
            return this.lastTradeDate;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<OvernightIndex> index() {
            return this.index;
        }

        public MetaProperty<OvernightAccrualMethod> accrualMethod() {
            return this.accrualMethod;
        }

        public MetaProperty<Rounding> rounding() {
            return this.rounding;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3237038: {
                    return ((OvernightFutureSecurity)bean).getInfo();
                }
                case 1585636160: {
                    return ((OvernightFutureSecurity)bean).getNotional();
                }
                case -1540322338: {
                    return ((OvernightFutureSecurity)bean).getAccrualFactor();
                }
                case -1041950404: {
                    return ((OvernightFutureSecurity)bean).getLastTradeDate();
                }
                case -2129778896: {
                    return ((OvernightFutureSecurity)bean).getStartDate();
                }
                case -1607727319: {
                    return ((OvernightFutureSecurity)bean).getEndDate();
                }
                case 100346066: {
                    return ((OvernightFutureSecurity)bean).getIndex();
                }
                case -1335729296: {
                    return ((OvernightFutureSecurity)bean).getAccrualMethod();
                }
                case -142444: {
                    return ((OvernightFutureSecurity)bean).getRounding();
                }
                case 575402001: {
                    return ((OvernightFutureSecurity)bean).getCurrency();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

